/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.xpointer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.woden.types.NCName;
import org.apache.woden.xpointer.InvalidXPointerException;
import org.apache.woden.xpointer.PointerPart;
import org.apache.woden.xpointer.XPointerParser;

public class XPointer {
    private static final String emptyString = "".intern();
    private final Map<NCName, String> prefixBindingContex;
    private final Map<String, NCName> namespaceBindingContex;
    private NCName shorthandPointer;
    private final List<PointerPart> pointerParts = new ArrayList<PointerPart>();
    private static final NCName emptyNCName = new NCName(emptyString);
    private static final String NS_URI_XML = "http://www.w3.org/XML/1998/namespace";
    private static final String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";
    private static final NCName NS_PREFIX_XMLNS = new NCName("xmlns");

    public XPointer() {
        this.shorthandPointer = emptyNCName;
        this.prefixBindingContex = new HashMap<NCName, String>();
        this.namespaceBindingContex = new HashMap<String, NCName>();
        this.addPrefixNamespaceBinding(new NCName("xml"), NS_URI_XML);
    }

    public XPointer(String xpointerString) throws InvalidXPointerException {
        this();
        if (xpointerString == null || xpointerString.equals(emptyString)) {
            throw new InvalidXPointerException("The XPointer string is either null or empty", emptyString);
        }
        XPointerParser.parseXPointer(xpointerString, this);
    }

    public void addPointerPart(PointerPart pointerPart) {
        if (!this.shorthandPointer.equals(emptyNCName)) {
            throw new UnsupportedOperationException("A Shortname Pointer already exists for this XPointer.");
        }
        this.pointerParts.add(pointerPart);
    }

    public void addPointerPart(int index, PointerPart pointerPart) {
        if (this.hasShorthandPointer()) {
            throw new UnsupportedOperationException("A Shortname Pointer already exists for this XPointer.");
        }
        if (index < 0 || index > this.pointerParts.size()) {
            throw new IndexOutOfBoundsException("The index you gave is out of the bounds of the list of XPointers");
        }
        this.pointerParts.add(index, pointerPart);
    }

    public Object[] getPointerParts() {
        if (this.hasPointerParts()) {
            int size = this.pointerParts.size();
            Object[] parts = new Object[size];
            for (int i = 0; i < size; ++i) {
                parts[i] = this.pointerParts.get(i);
            }
            return parts;
        }
        throw new IllegalStateException("This XPointer has a shorthand pointer.");
    }

    public void setShorthandPointer(NCName shorthandPointer) {
        if (this.hasPointerParts()) {
            throw new UnsupportedOperationException("A PointerPart Pointer already exists for this XPointer");
        }
        if (shorthandPointer.equals(null)) {
            throw new NullPointerException("The shorthandPointer argument is null");
        }
        this.shorthandPointer = shorthandPointer;
    }

    public NCName getShorthandPointer() {
        if (this.hasShorthandPointer()) {
            return this.shorthandPointer;
        }
        throw new IllegalStateException("This XPointer has scheme based pointers.");
    }

    public void addPrefixNamespaceBinding(NCName prefix, String namespace) {
        if (prefix == null) {
            throw new NullPointerException("The prefix argument provided has a null pointer.");
        }
        if (namespace == null) {
            throw new NullPointerException("The namespace argument provided has a null pointer.");
        }
        if (prefix.equals(NS_PREFIX_XMLNS)) {
            throw new IllegalArgumentException("The xmlns prefix must not be bound to any namespace.");
        }
        if (namespace.equals(NS_URI_XMLNS)) {
            throw new IllegalArgumentException("The http://www.w3.org/2000/xmlns/ namespace must not be bound to any prefix.");
        }
        this.prefixBindingContex.put(prefix, namespace);
        this.namespaceBindingContex.put(namespace, prefix);
    }

    public String getPrefixBinding(NCName prefix) {
        return this.prefixBindingContex.get(prefix);
    }

    public NCName getNamespaceBinding(String namespace) {
        return this.namespaceBindingContex.get(namespace);
    }

    public boolean hasPrefixBinding(NCName prefix) {
        return this.prefixBindingContex.containsKey(prefix);
    }

    public boolean hasNamespaceBinding(String namespace) {
        return this.namespaceBindingContex.containsKey(namespace);
    }

    public boolean hasShorthandPointer() {
        return !this.shorthandPointer.equals(emptyNCName);
    }

    public boolean hasPointerParts() {
        return !this.pointerParts.isEmpty();
    }

    public String toString() {
        if (this.shorthandPointer.equals(emptyNCName)) {
            StringBuffer buffer = new StringBuffer();
            Iterator<PointerPart> parts = this.pointerParts.iterator();
            while (parts.hasNext()) {
                buffer.append(parts.next());
            }
            return buffer.toString();
        }
        return this.shorthandPointer.toString();
    }
}

