/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shaded.common.security.authenticator;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.apache.kafka.shaded.common.network.Mode;
import org.apache.kafka.shaded.common.security.auth.AuthCallbackHandler;
import org.apache.kafka.shaded.common.security.kerberos.KerberosName;
import org.apache.kafka.shaded.common.security.kerberos.KerberosShortNamer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslServerCallbackHandler
implements AuthCallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SaslServerCallbackHandler.class);
    private final KerberosShortNamer kerberosShortNamer;

    public SaslServerCallbackHandler(Configuration configuration, KerberosShortNamer kerberosNameParser) throws IOException {
        AppConfigurationEntry[] configurationEntries = configuration.getAppConfigurationEntry("KafkaServer");
        if (configurationEntries == null) {
            throw new IOException("Could not find a 'KafkaServer' entry in this configuration: Kafka Server cannot start.");
        }
        this.kerberosShortNamer = kerberosNameParser;
    }

    @Override
    public void configure(Map<String, ?> configs, Mode mode, Subject subject, String saslMechanism) {
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof RealmCallback) {
                this.handleRealmCallback((RealmCallback)callback);
                continue;
            }
            if (!(callback instanceof AuthorizeCallback)) continue;
            this.handleAuthorizeCallback((AuthorizeCallback)callback);
        }
    }

    private void handleRealmCallback(RealmCallback rc) {
        LOG.trace("Client supplied realm: {} ", (Object)rc.getDefaultText());
        rc.setText(rc.getDefaultText());
    }

    private void handleAuthorizeCallback(AuthorizeCallback ac) {
        String authenticationID = ac.getAuthenticationID();
        String authorizationID = ac.getAuthorizationID();
        LOG.info("Successfully authenticated client: authenticationID={}; authorizationID={}.", (Object)authenticationID, (Object)authorizationID);
        ac.setAuthorized(true);
        KerberosName kerberosName = KerberosName.parse(authenticationID);
        try {
            String userName = this.kerberosShortNamer.shortName(kerberosName);
            LOG.info("Setting authorizedID: {}", (Object)userName);
            ac.setAuthorizedID(userName);
        }
        catch (IOException e) {
            LOG.error("Failed to set name for '{}' based on Kerberos authentication rules.", (Object)kerberosName, (Object)e);
        }
    }

    @Override
    public void close() {
    }
}

