/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;

public class DropSchemaNode
extends DDLStatementNode {
    private int dropBehavior;
    private String schemaName;

    public void init(Object object, Object object2) throws StandardException {
        this.initAndCheck(null);
        this.schemaName = (String)object;
        this.dropBehavior = (Integer)object2;
    }

    public void bindStatement() throws StandardException {
        if (this.getDataDictionary().isSystemSchemaName(this.schemaName)) {
            throw StandardException.newException("42Y67", this.schemaName);
        }
        if (this.isPrivilegeCollectionRequired()) {
            LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
            StatementContext statementContext = languageConnectionContext.getStatementContext();
            String string = statementContext.getSQLSessionContext().getCurrentUser();
            this.getCompilerContext().addRequiredSchemaPriv(this.schemaName, string, 18);
        }
    }

    public String toString() {
        return "";
    }

    public String statementToString() {
        return "DROP SCHEMA";
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropSchemaConstantAction(this.schemaName);
    }
}

