/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scriptingbundle.plugin.processor;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.sling.api.resource.type.ResourceType;
import org.apache.sling.scriptingbundle.plugin.capability.Capabilities;
import org.apache.sling.scriptingbundle.plugin.capability.ProvidedResourceTypeCapability;
import org.apache.sling.scriptingbundle.plugin.capability.RequiredResourceTypeCapability;
import org.apache.sling.scriptingbundle.plugin.processor.FileProcessor;
import org.apache.sling.scriptingbundle.plugin.processor.Logger;
import org.apache.sling.scriptingbundle.plugin.processor.ResourceTypeFolderPredicate;
import org.jetbrains.annotations.NotNull;

public class ResourceTypeFolderAnalyser {
    private final Logger logger;
    private final Path scriptsDirectory;
    private final ResourceTypeFolderPredicate resourceTypeFolderPredicate;
    private final FileProcessor fileProcessor;
    private final boolean inContentPackage;

    public ResourceTypeFolderAnalyser(@NotNull Logger logger, @NotNull Path scriptsDirectory, @NotNull FileProcessor fileProcessor, boolean inContentPackage) {
        this.logger = logger;
        this.scriptsDirectory = scriptsDirectory;
        this.resourceTypeFolderPredicate = new ResourceTypeFolderPredicate(logger, inContentPackage);
        this.fileProcessor = fileProcessor;
        this.inContentPackage = inContentPackage;
    }

    public Capabilities getCapabilities(@NotNull Path resourceTypeDirectory) {
        LinkedHashSet<ProvidedResourceTypeCapability> providedCapabilities = new LinkedHashSet<ProvidedResourceTypeCapability>();
        LinkedHashSet<RequiredResourceTypeCapability> requiredCapabilities = new LinkedHashSet<RequiredResourceTypeCapability>();
        if (resourceTypeDirectory.startsWith(this.scriptsDirectory) && this.resourceTypeFolderPredicate.test(resourceTypeDirectory)) {
            try (DirectoryStream<Path> resourceTypeDirectoryStream = Files.newDirectoryStream(resourceTypeDirectory);){
                Path relativeResourceTypeDirectory = this.scriptsDirectory.relativize(resourceTypeDirectory);
                ResourceType resourceType = ResourceType.parseResourceType((String)FilenameUtils.normalize((String)(this.inContentPackage ? PlatformNameFormat.getRepositoryPath((String)relativeResourceTypeDirectory.toString()) : relativeResourceTypeDirectory.toString()), (boolean)true));
                resourceTypeDirectoryStream.forEach(entry -> {
                    if (Files.isRegularFile(entry, new LinkOption[0])) {
                        Path file2 = entry.getFileName();
                        if (file2 != null) {
                            if ("extends".equals(file2.toString())) {
                                this.fileProcessor.processExtendsFile(resourceType, (Path)entry, (Set<ProvidedResourceTypeCapability>)providedCapabilities, (Set<RequiredResourceTypeCapability>)requiredCapabilities);
                            } else if ("requires".equals(file2.toString())) {
                                this.fileProcessor.processRequiresFile((Path)entry, (Set<RequiredResourceTypeCapability>)requiredCapabilities);
                            } else if (".content.xml".equals(file2.toString())) {
                                this.fileProcessor.processVaultFile((Path)entry, resourceType, (Set<ProvidedResourceTypeCapability>)providedCapabilities, (Set<RequiredResourceTypeCapability>)requiredCapabilities);
                            } else {
                                this.fileProcessor.processScriptFile(resourceTypeDirectory, (Path)entry, resourceType, (Set<ProvidedResourceTypeCapability>)providedCapabilities, this.inContentPackage);
                            }
                        }
                    } else if (Files.isDirectory(entry, new LinkOption[0]) && !this.resourceTypeFolderPredicate.test((Path)entry)) {
                        try (Stream<Path> selectorFilesStream = Files.walk(entry, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> {
                            Path fileParent = file.getParent();
                            while (!resourceTypeDirectory.equals(fileParent)) {
                                if (this.resourceTypeFolderPredicate.test(fileParent)) {
                                    return false;
                                }
                                fileParent = fileParent.getParent();
                            }
                            return true;
                        });){
                            selectorFilesStream.forEach(file -> this.fileProcessor.processScriptFile(resourceTypeDirectory, (Path)file, resourceType, providedCapabilities, this.inContentPackage));
                        }
                        catch (IOException e) {
                            this.logger.error(String.format("Unable to scan folder %s.", entry.toString()), e);
                        }
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return new Capabilities(providedCapabilities, Collections.emptySet(), requiredCapabilities);
    }
}

