/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.impl.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.sling.validation.spi.Validator;

public class ValidatorTypeUtil {
    @Nonnull
    public static Class<?> getValidatorType(Validator<?> validator) {
        Map typeMap = TypeUtils.getTypeArguments(validator.getClass(), Validator.class);
        Class<?> type = null;
        for (Map.Entry entry : typeMap.entrySet()) {
            Class clazz;
            type = (Class<?>)entry.getValue();
            if (!(((TypeVariable)entry.getKey()).getGenericDeclaration() instanceof Class) || !(clazz = (Class)((TypeVariable)entry.getKey()).getGenericDeclaration()).equals(Validator.class)) continue;
            if (type instanceof GenericArrayType) {
                type = Array.newInstance((Class)((GenericArrayType)((Object)type)).getGenericComponentType(), 0).getClass();
            }
            if (type instanceof Class) {
                return type;
            }
            throw new IllegalArgumentException("Validators may not use parameterized types as type parameter. Only simple class types and arrays of class types are allowed.");
        }
        throw new IllegalArgumentException("Validator '" + validator + "' has not valid type parameter!");
    }
}

