/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.impl.postprocessor;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.validation.ValidationFailure;
import org.apache.sling.validation.ValidationResult;

public class InvalidResourcePostProcessorException
extends RuntimeException {
    private static final long serialVersionUID = 213928457248325245L;
    @Nonnull
    private final ValidationResult result;
    @Nonnull
    private final ResourceBundle resourceBundle;
    private static final String KEY_MESSAGE = "sling.validator.invalid-resource-post-processor-exception";

    public InvalidResourcePostProcessorException(@Nonnull ValidationResult result, ResourceBundle resourceBundle) {
        this.result = result;
        this.resourceBundle = resourceBundle;
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (ValidationFailure failure : this.result.getFailures()) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            if (StringUtils.isNotEmpty((CharSequence)failure.getLocation())) {
                builder.append(failure.getLocation() + " : ");
            }
            builder.append(failure.getMessage(this.resourceBundle));
        }
        return MessageFormat.format(this.resourceBundle.getString(KEY_MESSAGE), builder.toString());
    }
}

