/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.state;

import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sling-mock-oak.com.google.common.base.Preconditions;
import sling-mock-oak.com.google.common.base.Strings;

public final class NodeStateUtils {
    private NodeStateUtils() {
    }

    public static boolean isHidden(@NotNull String name) {
        return !name.isEmpty() && name.charAt(0) == ':';
    }

    public static boolean isHiddenPath(@NotNull String path) {
        for (String n : PathUtils.elements(path)) {
            if (!NodeStateUtils.isHidden(n)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getPrimaryTypeName(NodeState nodeState) {
        PropertyState ps = nodeState.getProperty("jcr:primaryType");
        return ps == null ? null : ps.getValue(Type.NAME);
    }

    @NotNull
    public static NodeState getNode(@NotNull NodeState node, @NotNull String path) {
        for (String name : PathUtils.elements(Preconditions.checkNotNull(path))) {
            node = node.getChildNode(Preconditions.checkNotNull(name));
        }
        return node;
    }

    public static String toString(NodeState node) {
        if (node == null) {
            return "[null]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(NodeStateUtils.toString(node, 1, "  ", "/"));
        return sb.toString();
    }

    private static String toString(NodeState ns, int level, String prepend, String name) {
        StringBuilder node = new StringBuilder();
        node.append(Strings.repeat(prepend, level)).append(name);
        StringBuilder props = new StringBuilder();
        boolean first = true;
        for (PropertyState propertyState : ns.getProperties()) {
            if (!first) {
                props.append(", ");
            } else {
                first = false;
            }
            props.append(propertyState);
        }
        if (props.length() > 0) {
            node.append("{");
            node.append((CharSequence)props);
            node.append("}");
        }
        for (ChildNodeEntry childNodeEntry : ns.getChildNodeEntries()) {
            node.append(IOUtils.LINE_SEPARATOR);
            node.append(NodeStateUtils.toString(childNodeEntry.getNodeState(), level + 1, prepend, childNodeEntry.getName()));
        }
        return node.toString();
    }
}

