/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.restriction;

import java.util.List;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompositePattern
implements RestrictionPattern {
    private final List<RestrictionPattern> patterns;

    public CompositePattern(@NotNull List<RestrictionPattern> patterns) {
        this.patterns = patterns;
    }

    public static RestrictionPattern create(@NotNull List<RestrictionPattern> patterns) {
        switch (patterns.size()) {
            case 0: {
                return RestrictionPattern.EMPTY;
            }
            case 1: {
                return patterns.get(0);
            }
        }
        return new CompositePattern(patterns);
    }

    @Override
    public boolean matches(@NotNull Tree tree, @Nullable PropertyState property) {
        for (RestrictionPattern pattern : this.patterns) {
            if (pattern.matches(tree, property)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(@NotNull String path) {
        for (RestrictionPattern pattern : this.patterns) {
            if (pattern.matches(path)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches() {
        for (RestrictionPattern pattern : this.patterns) {
            if (pattern.matches()) continue;
            return false;
        }
        return true;
    }
}

