/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.stats;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRecorder {
    private static final Logger LOG = LoggerFactory.getLogger(QueryRecorder.class);
    private static final HashMap<String, Integer> RECORD_QUERIES_MAP = new HashMap();
    private static final int QUERIES_MAX = Integer.getInteger("oak.query.record", 5000);

    public static void main(String ... args) throws IOException {
        String line;
        LineNumberReader reader = new LineNumberReader(new BufferedReader(new FileReader(args[0])));
        TreeSet<String> sorted = new TreeSet<String>();
        int lineCount = 0;
        while ((line = reader.readLine()) != null) {
            sorted.add(QueryRecorder.simplify(line));
            ++lineCount;
        }
        reader.close();
        for (String s : sorted) {
            System.out.println(s);
        }
        System.out.println("sorted: " + sorted.size() + " original: " + lineCount);
    }

    public static void record(String query, boolean internal) {
        if (internal) {
            return;
        }
        if (!LOG.isDebugEnabled()) {
            return;
        }
        query = query.replace('\n', ' ');
        query = query.replace('\t', ' ');
        if (LOG.isTraceEnabled()) {
            LOG.trace("query:\t{}", (Object)query);
        }
        try {
            query = QueryRecorder.simplify(query);
        }
        catch (Exception e) {
            LOG.trace("failed to simplify {}", (Object)query, (Object)e);
        }
        QueryRecorder.record(query);
    }

    public static String simplify(String query) {
        query = query.replaceAll("'[^']*'", "'x'");
        int pathIndex = (query = query.replaceAll("ISDESCENDANTNODE\\(\\[/[^]]*\\]\\)", "ISDESCENDANTNODE('x')")).indexOf("/jcr:root/");
        if (pathIndex >= 0) {
            String newQuery;
            int end;
            int start = pathIndex + "/jcr:root/".length();
            String path = query.substring(start, end = QueryRecorder.getFirstOccurance(query, start, " ", "/element(", "/text(", "/*", "/(", "/jcr:deref("));
            int first = path.indexOf(47);
            if (first > 0 && (first = path.indexOf(47, first + 1)) > 0) {
                path = path.substring(0, first + 1) + "...";
            }
            query = newQuery = query.substring(0, pathIndex) + "/jcr:root/" + path + query.substring(end, query.length());
        }
        return query;
    }

    static int getFirstOccurance(String text, int start, String ... strings) {
        int first = text.length();
        for (String s : strings) {
            int index = text.indexOf(s, start + 1);
            if (index <= 0 || index >= first) continue;
            first = index;
        }
        return first;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void record(String query) {
        Integer count;
        Object object;
        HashMap<String, Integer> map = RECORD_QUERIES_MAP;
        if (map.size() > QUERIES_MAX) {
            HashMap<String, Integer> old;
            object = map;
            synchronized (object) {
                old = new HashMap<String, Integer>(map);
                map.clear();
            }
            for (Map.Entry entry : old.entrySet()) {
                QueryRecorder.log((String)entry.getKey(), (Integer)entry.getValue());
            }
        }
        object = map;
        synchronized (object) {
            count = map.get(query);
            count = count == null ? 1 : count + 1;
            map.put(query, count);
        }
        if (count == 1 || count % 100 == 0) {
            QueryRecorder.log(query, count);
        }
    }

    private static void log(String query, int count) {
        LOG.debug("count:\t{}\tquery:\t{}", (Object)count, (Object)query);
    }
}

