/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.LazyValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.core.ImmutableRoot;
import org.apache.jackrabbit.oak.plugins.index.Cursors;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.query.ExecutionContext;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.QueryImpl;
import org.apache.jackrabbit.oak.query.QueryOptions;
import org.apache.jackrabbit.oak.query.RuntimeNodeTraversalException;
import org.apache.jackrabbit.oak.query.ast.AndImpl;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.ColumnImpl;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.JoinConditionImpl;
import org.apache.jackrabbit.oak.query.ast.NodeTypeInfo;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.query.plan.ExecutionPlan;
import org.apache.jackrabbit.oak.query.plan.SelectorExecutionPlan;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.HistogramStats;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sling-mock-oak.com.google.common.base.Preconditions;
import sling-mock-oak.com.google.common.collect.ImmutableSet;
import sling-mock-oak.com.google.common.collect.Iterables;
import sling-mock-oak.com.google.common.collect.Lists;

public class SelectorImpl
extends SourceImpl {
    private static final Logger LOG = LoggerFactory.getLogger(SelectorImpl.class);
    private static final Boolean TIMER_DISABLED = Boolean.getBoolean("oak.query.timerDisabled");
    private static final Long TIMER_SAMPLE_RATE = Long.getLong("oak.query.timerSampleRate", 256L);
    private static final long SLOW_QUERY_HISTOGRAM = 1L;
    private static final long TOTAL_QUERY_HISTOGRAM = 0L;
    private static final String SLOW_QUERY_PERCENTILE_METRICS_NAME = "SLOW_QUERY_PERCENTILE_METRICS";
    private static final String SLOW_QUERY_COUNT_NAME = "SLOW_QUERY_COUNT";
    private static long timerSampleCounter;
    private SelectorExecutionPlan plan;
    private ConstraintImpl queryConstraint;
    private JoinConditionImpl joinCondition;
    private final NodeTypeInfo nodeTypeInfo;
    private final String selectorName;
    private final String nodeTypeName;
    private final boolean matchesAllTypes;
    private final Set<String> supertypes;
    private final Set<String> primaryTypes;
    private final Set<String> mixinTypes;
    private boolean isParent;
    private boolean outerJoinLeftHandSide;
    private boolean outerJoinRightHandSide;
    private ArrayList<JoinConditionImpl> allJoinConditions = new ArrayList();
    private final List<ConstraintImpl> selectorConstraints = Lists.newArrayList();
    private Cursor cursor;
    private IndexRow currentRow;
    private int scanCount;
    private String planIndexName;
    private TimerStats timerDuration;
    private CachedTree cachedTree;
    private boolean updateTotalQueryHistogram = true;

    public SelectorImpl(NodeTypeInfo nodeTypeInfo, String selectorName) {
        this.nodeTypeInfo = Preconditions.checkNotNull(nodeTypeInfo);
        this.selectorName = Preconditions.checkNotNull(selectorName);
        this.nodeTypeName = nodeTypeInfo.getNodeTypeName();
        this.matchesAllTypes = "nt:base".equals(this.nodeTypeName);
        if (!this.matchesAllTypes) {
            this.supertypes = nodeTypeInfo.getSuperTypes();
            this.supertypes.add(this.nodeTypeName);
            this.primaryTypes = nodeTypeInfo.getPrimarySubTypes();
            this.mixinTypes = nodeTypeInfo.getMixinSubTypes();
            if (nodeTypeInfo.isMixin()) {
                this.mixinTypes.add(this.nodeTypeName);
            } else {
                this.primaryTypes.add(this.nodeTypeName);
            }
        } else {
            this.supertypes = ImmutableSet.of();
            this.primaryTypes = ImmutableSet.of();
            this.mixinTypes = ImmutableSet.of();
        }
    }

    public String getSelectorName() {
        return this.selectorName;
    }

    public String getNodeType() {
        return this.nodeTypeName;
    }

    public boolean matchesAllTypes() {
        return this.matchesAllTypes;
    }

    @NotNull
    public Set<String> getSupertypes() {
        return this.supertypes;
    }

    @NotNull
    public Set<String> getPrimaryTypes() {
        return this.primaryTypes;
    }

    @NotNull
    public Set<String> getMixinTypes() {
        return this.mixinTypes;
    }

    public Iterable<String> getWildcardColumns() {
        return this.nodeTypeInfo.getNamesSingleValuesProperties();
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return this.quote(this.nodeTypeName) + " as " + this.quote(this.selectorName);
    }

    public boolean isPrepared() {
        return this.plan != null;
    }

    @Override
    public void unprepare() {
        this.plan = null;
        this.planIndexName = null;
        this.timerDuration = null;
        this.selectorConstraints.clear();
        this.isParent = false;
        this.joinCondition = null;
        this.allJoinConditions.clear();
    }

    @Override
    public void prepare(ExecutionPlan p) {
        if (!(p instanceof SelectorExecutionPlan)) {
            throw new IllegalArgumentException("Not a selector plan");
        }
        SelectorExecutionPlan selectorPlan = (SelectorExecutionPlan)p;
        if (selectorPlan.getSelector() != this) {
            throw new IllegalArgumentException("Not a plan for this selector");
        }
        this.pushDown();
        this.plan = selectorPlan;
    }

    private void pushDown() {
        if (this.queryConstraint != null) {
            this.queryConstraint.restrictPushDown(this);
        }
        if (!this.outerJoinLeftHandSide && !this.outerJoinRightHandSide) {
            for (JoinConditionImpl c : this.allJoinConditions) {
                c.restrictPushDown(this);
            }
        }
    }

    @Override
    public ExecutionPlan prepare() {
        if (this.plan != null) {
            return this.plan;
        }
        this.pushDown();
        this.plan = this.query.getBestSelectorExecutionPlan(this.createFilter(true));
        return this.plan;
    }

    public SelectorExecutionPlan getExecutionPlan() {
        return this.plan;
    }

    @Override
    public void setQueryConstraint(ConstraintImpl queryConstraint) {
        this.queryConstraint = queryConstraint;
    }

    @Override
    public void setOuterJoin(boolean outerJoinLeftHandSide, boolean outerJoinRightHandSide) {
        this.outerJoinLeftHandSide = outerJoinLeftHandSide;
        this.outerJoinRightHandSide = outerJoinRightHandSide;
    }

    @Override
    public void addJoinCondition(JoinConditionImpl joinCondition, boolean forThisSelector) {
        if (forThisSelector) {
            this.joinCondition = joinCondition;
        }
        this.allJoinConditions.add(joinCondition);
        if (joinCondition.isParent(this)) {
            this.isParent = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(NodeState rootState) {
        long start = this.startTimer();
        try {
            this.executeInternal(rootState);
        }
        finally {
            this.stopTimer(start, true);
        }
    }

    private void executeInternal(NodeState rootState) {
        QueryIndex index = this.plan.getIndex();
        this.timerDuration = null;
        if (index == null) {
            this.cursor = Cursors.newPathCursor(new ArrayList<String>(), this.query.getSettings());
            this.planIndexName = "traverse";
            return;
        }
        QueryIndex.IndexPlan p = this.plan.getIndexPlan();
        if (p != null) {
            this.planIndexName = p.getPlanName();
            p.setFilter(this.createFilter(false));
            QueryIndex.AdvancedQueryIndex adv = (QueryIndex.AdvancedQueryIndex)((Object)index);
            this.cursor = adv.query(p, rootState);
        } else {
            FilterImpl f = this.createFilter(false);
            this.planIndexName = index.getIndexName(f, rootState);
            this.cursor = index.query(f, rootState);
        }
    }

    private long startTimer() {
        if (TIMER_DISABLED.booleanValue()) {
            return -1L;
        }
        return System.nanoTime();
    }

    private void stopTimer(long start, boolean execute) {
        if (start == -1L) {
            return;
        }
        long timeNanos = System.nanoTime() - start;
        if (timeNanos > 1000000L) {
            this.measure(timeNanos);
        } else if ((timerSampleCounter++ & TIMER_SAMPLE_RATE - 1L) == 0L) {
            this.measure(timeNanos * TIMER_SAMPLE_RATE);
        }
    }

    private void measure(long timeNanos) {
        TimerStats t = this.timerDuration;
        if (t == null) {
            t = this.timerDuration = this.query.getSettings().getStatisticsProvider().getTimer("QUERY_DURATION_" + this.planIndexName, StatsOptions.METRICS_ONLY);
        }
        t.update(timeNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public String getPlan(NodeState rootState) {
        StringBuilder buff = new StringBuilder();
        buff.append(this.toString());
        buff.append(" /* ");
        QueryIndex index = this.getIndex();
        if (index != null) {
            if (index instanceof QueryIndex.AdvancedQueryIndex) {
                QueryIndex.AdvancedQueryIndex adv = (QueryIndex.AdvancedQueryIndex)((Object)index);
                QueryIndex.IndexPlan p = this.plan.getIndexPlan();
                buff.append(adv.getPlanDescription(p, rootState));
            } else {
                buff.append(index.getPlan(this.createFilter(true), rootState));
            }
        } else {
            buff.append("no-index");
        }
        if (!this.selectorConstraints.isEmpty()) {
            buff.append(" where ").append(new AndImpl(this.selectorConstraints).toString());
        }
        buff.append(" */");
        return buff.toString();
    }

    @Override
    public String getIndexCostInfo(NodeState rootState) {
        StringBuilder buff = new StringBuilder();
        buff.append(this.quoteJson(this.selectorName)).append(": ");
        QueryIndex index = this.getIndex();
        if (index != null) {
            if (index instanceof QueryIndex.AdvancedQueryIndex) {
                QueryIndex.IndexPlan p = this.plan.getIndexPlan();
                buff.append("{ perEntry: ").append(p.getCostPerEntry());
                buff.append(", perExecution: ").append(p.getCostPerExecution());
                buff.append(", count: ").append(p.getEstimatedEntryCount());
                buff.append(" }");
            } else {
                buff.append(index.getCost(this.createFilter(true), rootState));
            }
        }
        return buff.toString();
    }

    @Override
    public FilterImpl createFilter(boolean preparing) {
        FilterImpl f = new FilterImpl(this, this.query.getStatement(), this.query.getSettings());
        f.setPreparing(preparing);
        if (this.joinCondition != null) {
            this.joinCondition.restrict(f);
        }
        for (ColumnImpl c : this.query.getColumns()) {
            if (!c.getSelector().equals(this)) continue;
            String columnName = c.getColumnName();
            if (columnName.equals("oak:scoreExplanation")) {
                f.restrictProperty(columnName, Operator.NOT_EQUAL, null);
                continue;
            }
            if (columnName.startsWith("rep:excerpt")) {
                f.restrictProperty("rep:excerpt", Operator.EQUAL, PropertyValues.newString(columnName));
                continue;
            }
            if (!columnName.startsWith("rep:facet")) continue;
            f.restrictProperty("rep:facet", Operator.EQUAL, PropertyValues.newString(columnName));
        }
        if (this.queryConstraint != null) {
            this.queryConstraint.restrict(f);
            FullTextExpression ft = this.queryConstraint.getFullTextConstraint(this);
            f.setFullTextConstraint(ft);
        }
        for (ConstraintImpl constraint : this.selectorConstraints) {
            constraint.restrict(f);
        }
        QueryOptions options = this.query.getQueryOptions();
        if (options != null) {
            if (options.indexName != null) {
                f.restrictProperty(":indexName", Operator.EQUAL, PropertyValues.newString(options.indexName));
            }
            if (options.indexTag != null) {
                f.restrictProperty(":indexTag", Operator.EQUAL, PropertyValues.newString(options.indexTag));
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() {
        long start = this.startTimer();
        try {
            boolean bl = this.nextInternal();
            return bl;
        }
        finally {
            this.stopTimer(start, true);
        }
    }

    private boolean nextInternal() {
        while (this.cursor != null && this.cursor.hasNext()) {
            ++this.scanCount;
            this.query.getQueryExecutionStats().scan(1L, this.scanCount);
            try {
                this.totalQueryStats(this.query.getSettings());
                this.currentRow = this.cursor.next();
            }
            catch (RuntimeNodeTraversalException e) {
                this.addSlowQueryStats(this.query.getSettings());
                LOG.warn(e.getMessage() + " for query " + this.query.getStatement());
                throw e;
            }
            if (!this.isParent) {
                if (this.currentRow.isVirtualRow()) {
                    return true;
                }
                if (!this.getCachedTree(this.currentRow.getPath()).exists()) continue;
            }
            if (!this.evaluateCurrentRow()) continue;
            return true;
        }
        this.cursor = null;
        this.currentRow = null;
        return false;
    }

    private void totalQueryStats(QueryEngineSettings queryEngineSettings) {
        if (this.updateTotalQueryHistogram) {
            this.updateTotalQueryHistogram = false;
            HistogramStats histogramStats = queryEngineSettings.getStatisticsProvider().getHistogram(SLOW_QUERY_PERCENTILE_METRICS_NAME, StatsOptions.METRICS_ONLY);
            histogramStats.update(0L);
        }
    }

    private void addSlowQueryStats(QueryEngineSettings queryEngineSettings) {
        HistogramStats histogramStats = queryEngineSettings.getStatisticsProvider().getHistogram(SLOW_QUERY_PERCENTILE_METRICS_NAME, StatsOptions.METRICS_ONLY);
        histogramStats.update(1L);
        CounterStats slowQueryCounter = queryEngineSettings.getStatisticsProvider().getCounterStats(SLOW_QUERY_COUNT_NAME, StatsOptions.METRICS_ONLY);
        slowQueryCounter.inc();
    }

    private boolean evaluateCurrentRow() {
        if (this.currentRow.isVirtualRow()) {
            return true;
        }
        if (!this.matchesAllTypes && !this.evaluateTypeMatch()) {
            return false;
        }
        for (ConstraintImpl constraint : this.selectorConstraints) {
            if (constraint.evaluate()) continue;
            if (constraint.evaluateStop()) {
                this.cursor = null;
            }
            return false;
        }
        return this.joinCondition == null || this.joinCondition.evaluate();
    }

    private boolean evaluateTypeMatch() {
        LazyValue readOnly;
        CachedTree ct = this.getCachedTree(this.currentRow.getPath());
        if (!ct.exists()) {
            return false;
        }
        Tree t = ct.getTree();
        String primaryTypeName = TreeUtil.getPrimaryTypeName(t, readOnly = ct.getReadOnlyTree());
        if (primaryTypeName != null && this.primaryTypes.contains(primaryTypeName)) {
            return true;
        }
        for (String mixinName : TreeUtil.getMixinTypeNames(t, readOnly)) {
            if (!this.mixinTypes.contains(mixinName)) continue;
            return true;
        }
        return false;
    }

    public String currentPath() {
        return this.cursor == null ? null : this.currentRow.getPath();
    }

    @Nullable
    public Tree currentTree() {
        String path = this.currentPath();
        if (path == null) {
            return null;
        }
        return this.getTree(path);
    }

    @Nullable
    Tree getTree(@NotNull String path) {
        return this.getCachedTree(path).getTree();
    }

    @NotNull
    private CachedTree getCachedTree(@NotNull String path) {
        if (this.cachedTree == null || !this.cachedTree.denotes(path)) {
            this.cachedTree = new CachedTree(path, this.query);
        }
        return this.cachedTree;
    }

    public PropertyValue currentProperty(String propertyName) {
        String pn = this.normalizePropertyName(propertyName);
        return this.currentOakProperty(pn);
    }

    public PropertyValue currentProperty(String propertyName, int propertyType) {
        String pn = this.normalizePropertyName(propertyName);
        return this.currentOakProperty(pn, propertyType);
    }

    public PropertyValue currentOakProperty(String oakPropertyName) {
        return this.currentOakProperty(oakPropertyName, null);
    }

    private PropertyValue currentOakProperty(String oakPropertyName, Integer propertyType) {
        boolean asterisk;
        boolean bl = asterisk = oakPropertyName.indexOf(42) >= 0;
        if (asterisk) {
            Tree t = this.currentTree();
            if (t != null) {
                LOG.trace("currentOakProperty() - '*' case. looking for '{}' in '{}'", (Object)oakPropertyName, (Object)t.getPath());
            }
            ArrayList<PropertyValue> list = new ArrayList<PropertyValue>();
            this.readOakProperties(list, t, oakPropertyName, propertyType);
            if (list.size() == 0) {
                return null;
            }
            if (list.size() == 1) {
                return list.get(0);
            }
            Type<Object> type = list.get(0).getType();
            for (int i = 1; i < list.size(); ++i) {
                Type<?> t2 = list.get(i).getType();
                if (t2 == type) continue;
                type = Type.STRING;
                break;
            }
            if (type == Type.STRING) {
                ArrayList<String> strings = new ArrayList<String>();
                for (PropertyValue p : list) {
                    Iterables.addAll(strings, p.getValue(Type.STRINGS));
                }
                return PropertyValues.newString(strings);
            }
            Type<?> baseType = type.isArray() ? type.getBaseType() : type;
            PropertyBuilder<?> builder = PropertyBuilder.array(baseType);
            builder.setName("");
            for (PropertyValue v : list) {
                if (type.isArray()) {
                    for (Object value : (Iterable)v.getValue(type)) {
                        builder.addValue(value);
                    }
                    continue;
                }
                builder.addValue(v.getValue(type));
            }
            PropertyState s = builder.getPropertyState();
            return PropertyValues.create(s);
        }
        boolean relative = !oakPropertyName.startsWith("rep:facet(") && !oakPropertyName.startsWith("rep:excerpt(") && oakPropertyName.indexOf(47) >= 0;
        Tree t = this.currentTree();
        if (relative) {
            for (String p : PathUtils.elements(PathUtils.getParentPath(oakPropertyName))) {
                if (t == null) {
                    return null;
                }
                if (p.equals("..")) {
                    t = t.isRoot() ? null : t.getParent();
                    continue;
                }
                if (p.equals(".")) continue;
                t = t.getChild(p);
            }
            oakPropertyName = PathUtils.getName(oakPropertyName);
        }
        return this.currentOakProperty(t, oakPropertyName, propertyType);
    }

    private PropertyValue currentOakProperty(Tree t, String oakPropertyName, Integer propertyType) {
        PropertyValue result;
        if (!(t != null && t.exists() || this.currentRow != null && this.currentRow.isVirtualRow())) {
            return null;
        }
        if (oakPropertyName.equals("jcr:path")) {
            String path = this.currentPath();
            String local = this.getLocalPath(path);
            if (local == null) {
                return null;
            }
            result = PropertyValues.newString(local);
        } else {
            result = oakPropertyName.equals("jcr:score") ? this.currentRow.getValue("jcr:score") : (oakPropertyName.equals("rep:excerpt") || oakPropertyName.startsWith("rep:excerpt(") ? this.currentRow.getValue(oakPropertyName) : (oakPropertyName.equals("oak:scoreExplanation") ? this.currentRow.getValue("oak:scoreExplanation") : (oakPropertyName.equals("rep:spellcheck()") ? this.currentRow.getValue("rep:spellcheck()") : (oakPropertyName.equals("rep:suggest()") ? this.currentRow.getValue("rep:suggest()") : (oakPropertyName.startsWith("rep:facet(") ? this.currentRow.getValue(oakPropertyName) : PropertyValues.create(t.getProperty(oakPropertyName)))))));
        }
        if (result == null) {
            return null;
        }
        if (propertyType != null && result.getType().tag() != propertyType.intValue()) {
            return null;
        }
        return result;
    }

    private void readOakProperties(ArrayList<PropertyValue> target, Tree t, String oakPropertyName, Integer propertyType) {
        boolean skipCurrentNode = false;
        while (!skipCurrentNode) {
            if (t == null || !t.exists()) {
                return;
            }
            LOG.trace("readOakProperties() - reading '{}' for '{}'", (Object)t.getPath(), (Object)oakPropertyName);
            int slash = oakPropertyName.indexOf(47);
            if (slash < 0) break;
            String string = oakPropertyName.substring(0, slash);
            oakPropertyName = oakPropertyName.substring(slash + 1);
            if (string.equals("..")) {
                t = t.isRoot() ? null : t.getParent();
                continue;
            }
            if (string.equals(".")) continue;
            if (string.equals("*")) {
                for (Tree child : t.getChildren()) {
                    this.readOakProperties(target, child, oakPropertyName, propertyType);
                }
                skipCurrentNode = true;
                continue;
            }
            t = t.getChild(string);
        }
        if (skipCurrentNode) {
            return;
        }
        if (!"*".equals(oakPropertyName)) {
            PropertyValue value = this.currentOakProperty(t, oakPropertyName, propertyType);
            if (value != null) {
                LOG.trace("readOakProperties() - adding: '{}' from '{}'", (Object)value, (Object)t.getPath());
                target.add(value);
            }
            return;
        }
        for (PropertyState propertyState : t.getProperties()) {
            if (propertyType != null && propertyState.getType().tag() != propertyType.intValue()) continue;
            PropertyValue v = PropertyValues.create(propertyState);
            target.add(v);
        }
    }

    public boolean isVirtualRow() {
        return this.currentRow != null && this.currentRow.isVirtualRow();
    }

    @Override
    public SelectorImpl getSelector(String selectorName) {
        if (selectorName.equals(this.selectorName)) {
            return this;
        }
        return null;
    }

    public long getScanCount() {
        return this.scanCount;
    }

    public void restrictSelector(ConstraintImpl constraint) {
        this.selectorConstraints.add(constraint);
    }

    public List<ConstraintImpl> getSelectorConstraints() {
        return this.selectorConstraints;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SelectorImpl)) {
            return false;
        }
        return this.selectorName.equals(((SelectorImpl)other).selectorName);
    }

    public int hashCode() {
        return this.selectorName.hashCode();
    }

    QueryIndex getIndex() {
        return this.plan == null ? null : this.plan.getIndex();
    }

    public ArrayList<SourceImpl> getInnerJoinSelectors() {
        ArrayList<SourceImpl> list = new ArrayList<SourceImpl>();
        list.add(this);
        return list;
    }

    @Override
    public boolean isOuterJoinRightHandSide() {
        return this.outerJoinRightHandSide;
    }

    public QueryImpl getQuery() {
        return this.query;
    }

    @Override
    public long getSize(NodeState rootState, Result.SizePrecision precision, long max) {
        if (this.cursor == null) {
            this.execute(rootState);
        }
        return this.cursor.getSize(precision, max);
    }

    @Override
    public SourceImpl copyOf() {
        return new SelectorImpl(this.nodeTypeInfo, this.selectorName);
    }

    private static final class CachedTree {
        private final String path;
        private final Tree tree;
        private final ExecutionContext ctx;
        private final LazyValue<Tree> readOnlyTree;

        private CachedTree(final @NotNull String path, @NotNull QueryImpl query) {
            this.path = path;
            this.tree = query.getTree(path);
            this.ctx = query.getExecutionContext();
            this.readOnlyTree = new LazyValue<Tree>(){

                @Override
                protected Tree createValue() {
                    return new ImmutableRoot(ctx.getBaseState()).getTree(path);
                }
            };
        }

        private boolean denotes(@NotNull String path) {
            return this.path.equals(path);
        }

        private boolean exists() {
            return this.tree != null && this.tree.exists();
        }

        @Nullable
        private Tree getTree() {
            return this.tree;
        }

        @NotNull
        private LazyValue<Tree> getReadOnlyTree() {
            return this.readOnlyTree;
        }
    }
}

