/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.state.DefaultNodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import sling-mock-oak.com.google.common.collect.Iterables;
import sling-mock-oak.com.google.common.collect.Lists;
import sling-mock-oak.com.google.common.collect.Sets;

class TypeRegistration
extends DefaultNodeStateDiff {
    private final Set<String> addedTypes = Sets.newHashSet();
    private final Set<String> changedTypes = Sets.newHashSet();
    private final Set<String> removedTypes = Sets.newHashSet();

    TypeRegistration() {
    }

    boolean isModified() {
        return !this.addedTypes.isEmpty() || !this.changedTypes.isEmpty() || !this.removedTypes.isEmpty();
    }

    Set<String> getModifiedTypes(NodeState beforeTypes) {
        HashSet<String> types = Sets.newHashSet();
        for (String name : Sets.union(this.changedTypes, this.removedTypes)) {
            types.add(name);
            NodeState type = beforeTypes.getChildNode(name);
            Iterables.addAll(types, type.getNames("rep:primarySubtypes"));
            Iterables.addAll(types, type.getNames("rep:mixinSubtypes"));
        }
        return types;
    }

    NodeState apply(NodeBuilder builder) throws CommitFailedException {
        NodeBuilder types = builder.child("jcr:system").child("jcr:nodeTypes");
        for (String name : types.getChildNodeNames()) {
            this.validateAndCompileType(types, name);
        }
        for (String name : types.getChildNodeNames()) {
            this.mergeSupertypes(types, types.child(name));
            this.ensureNtBase(types, types.child(name));
        }
        for (String name : types.getChildNodeNames()) {
            NodeBuilder type = types.child(name);
            String listName = "rep:primarySubtypes";
            if (type.getBoolean("jcr:isMixin")) {
                listName = "rep:mixinSubtypes";
            }
            for (String supername : this.getNames(type, "rep:supertypes")) {
                this.addNameToList(types.child(supername), listName, name);
            }
        }
        return types.getNodeState();
    }

    @Override
    public boolean childNodeAdded(String name, NodeState after) {
        this.addedTypes.add(name);
        return true;
    }

    @Override
    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        if (!before.equals(after)) {
            this.changedTypes.add(name);
        }
        return true;
    }

    @Override
    public boolean childNodeDeleted(String name, NodeState before) {
        this.removedTypes.add(name);
        return true;
    }

    private void mergeSupertypes(NodeBuilder types, NodeBuilder type) throws CommitFailedException {
        if (!type.hasProperty("rep:supertypes")) {
            List empty = Collections.emptyList();
            type.setProperty("rep:supertypes", empty, Type.NAMES);
            PropertyState supertypes = type.getProperty("jcr:supertypes");
            if (supertypes != null) {
                for (String supername : supertypes.getValue(Type.NAMES)) {
                    if (types.hasChildNode(supername)) {
                        NodeBuilder supertype = types.child(supername);
                        this.mergeSupertypes(types, supertype);
                        this.mergeSupertype(type, supertype.getNodeState());
                        continue;
                    }
                    throw new CommitFailedException("Constraint", 35, "Missing supertype " + supername);
                }
            }
            if (!(TypeRegistration.isMixin(type) || Iterables.contains(this.getNames(type, "rep:supertypes"), "nt:base") || "nt:base".equals(type.getProperty("jcr:nodeTypeName").getValue(Type.NAME)))) {
                if (types.hasChildNode("nt:base")) {
                    NodeBuilder supertype = types.child("nt:base");
                    this.mergeSupertypes(types, supertype);
                    this.mergeSupertype(type, supertype.getNodeState());
                } else {
                    throw new CommitFailedException("Constraint", 35, "Missing supertype nt:base");
                }
            }
        }
    }

    private void ensureNtBase(NodeBuilder types, NodeBuilder type) {
        if (TypeRegistration.isMixin(type) || "nt:base".equals(type.getName("jcr:nodeTypeName"))) {
            return;
        }
        Iterable<String> supertypes = this.getNames(type, "jcr:supertypes");
        if (Iterables.isEmpty(supertypes)) {
            this.addNameToList(type, "jcr:supertypes", "nt:base");
        } else {
            boolean addNtBase = true;
            for (String name : supertypes) {
                NodeBuilder supertype = types.getChildNode(name);
                if (TypeRegistration.isMixin(supertype)) continue;
                addNtBase = false;
                break;
            }
            if (addNtBase) {
                this.addNameToList(type, "jcr:supertypes", "nt:base");
            }
        }
    }

    private static boolean isMixin(NodeBuilder type) {
        return TypeRegistration.getBoolean(type, "jcr:isMixin");
    }

    private static boolean getBoolean(NodeBuilder builder, String name) {
        PropertyState property = builder.getProperty(name);
        return property != null && property.getValue(Type.BOOLEAN) != false;
    }

    private Iterable<String> getNames(NodeBuilder builder, String name) {
        PropertyState property = builder.getProperty(name);
        if (property != null) {
            return property.getValue(Type.NAMES);
        }
        return Collections.emptyList();
    }

    private void mergeSupertype(NodeBuilder type, NodeState supertype) {
        String supername = supertype.getProperty("jcr:nodeTypeName").getValue(Type.NAME);
        this.addNameToList(type, "rep:supertypes", supername);
        this.mergeNameList(type, supertype, "rep:supertypes");
        this.mergeNameList(type, supertype, "rep:mandatoryProperties");
        this.mergeNameList(type, supertype, "rep:mandatoryChildNodes");
        this.mergeNameList(type, supertype, "rep:protectedProperties");
        this.mergeNameList(type, supertype, "rep:protectedChildNodes");
        if (supertype.getBoolean("rep:hasProtectedResidualProperties")) {
            type.setProperty("rep:hasProtectedResidualProperties", true);
        }
        if (supertype.getBoolean("rep:hasProtectedResidualChildNodes")) {
            type.setProperty("rep:hasProtectedResidualChildNodes", true);
        }
        this.mergeNameList(type, supertype, "rep:namedSingleValuedProperties");
        this.mergeSubtree(type, supertype, "rep:namedPropertyDefinitions", 2);
        this.mergeSubtree(type, supertype, "rep:residualPropertyDefinitions", 1);
        this.mergeSubtree(type, supertype, "rep:namedChildNodeDefinitions", 2);
        this.mergeSubtree(type, supertype, "rep:residualChildNodeDefinitions", 1);
    }

    private void mergeNameList(NodeBuilder builder, NodeState state, String listName) {
        LinkedHashSet<String> nameList = Sets.newLinkedHashSet(this.getNames(builder, listName));
        Iterables.addAll(nameList, state.getProperty(listName).getValue(Type.NAMES));
        builder.setProperty(listName, nameList, Type.NAMES);
    }

    private void mergeSubtree(NodeBuilder builder, NodeState state, String name, int depth) {
        NodeState subtree = state.getChildNode(name);
        if (subtree.exists()) {
            if (!builder.hasChildNode(name)) {
                builder.setChildNode(name, subtree);
            } else if (depth > 0) {
                NodeBuilder subbuilder = builder.child(name);
                for (String subname : subtree.getChildNodeNames()) {
                    this.mergeSubtree(subbuilder, subtree, subname, depth - 1);
                }
            }
        }
    }

    private void validateAndCompileType(NodeBuilder types, String name) throws CommitFailedException {
        NodeBuilder type = types.child(name);
        PropertyState nodeTypeName = type.getProperty("jcr:nodeTypeName");
        if (nodeTypeName == null || !name.equals(nodeTypeName.getValue(Type.NAME))) {
            throw new CommitFailedException("Constraint", 34, "Unexpected jcr:nodeTypeName in type " + name);
        }
        List empty = Collections.emptyList();
        type.setProperty("jcr:primaryType", "rep:NodeType", Type.NAME);
        type.removeProperty("rep:supertypes");
        type.setProperty("rep:primarySubtypes", empty, Type.NAMES);
        type.setProperty("rep:mandatoryProperties", empty, Type.NAMES);
        type.setProperty("rep:mandatoryChildNodes", empty, Type.NAMES);
        type.setProperty("rep:protectedProperties", empty, Type.NAMES);
        type.setProperty("rep:protectedChildNodes", empty, Type.NAMES);
        type.setProperty("rep:hasProtectedResidualProperties", false, Type.BOOLEAN);
        type.setProperty("rep:hasProtectedResidualChildNodes", false, Type.BOOLEAN);
        type.setProperty("rep:namedSingleValuedProperties", empty, Type.NAMES);
        type.getChildNode("rep:namedPropertyDefinitions").remove();
        type.getChildNode("rep:residualPropertyDefinitions").remove();
        type.getChildNode("rep:namedChildNodeDefinitions").remove();
        type.getChildNode("rep:residualChildNodeDefinitions").remove();
        for (String childNodeName : type.getChildNodeNames()) {
            NodeState definition = type.child(childNodeName).getNodeState();
            if (childNodeName.startsWith("jcr:propertyDefinition")) {
                this.validateAndCompilePropertyDefinition(type, name, definition);
                continue;
            }
            if (!childNodeName.startsWith("jcr:childNodeDefinition")) continue;
            this.validateAndCompileChildNodeDefinition(types, type, name, definition);
        }
    }

    private void addNameToList(NodeBuilder type, String name, String value) {
        ArrayList<String> values = Lists.newArrayList(this.getNames(type, name));
        if (!values.contains(value)) {
            values.add(value);
        }
        type.setProperty(name, values, Type.NAMES);
    }

    private void validateAndCompilePropertyDefinition(NodeBuilder type, String typeName, NodeState definition) throws CommitFailedException {
        NodeBuilder definitions;
        PropertyState name = definition.getProperty("jcr:name");
        String propertyName = null;
        if (name != null) {
            propertyName = name.getValue(Type.NAME);
            String escapedName = propertyName;
            if ("jcr:primaryType".equals(escapedName)) {
                escapedName = "rep:primaryType";
            } else if ("jcr:mixinTypes".equals(escapedName)) {
                escapedName = "rep:mixinTypes";
            } else if ("jcr:uuid".equals(escapedName)) {
                escapedName = "rep:uuid";
            }
            definitions = type.child("rep:namedPropertyDefinitions");
            definitions.setProperty("jcr:primaryType", "rep:NamedPropertyDefinitions", Type.NAME);
            definitions = definitions.child(escapedName);
            if (definition.getBoolean("jcr:mandatory")) {
                this.addNameToList(type, "rep:mandatoryProperties", propertyName);
            }
            if (definition.getBoolean("jcr:protected")) {
                this.addNameToList(type, "rep:protectedProperties", propertyName);
            }
        } else {
            definitions = type.child("rep:residualPropertyDefinitions");
            if (definition.getBoolean("jcr:protected")) {
                type.setProperty("rep:hasProtectedResidualProperties", true);
            }
        }
        definitions.setProperty("jcr:primaryType", "rep:PropertyDefinitions", Type.NAME);
        String key = "UNDEFINED";
        PropertyState requiredType = definition.getProperty("jcr:requiredType");
        if (requiredType != null) {
            key = requiredType.getValue(Type.STRING);
        }
        if (definition.getBoolean("jcr:multiple")) {
            key = "BINARY".equals(key) ? "BINARIES" : key + "S";
        } else if (propertyName != null) {
            this.addNameToList(type, "rep:namedSingleValuedProperties", propertyName);
        }
        definitions.setChildNode(key, definition).setProperty("jcr:primaryType", "rep:PropertyDefinition", Type.NAME).setProperty("rep:declaringNodeType", typeName, Type.NAME);
    }

    private void validateAndCompileChildNodeDefinition(NodeBuilder types, NodeBuilder type, String typeName, NodeState definition) throws CommitFailedException {
        NodeBuilder definitions;
        PropertyState name = definition.getProperty("jcr:name");
        if (name != null) {
            String childNodeName = name.getValue(Type.NAME);
            definitions = type.child("rep:namedChildNodeDefinitions");
            definitions.setProperty("jcr:primaryType", "rep:NamedChildNodeDefinitions", Type.NAME);
            definitions = definitions.child(childNodeName);
            if (definition.getBoolean("jcr:mandatory")) {
                this.addNameToList(type, "rep:mandatoryChildNodes", childNodeName);
            }
            if (definition.getBoolean("jcr:protected")) {
                this.addNameToList(type, "rep:protectedChildNodes", childNodeName);
            }
        } else {
            definitions = type.child("rep:residualChildNodeDefinitions");
            if (definition.getBoolean("jcr:protected")) {
                type.setProperty("rep:hasProtectedResidualChildNodes", true);
            }
        }
        definitions.setProperty("jcr:primaryType", "rep:ChildNodeDefinitions", Type.NAME);
        PropertyState requiredTypes = definition.getProperty("jcr:requiredPrimaryTypes");
        if (requiredTypes != null) {
            for (String key : requiredTypes.getValue(Type.NAMES)) {
                if (!types.hasChildNode(key)) {
                    throw new CommitFailedException("Constraint", 33, "Unknown required primary type " + key);
                }
                if (definitions.hasChildNode(key)) continue;
                definitions.setChildNode(key, definition).setProperty("jcr:primaryType", "rep:ChildNodeDefinition", Type.NAME).setProperty("rep:declaringNodeType", typeName, Type.NAME);
            }
        }
    }
}

