/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.jcr.Value;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.UUIDUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.nodetype.EffectiveType;
import org.apache.jackrabbit.oak.plugins.nodetype.constraint.Constraints;
import org.apache.jackrabbit.oak.plugins.value.jcr.PartialValueFactory;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ConsumerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sling-mock-oak.com.google.common.base.Objects;
import sling-mock-oak.com.google.common.base.Preconditions;
import sling-mock-oak.com.google.common.base.Predicates;
import sling-mock-oak.com.google.common.collect.Iterables;
import sling-mock-oak.com.google.common.collect.Lists;

public class TypeEditor
extends DefaultEditor {
    public static final ConstraintViolationCallback THROW_ON_CONSTRAINT_VIOLATION = new ConstraintViolationCallback(){

        @Override
        public void onConstraintViolation(String path, List<String> nodeTypeNames, int code, String message) throws CommitFailedException {
            String fullPath = path + '[' + nodeTypeNames.toString() + ']';
            throw new CommitFailedException("Constraint", code, fullPath + ": " + message);
        }
    };
    public static final ConstraintViolationCallback WARN_ON_CONSTRAINT_VIOLATION = new ConstraintViolationCallback(){

        @Override
        public void onConstraintViolation(String path, List<String> nodeTypeNames, int code, String message) {
            String fullPath = path + '[' + nodeTypeNames.toString() + ']';
            log.warn(new CommitFailedException("Constraint", code, fullPath + ": " + message).getMessage());
        }
    };
    private static final Logger log = LoggerFactory.getLogger(TypeEditor.class);
    private final PartialValueFactory valueFactory;
    private final Set<String> typesToCheck;
    private boolean checkThisNode;
    private final ConstraintViolationCallback callback;
    private final TypeEditor parent;
    private final String nodeName;
    private final NodeState types;
    private final EffectiveType effective;
    private final NodeBuilder builder;
    private final boolean validate;

    public static TypeEditor create(@NotNull ConstraintViolationCallback callback, Set<String> typesToCheck, @NotNull NodeState types, String primary, Iterable<String> mixins, @NotNull NodeBuilder builder) throws CommitFailedException {
        return new TypeEditor(callback, typesToCheck, types, primary, mixins, builder);
    }

    TypeEditor(ConstraintViolationCallback callback, Set<String> typesToCheck, NodeState types, String primary, Iterable<String> mixins, NodeBuilder builder) throws CommitFailedException {
        this.valueFactory = new PartialValueFactory(NamePathMapper.DEFAULT);
        this.callback = Preconditions.checkNotNull(callback);
        this.typesToCheck = typesToCheck;
        this.checkThisNode = typesToCheck == null || typesToCheck.contains(primary) || Iterables.any(mixins, Predicates.in(typesToCheck));
        this.parent = null;
        this.nodeName = null;
        this.types = Preconditions.checkNotNull(types);
        this.effective = this.createEffectiveType(null, null, primary, mixins);
        this.builder = Preconditions.checkNotNull(builder);
        this.validate = false;
    }

    private TypeEditor(@NotNull TypeEditor parent, @NotNull String name, @Nullable String primary, @NotNull Iterable<String> mixins, @NotNull NodeBuilder builder, boolean validate) throws CommitFailedException {
        this.valueFactory = parent.valueFactory;
        this.callback = parent.callback;
        this.typesToCheck = parent.typesToCheck;
        this.checkThisNode = this.typesToCheck == null || this.typesToCheck.contains(primary) || Iterables.any(mixins, Predicates.in(this.typesToCheck));
        this.parent = Preconditions.checkNotNull(parent);
        this.nodeName = Preconditions.checkNotNull(name);
        this.types = parent.types;
        this.effective = this.createEffectiveType(parent.effective, name, primary, mixins);
        this.builder = Preconditions.checkNotNull(builder);
        this.validate = validate;
    }

    TypeEditor(EffectiveType effective) {
        this.valueFactory = new PartialValueFactory(NamePathMapper.DEFAULT);
        this.callback = THROW_ON_CONSTRAINT_VIOLATION;
        this.typesToCheck = null;
        this.checkThisNode = true;
        this.parent = null;
        this.nodeName = null;
        this.types = EmptyNodeState.EMPTY_NODE;
        this.effective = Preconditions.checkNotNull(effective);
        this.builder = EmptyNodeState.EMPTY_NODE.builder();
        this.validate = false;
    }

    private void constraintViolation(int code, String message) throws CommitFailedException {
        List<String> nodeTypeNames = this.effective != null ? this.effective.getDirectTypeNames() : Collections.emptyList();
        this.callback.onConstraintViolation(this.getPath(), nodeTypeNames, code, message);
    }

    private String getPath() {
        if (this.parent == null) {
            return "/";
        }
        if (this.parent.parent == null) {
            return '/' + this.nodeName;
        }
        return this.parent.getPath() + '/' + this.nodeName;
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        this.propertyChanged(null, after);
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        if (this.checkThisNode) {
            this.checkPropertyTypeConstraints(after);
        }
    }

    @Override
    public void propertyDeleted(PropertyState before) throws CommitFailedException {
        String name = before.getName();
        if (this.checkThisNode && this.effective.isMandatoryProperty(name)) {
            this.constraintViolation(22, "Mandatory property " + name + " can not be removed");
        }
    }

    @Override
    public void enter(NodeState before, NodeState after) throws CommitFailedException {
        if (this.checkThisNode && this.validate) {
            this.checkNodeTypeConstraints(after);
            this.checkThisNode = false;
        }
    }

    @Override
    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        return this.childNodeChanged(name, EmptyNodeState.MISSING_NODE, after);
    }

    @Override
    public TypeEditor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        String primary = after.getName("jcr:primaryType");
        Iterable<String> mixins = after.getNames("jcr:mixinTypes");
        if (primary == null && this.effective != null) {
            primary = this.effective.getDefaultType(name);
            if (primary != null) {
                this.builder.setProperty("jcr:primaryType", primary, Type.NAME);
            } else {
                this.constraintViolation(4, "No default primary type available  for child node " + name);
            }
        }
        boolean validate = TypeEditor.primaryChanged(before, primary) || TypeEditor.mixinsChanged(before, mixins);
        NodeBuilder childBuilder = this.builder.getChildNode(name);
        TypeEditor editor = new TypeEditor(this, name, primary, mixins, childBuilder, validate);
        if (this.checkThisNode && validate && !this.effective.isValidChildNode(name, editor.getEffective())) {
            this.constraintViolation(1, "No matching definition found for child node " + name + " with effective type " + editor.getEffective());
        }
        return editor;
    }

    @Override
    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        if (this.checkThisNode && this.effective.isMandatoryChildNode(name)) {
            this.constraintViolation(26, "Mandatory child node " + name + " can not be removed");
        }
        return null;
    }

    @NotNull
    private EffectiveType createEffectiveType(@Nullable EffectiveType parent, @Nullable String name, @Nullable String primary, @NotNull Iterable<String> mixins) throws CommitFailedException {
        NodeState type;
        ArrayList<NodeState> list = Lists.newArrayList();
        NodeState nodeState = type = primary == null ? null : this.types.getChildNode(primary);
        if (type == null || !type.exists()) {
            this.constraintViolation(1, "The primary type " + primary + " does not exist");
        } else if (type.getBoolean("jcr:isMixin")) {
            this.constraintViolation(2, "Mixin type " + primary + " used as the primary type");
        } else {
            if (type.getBoolean("jcr:isAbstract")) {
                if (parent != null && name != null && primary.equals(parent.getDefaultType(name))) {
                    log.warn("Abstract type " + primary + " used as the default primary type of node " + this.getPath());
                } else {
                    this.constraintViolation(2, "Abstract type " + primary + " used as the primary type");
                }
            }
            list.add(type);
        }
        for (String mixin : mixins) {
            type = this.types.getChildNode(mixin);
            if (!type.exists()) {
                this.constraintViolation(5, "The mixin type " + mixin + " does not exist");
                continue;
            }
            if (!type.getBoolean("jcr:isMixin")) {
                this.constraintViolation(6, "Primary type " + mixin + " used as a mixin type");
                continue;
            }
            if (type.getBoolean("jcr:isAbstract")) {
                this.constraintViolation(7, "Abstract type " + mixin + " used as a mixin type");
                continue;
            }
            list.add(type);
        }
        return new EffectiveType(list);
    }

    @NotNull
    private EffectiveType getEffective() {
        return this.effective;
    }

    private static int getRequiredType(NodeState definition) {
        int type = 0;
        PropertyState required = definition.getProperty("jcr:requiredType");
        if (required != null) {
            String value = required.getValue(Type.STRING);
            if ("BINARY".equals(value)) {
                type = 2;
            } else if ("BOOLEAN".equals(value)) {
                type = 6;
            } else if ("DATE".equals(value)) {
                type = 5;
            } else if ("DECIMAL".equals(value)) {
                type = 12;
            } else if ("DOUBLE".equals(value)) {
                type = 4;
            } else if ("LONG".equals(value)) {
                type = 3;
            } else if ("NAME".equals(value)) {
                type = 7;
            } else if ("PATH".equals(value)) {
                type = 8;
            } else if ("REFERENCE".equals(value)) {
                type = 9;
            } else if ("STRING".equals(value)) {
                type = 1;
            } else if ("URI".equals(value)) {
                type = 11;
            } else if ("WEAKREFERENCE".equals(value)) {
                type = 10;
            }
        }
        return type;
    }

    private void checkRequiredType(PropertyState property, int requiredType) throws CommitFailedException {
        if (requiredType != property.getType().tag()) {
            this.constraintViolation(55, "Required property type violation in " + property);
        }
    }

    private void checkValueConstraints(NodeState definition, PropertyState property, int requiredType) throws CommitFailedException {
        if (property.count() == 0) {
            return;
        }
        PropertyState constraints = definition.getProperty("jcr:valueConstraints");
        if (constraints == null || constraints.count() == 0) {
            return;
        }
        for (String constraint : constraints.getValue(Type.STRINGS)) {
            Predicate<Value> predicate = Constraints.asPredicate(requiredType, constraint);
            for (Value v : this.valueFactory.createValues(property)) {
                if (!predicate.test(v)) continue;
                return;
            }
        }
        this.constraintViolation(5, "Value constraint violation in " + property);
    }

    private static boolean primaryChanged(NodeState before, String after) {
        String pre = before.getName("jcr:primaryType");
        return !Objects.equal(pre, after);
    }

    private static boolean mixinsChanged(NodeState before, Iterable<String> after) {
        ArrayList<String> pre = Lists.newArrayList(before.getNames("jcr:mixinTypes"));
        Collections.sort(pre);
        ArrayList<String> post = Lists.newArrayList(after);
        Collections.sort(post);
        if (pre.isEmpty() && post.isEmpty()) {
            return false;
        }
        if (pre.isEmpty() || post.isEmpty()) {
            return true;
        }
        return !Iterables.elementsEqual(pre, post);
    }

    private void checkNodeTypeConstraints(NodeState after) throws CommitFailedException {
        EffectiveType effective = this.getEffective();
        Set<String> properties = effective.getMandatoryProperties();
        for (PropertyState propertyState : after.getProperties()) {
            properties.remove(propertyState.getName());
            this.checkPropertyTypeConstraints(propertyState);
        }
        if (!properties.isEmpty()) {
            this.constraintViolation(21, "Mandatory property '" + properties.iterator().next() + "' not found in a new node");
        }
        ArrayList<String> names = Lists.newArrayList(after.getChildNodeNames());
        for (String child : effective.getMandatoryChildNodes()) {
            if (names.remove(child)) continue;
            this.constraintViolation(25, "Mandatory child node '" + child + "' not found in a new node");
        }
        for (String name : names) {
            NodeBuilder childBuilder;
            Iterable<String> mixins;
            NodeState child;
            String primary;
            TypeEditor editor;
            if (NodeStateUtils.isHidden(name) || effective.isValidChildNode(name, (editor = new TypeEditor(this, name, primary = (child = after.getChildNode(name)).getName("jcr:primaryType"), mixins = child.getNames("jcr:mixinTypes"), childBuilder = this.builder.getChildNode(name), false)).getEffective())) continue;
            this.constraintViolation(25, "Unexpected child node '" + name + "' of effective type '" + editor.getEffective() + "' found in a new node");
        }
    }

    private void checkPropertyTypeConstraints(PropertyState after) throws CommitFailedException {
        if (NodeStateUtils.isHidden(after.getName())) {
            return;
        }
        NodeState definition = this.effective.getDefinition(after);
        if (definition == null) {
            this.constraintViolation(4, "No matching property definition found for " + after);
        } else if ("jcr:uuid".equals(after.getName()) && this.effective.isNodeType("mix:referenceable")) {
            if (!UUIDUtils.isValidUUID(after.getValue(Type.STRING))) {
                this.constraintViolation(12, "Invalid UUID value in the jcr:uuid property");
            }
        } else {
            int requiredType = TypeEditor.getRequiredType(definition);
            if (requiredType != 0) {
                this.checkRequiredType(after, requiredType);
                this.checkValueConstraints(definition, after, requiredType);
            }
        }
    }

    @ConsumerType
    public static interface ConstraintViolationCallback {
        public void onConstraintViolation(String var1, List<String> var2, int var3, String var4) throws CommitFailedException;
    }
}

