/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.commit;

import java.util.ArrayList;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.state.ConflictType;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import sling-mock-oak.com.google.common.collect.Lists;

public class AnnotatingConflictHandler
implements ThreeWayConflictHandler {
    @Override
    public ThreeWayConflictHandler.Resolution addExistingProperty(NodeBuilder parent, PropertyState ours, PropertyState theirs) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.createChild(marker, ConflictType.ADD_EXISTING_PROPERTY).setProperty(ours);
        return ThreeWayConflictHandler.Resolution.THEIRS;
    }

    @Override
    public ThreeWayConflictHandler.Resolution changeDeletedProperty(NodeBuilder parent, PropertyState ours, PropertyState base) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.createChild(marker, ConflictType.CHANGE_DELETED_PROPERTY).setProperty(ours);
        return ThreeWayConflictHandler.Resolution.THEIRS;
    }

    @Override
    public ThreeWayConflictHandler.Resolution changeChangedProperty(NodeBuilder parent, PropertyState ours, PropertyState theirs, PropertyState base) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.createChild(marker, ConflictType.CHANGE_CHANGED_PROPERTY).setProperty(ours);
        return ThreeWayConflictHandler.Resolution.THEIRS;
    }

    @Override
    public ThreeWayConflictHandler.Resolution deleteChangedProperty(NodeBuilder parent, PropertyState theirs, PropertyState base) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.createChild(marker, ConflictType.DELETE_CHANGED_PROPERTY).setProperty(theirs);
        return ThreeWayConflictHandler.Resolution.THEIRS;
    }

    @Override
    public ThreeWayConflictHandler.Resolution deleteDeletedProperty(NodeBuilder parent, PropertyState base) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.createChild(marker, ConflictType.DELETE_DELETED_PROPERTY).setProperty(base);
        return ThreeWayConflictHandler.Resolution.THEIRS;
    }

    @Override
    public ThreeWayConflictHandler.Resolution addExistingNode(NodeBuilder parent, String name, NodeState ours, NodeState theirs) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.createChild(marker, ConflictType.ADD_EXISTING_NODE).setChildNode(name, ours);
        return ThreeWayConflictHandler.Resolution.THEIRS;
    }

    @Override
    public ThreeWayConflictHandler.Resolution changeDeletedNode(NodeBuilder parent, String name, NodeState ours, NodeState base) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.createChild(marker, ConflictType.CHANGE_DELETED_NODE).setChildNode(name, ours);
        return ThreeWayConflictHandler.Resolution.THEIRS;
    }

    @Override
    public ThreeWayConflictHandler.Resolution deleteChangedNode(NodeBuilder parent, String name, NodeState theirs, NodeState base) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.markChild(AnnotatingConflictHandler.createChild(marker, ConflictType.DELETE_CHANGED_NODE), name);
        return ThreeWayConflictHandler.Resolution.THEIRS;
    }

    @Override
    public ThreeWayConflictHandler.Resolution deleteDeletedNode(NodeBuilder parent, String name, NodeState base) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.markChild(AnnotatingConflictHandler.createChild(marker, ConflictType.DELETE_DELETED_NODE), name);
        return ThreeWayConflictHandler.Resolution.THEIRS;
    }

    private static NodeBuilder addConflictMarker(NodeBuilder parent) {
        ArrayList<String> mixins = Lists.newArrayList(parent.getNames("jcr:mixinTypes"));
        if (mixins.add("rep:MergeConflict")) {
            parent.setProperty("jcr:mixinTypes", mixins, Type.NAMES);
        }
        NodeBuilder repOurs = parent.child("rep:ours");
        repOurs.setProperty("jcr:primaryType", "rep:Unstructured", Type.NAME);
        return repOurs;
    }

    private static NodeBuilder createChild(NodeBuilder parent, ConflictType ct) {
        return parent.child(ct.getName());
    }

    private static void markChild(NodeBuilder parent, String name) {
        parent.child(name);
    }
}

