/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.NameQuery;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.TermFactory;
import org.apache.jackrabbit.spi.Name;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public class PredicateDerefQuery
extends Query {
    private final Query subQuery;
    private final String refProperty;
    private final Name nameTest;
    private final IndexFormatVersion version;
    private final NamespaceMappings nsMappings;
    private Scorer subQueryScorer;
    private Scorer nameTestScorer;

    PredicateDerefQuery(Query subQuery, String refProperty, Name nameTest, IndexFormatVersion version, NamespaceMappings nsMappings) {
        this.subQuery = subQuery;
        this.refProperty = refProperty;
        this.nameTest = nameTest;
        this.version = version;
        this.nsMappings = nsMappings;
    }

    protected Weight createWeight(Searcher searcher) {
        return new DerefWeight(searcher);
    }

    public String toString(String field) {
        StringBuffer sb = new StringBuffer();
        sb.append("PredicateDerefQuery(");
        sb.append(this.subQuery);
        sb.append(", ");
        sb.append(this.nameTest);
        sb.append(", ");
        sb.append(this.refProperty);
        sb.append(")");
        return sb.toString();
    }

    public void extractTerms(Set terms) {
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query cQuery = this.subQuery.rewrite(reader);
        if (cQuery == this.subQuery) {
            return this;
        }
        return new PredicateDerefQuery(cQuery, this.refProperty, this.nameTest, this.version, this.nsMappings);
    }

    private class DerefScorer
    extends Scorer {
        private final IndexReader reader;
        private final BitSet subQueryHits;
        private final BitSet hits;
        private List uuids;
        private int nextDoc;

        protected DerefScorer(Similarity similarity, IndexReader reader) {
            super(similarity);
            this.uuids = null;
            this.nextDoc = -1;
            this.reader = reader;
            this.hits = new BitSet(reader.maxDoc());
            this.subQueryHits = new BitSet(reader.maxDoc());
        }

        public boolean next() throws IOException {
            this.calculateChildren();
            this.nextDoc = this.hits.nextSetBit(this.nextDoc + 1);
            return this.nextDoc > -1;
        }

        public int doc() {
            return this.nextDoc;
        }

        public float score() throws IOException {
            return 1.0f;
        }

        public boolean skipTo(int target) throws IOException {
            this.calculateChildren();
            this.nextDoc = this.hits.nextSetBit(target);
            return this.nextDoc > -1;
        }

        public Explanation explain(int doc) throws IOException {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void calculateChildren() throws IOException {
            if (this.uuids == null) {
                this.uuids = new ArrayList();
                PredicateDerefQuery.this.subQueryScorer.score(new HitCollector(){

                    public void collect(int doc, float score) {
                        DerefScorer.this.subQueryHits.set(doc);
                    }
                });
                TermDocs termDocs = this.reader.termDocs(new Term(FieldNames.PROPERTIES_SET, PredicateDerefQuery.this.refProperty));
                String prefix = FieldNames.createNamedValue(PredicateDerefQuery.this.refProperty, "");
                while (termDocs.next()) {
                    int doc = termDocs.doc();
                    String[] values = this.reader.document(doc).getValues(FieldNames.PROPERTIES);
                    if (values == null) continue;
                    for (int v = 0; v < values.length; ++v) {
                        if (!values[v].startsWith(prefix)) continue;
                        String uuid = values[v].substring(prefix.length());
                        TermDocs node = this.reader.termDocs(TermFactory.createUUIDTerm(uuid));
                        try {
                            while (node.next()) {
                                if (!this.subQueryHits.get(node.doc())) continue;
                                this.hits.set(doc);
                            }
                            continue;
                        }
                        finally {
                            node.close();
                        }
                    }
                }
                final BitSet nameTestHits = new BitSet();
                if (PredicateDerefQuery.this.nameTestScorer != null) {
                    PredicateDerefQuery.this.nameTestScorer.score(new HitCollector(){

                        public void collect(int doc, float score) {
                            nameTestHits.set(doc);
                        }
                    });
                }
                if (PredicateDerefQuery.this.nameTestScorer != null) {
                    this.hits.and(nameTestHits);
                }
            }
        }
    }

    private class DerefWeight
    implements Weight {
        private final Searcher searcher;

        private DerefWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return PredicateDerefQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            PredicateDerefQuery.this.subQueryScorer = PredicateDerefQuery.this.subQuery.weight(this.searcher).scorer(reader);
            if (PredicateDerefQuery.this.nameTest != null) {
                PredicateDerefQuery.this.nameTestScorer = new NameQuery(PredicateDerefQuery.this.nameTest, PredicateDerefQuery.this.version, PredicateDerefQuery.this.nsMappings).weight(this.searcher).scorer(reader);
            }
            return new DerefScorer(this.searcher.getSimilarity(), reader);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

