/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp.taglib;

import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;

public class DefineObjectsTag
extends TagSupport {
    private static final long serialVersionUID = -1858674361149195892L;
    public static final String DEFAULT_REQUEST_NAME = "slingRequest";
    public static final String DEFAULT_RESPONSE_NAME = "slingResponse";
    public static final String DEFAULT_RESOURCE_NAME = "resource";
    public static final String DEFAULT_NODE_NAME = "currentNode";
    public static final String DEFAULT_BINDINGS_NAME = "bindings";
    public static final String DEFAULT_LOG_NAME = "log";
    public static final String DEFAULT_SLING_NAME = "sling";
    public static final String DEFAULT_RESOURCE_RESOLVER_NAME = "resourceResolver";
    private String requestName = "slingRequest";
    private String responseName = "slingResponse";
    private String resourceName = "resource";
    private String nodeName = "currentNode";
    private String slingName = "sling";
    private String logName = "log";
    private String bindingsName = "bindings";
    private String resourceResolverName = "resourceResolver";
    static Class<?> JCR_NODE_CLASS;

    public int doEndTag() {
        Object node;
        SlingBindings bindings = (SlingBindings)this.pageContext.getRequest().getAttribute(SlingBindings.class.getName());
        SlingScriptHelper scriptHelper = bindings.getSling();
        this.pageContext.setAttribute(this.requestName, (Object)scriptHelper.getRequest());
        this.pageContext.setAttribute(this.responseName, (Object)scriptHelper.getResponse());
        Resource resource = scriptHelper.getRequest().getResource();
        this.pageContext.setAttribute(this.resourceName, (Object)resource);
        this.pageContext.setAttribute(this.resourceResolverName, (Object)scriptHelper.getRequest().getResourceResolver());
        this.pageContext.setAttribute(this.slingName, (Object)scriptHelper);
        this.pageContext.setAttribute(this.logName, (Object)bindings.getLog());
        this.pageContext.setAttribute(this.bindingsName, (Object)bindings);
        if (JCR_NODE_CLASS != null && (node = resource.adaptTo(JCR_NODE_CLASS)) != null) {
            this.pageContext.setAttribute(this.nodeName, node);
        }
        return 6;
    }

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.clear();
    }

    public void setRequestName(String requestName) {
        this.requestName = requestName;
    }

    public void setResponseName(String responseName) {
        this.responseName = responseName;
    }

    public void setResourceName(String name) {
        this.resourceName = name;
    }

    public void setNodeName(String name) {
        this.nodeName = name;
    }

    public void setLogName(String name) {
        this.logName = name;
    }

    public void setSlingName(String name) {
        this.slingName = name;
    }

    public void setResourceResolverName(String name) {
        this.resourceResolverName = name;
    }

    public void setBindingsName(String name) {
        this.bindingsName = name;
    }

    public void release() {
        this.clear();
        super.release();
    }

    private void clear() {
        this.requestName = DEFAULT_REQUEST_NAME;
        this.responseName = DEFAULT_RESPONSE_NAME;
        this.resourceName = DEFAULT_RESOURCE_NAME;
        this.nodeName = DEFAULT_NODE_NAME;
        this.slingName = DEFAULT_SLING_NAME;
        this.logName = DEFAULT_LOG_NAME;
        this.bindingsName = DEFAULT_BINDINGS_NAME;
        this.resourceResolverName = DEFAULT_RESOURCE_RESOLVER_NAME;
    }

    static {
        try {
            JCR_NODE_CLASS = DefineObjectsTag.class.getClassLoader().loadClass("javax.jcr.Node");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

