/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.javascript.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.scripting.api.AbstractScriptEngineFactory;
import org.apache.sling.scripting.api.ScriptCache;
import org.apache.sling.scripting.javascript.RhinoHostObjectProvider;
import org.apache.sling.scripting.javascript.SlingWrapper;
import org.apache.sling.scripting.javascript.helper.SlingContextFactory;
import org.apache.sling.scripting.javascript.helper.SlingWrapFactory;
import org.apache.sling.scripting.javascript.internal.RhinoJavaScriptEngine;
import org.apache.sling.scripting.javascript.internal.RhinoJavaScriptEngineFactoryConfiguration;
import org.apache.sling.scripting.javascript.wrapper.ScriptableCalendar;
import org.apache.sling.scripting.javascript.wrapper.ScriptableItemMap;
import org.apache.sling.scripting.javascript.wrapper.ScriptableMap;
import org.apache.sling.scripting.javascript.wrapper.ScriptableNode;
import org.apache.sling.scripting.javascript.wrapper.ScriptablePrintWriter;
import org.apache.sling.scripting.javascript.wrapper.ScriptableProperty;
import org.apache.sling.scripting.javascript.wrapper.ScriptableResource;
import org.apache.sling.scripting.javascript.wrapper.ScriptableVersion;
import org.apache.sling.scripting.javascript.wrapper.ScriptableVersionHistory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.debugger.ScopeProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ScriptEngineFactory.class}, property={"service.description=Apache Sling Rhino Javascript Engine Factory", "service.vendor=The Apache Software Foundation", "extensions=ecma", "extensions=esp", "mimeTypes=text/ecmascript", "mimeTypes=text/javascript", "mimeTypes=application/ecmascript", "mimeTypes=application/javascript", "names=rhino", "names=Rhino", "names=javascript", "names=JavaScript", "names=ecmascript", "names=ECMAScript"}, reference={@Reference(name="HostObjectProvider", service=RhinoHostObjectProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="addHostObjectProvider", unbind="removeHostObjectProvider")})
@Designate(ocd=RhinoJavaScriptEngineFactoryConfiguration.class)
public class RhinoJavaScriptEngineFactory
extends AbstractScriptEngineFactory
implements ScopeProvider {
    public static final int DEFAULT_OPTIMIZATION_LEVEL = 9;
    public static final String ECMA_SCRIPT_EXTENSION = "ecma";
    public static final String ESP_SCRIPT_EXTENSION = "esp";
    private static final Class<?>[] HOSTOBJECT_CLASSES = new Class[]{ScriptableResource.class, ScriptableNode.class, ScriptableProperty.class, ScriptableItemMap.class, ScriptablePrintWriter.class, ScriptableVersionHistory.class, ScriptableVersion.class, ScriptableCalendar.class, ScriptableMap.class};
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private int optimizationLevel;
    private static final int RHINO_LANGUAGE_VERSION = 200;
    private static final String LANGUAGE_VERSION = "partial ECMAScript 2015 support";
    private static final String LANGUAGE_NAME = "ECMAScript";
    private SlingWrapFactory wrapFactory;
    private Scriptable rootScope;
    private final Set<RhinoHostObjectProvider> hostObjectProvider = new HashSet<RhinoHostObjectProvider>();
    @Reference
    private DynamicClassLoaderManager dynamicClassLoaderManager = null;
    @Reference
    private ScriptCache scriptCache = null;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwl.readLock();
    private final Lock writeLock = this.rwl.writeLock();
    private volatile boolean active = false;

    public ScriptEngine getScriptEngine() {
        RhinoJavaScriptEngine se = null;
        this.readLock.lock();
        try {
            if (this.active) {
                se = new RhinoJavaScriptEngine((ScriptEngineFactory)((Object)this), this.getRootScope(), this.scriptCache);
            } else {
                this.log.warn("getScriptEngine() called, but this component is not active.");
            }
        }
        finally {
            this.readLock.unlock();
        }
        return se;
    }

    public String getLanguageName() {
        return LANGUAGE_NAME;
    }

    public String getLanguageVersion() {
        return LANGUAGE_VERSION;
    }

    int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    int rhinoLanguageVersion() {
        return 200;
    }

    public Object getParameter(String name) {
        if ("THREADING".equals(name)) {
            return "MULTITHREADED";
        }
        return super.getParameter(name);
    }

    public Scriptable getScope() {
        Scriptable scope = null;
        this.readLock.lock();
        try {
            if (this.active) {
                scope = this.getRootScope();
            } else {
                this.log.warn("getScope() called, but this component is not active.");
            }
        }
        finally {
            this.readLock.unlock();
        }
        return scope;
    }

    SlingWrapFactory getWrapFactory() {
        return this.wrapFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Scriptable getRootScope() {
        if (this.rootScope == null) {
            Context rhinoContext = Context.enter();
            try {
                rhinoContext.setOptimizationLevel(this.optimizationLevel);
                rhinoContext.setLanguageVersion(200);
                ScriptableObject tmpScope = rhinoContext.initStandardObjects((ScriptableObject)new ImporterTopLevel(rhinoContext), false);
                this.addHostObjects((Scriptable)tmpScope, HOSTOBJECT_CLASSES);
                for (RhinoHostObjectProvider provider : this.hostObjectProvider) {
                    this.addHostObjects((Scriptable)tmpScope, provider.getHostObjectClasses());
                    this.addImportedClasses(rhinoContext, (Scriptable)tmpScope, provider.getImportedClasses());
                    this.addImportedPackages(rhinoContext, (Scriptable)tmpScope, provider.getImportedPackages());
                }
                this.rootScope = tmpScope;
            }
            finally {
                Context.exit();
            }
        }
        return this.rootScope;
    }

    private void dropRootScope() {
        ContextFactory contextFactory = ContextFactory.getGlobal();
        if (contextFactory instanceof SlingContextFactory) {
            ((SlingContextFactory)contextFactory).exitDebugger();
        }
        this.rootScope = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(ComponentContext context, RhinoJavaScriptEngineFactoryConfiguration configuration) {
        Dictionary props = context.getProperties();
        boolean debugging = this.getProperty("org.apache.sling.scripting.javascript.debug", props, context.getBundleContext(), false);
        String rhinoVersion = null;
        InputStream ins = null;
        try {
            Enumeration<URL> resources = RhinoJavaScriptEngineFactory.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                try {
                    Manifest manifest;
                    Attributes attrs;
                    URL url = resources.nextElement();
                    ins = url.openStream();
                    if (ins == null || (rhinoVersion = (attrs = (manifest = new Manifest(ins)).getMainAttributes()).getValue("Rhino-Version")) == null) continue;
                    break;
                }
                finally {
                    if (ins == null) continue;
                    try {
                        ins.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException ioe) {
            this.log.warn("Unable to read Rhino version.", (Throwable)ioe);
        }
        this.optimizationLevel = this.readOptimizationLevel(configuration);
        this.writeLock.lock();
        try {
            DynamicClassLoaderManager dclm;
            this.wrapFactory = new SlingWrapFactory();
            SlingContextFactory.setup(this, 200);
            this.setEngineName(this.getEngineName() + " (Rhino " + (rhinoVersion != null ? rhinoVersion : "unknown") + ")");
            this.setExtensions(PropertiesUtil.toStringArray(props.get("extensions")));
            this.setMimeTypes(PropertiesUtil.toStringArray(props.get("mimeTypes")));
            this.setNames(PropertiesUtil.toStringArray(props.get("names")));
            ContextFactory contextFactory = ContextFactory.getGlobal();
            if (contextFactory instanceof SlingContextFactory) {
                ((SlingContextFactory)contextFactory).setDebugging(debugging);
            }
            if ((dclm = this.dynamicClassLoaderManager) != null) {
                contextFactory.initApplicationClassLoader(this.dynamicClassLoaderManager.getDynamicClassLoader());
            }
            this.log.info("Activated with optimization level {}", (Object)this.optimizationLevel);
            this.active = true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.writeLock.lock();
        try {
            this.dropRootScope();
            SlingContextFactory.teardown();
            this.wrapFactory = null;
            this.hostObjectProvider.clear();
            this.active = false;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void addHostObjectProvider(RhinoHostObjectProvider provider) {
        this.hostObjectProvider.add(provider);
        if (this.rootScope != null) {
            this.addHostObjects(this.rootScope, provider.getHostObjectClasses());
        }
    }

    protected void removeHostObjectProvider(RhinoHostObjectProvider provider) {
        if (this.hostObjectProvider.remove(provider)) {
            this.dropRootScope();
        }
    }

    private void addHostObjects(Scriptable scope, Class<? extends Scriptable>[] classes) {
        if (classes != null) {
            for (Class<? extends Scriptable> clazz : classes) {
                try {
                    ScriptableObject.defineClass((Scriptable)scope, clazz);
                    if (SlingWrapper.class.isAssignableFrom(clazz)) {
                        SlingWrapper hostWrapper = (SlingWrapper)clazz.newInstance();
                        for (Class<?> c : hostWrapper.getWrappedClasses()) {
                            this.getWrapFactory().registerWrapper(c, hostWrapper.getClassName());
                        }
                        continue;
                    }
                    Scriptable host = clazz.newInstance();
                    this.getWrapFactory().registerWrapper(host.getClass(), host.getClassName());
                }
                catch (Throwable t) {
                    this.log.warn("addHostObjects: Cannot prepare host object " + clazz, t);
                }
            }
        }
    }

    private void addImportedClasses(Context cx, Scriptable scope, Class<?>[] classes) {
        if (classes != null && classes.length > 0) {
            Object[] np = new NativeJavaClass[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                np[i] = new NativeJavaClass(scope, classes[i]);
            }
            ScriptableObject.callMethod((Context)cx, (Scriptable)scope, (String)"importClass", (Object[])np);
        }
    }

    private void addImportedPackages(Context cx, Scriptable scope, String[] packages) {
        if (packages != null && packages.length > 0) {
            Object[] np = new NativeJavaPackage[packages.length];
            for (int i = 0; i < packages.length; ++i) {
                np[i] = new NativeJavaPackage(packages[i]);
            }
            ScriptableObject.callMethod((Context)cx, (Scriptable)scope, (String)"importPackage", (Object[])np);
        }
    }

    private boolean getProperty(String name, Dictionary<?, ?> props, BundleContext bundleContext, boolean defaultValue) {
        Object value = props.get(name);
        if (value == null) {
            value = bundleContext.getProperty(name);
        }
        return value != null ? Boolean.parseBoolean(String.valueOf(value)) : defaultValue;
    }

    private int readOptimizationLevel(RhinoJavaScriptEngineFactoryConfiguration configuration) {
        int optLevel = configuration.org_apache_sling_scripting_javascript_rhino_optLevel();
        if (!Context.isValidOptimizationLevel((int)optLevel)) {
            this.log.warn("Invalid optimization level {}, using default value", (Object)optLevel);
            optLevel = 9;
        }
        return optLevel;
    }
}

