/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.server.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.management.DynamicMBean;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.api.management.RepositoryManager;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jcr.api.NamespaceMapper;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.AbstractSlingRepository2;
import org.apache.sling.jcr.base.AbstractSlingRepositoryManager;
import org.apache.sling.jcr.jackrabbit.server.impl.SlingServerRepository;
import org.apache.sling.jcr.jackrabbit.server.impl.jmx.StatisticsMBeanImpl;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="%repository.name", description="%repository.description", metatype=true, name="org.apache.sling.jcr.jackrabbit.server.SlingServerRepository", configurationFactory=true)
@Reference(name="namespaceMapper", referenceInterface=NamespaceMapper.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
@Properties(value={@Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="service.description", value={"Factory for embedded Jackrabbit Repository Instances"})})
public class SlingServerRepositoryManager
extends AbstractSlingRepositoryManager {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Property(value={""})
    public static final String REPOSITORY_CONFIG_URL = "config";
    @Property(value={""})
    public static final String REPOSITORY_HOME_DIR = "home";
    @Property(value={""})
    public static final String REPOSITORY_REGISTRATION_NAME = "name";
    public static final boolean DEFAULT_LOGIN_ADMIN_ENABLED = true;
    @Property
    public static final String PROPERTY_DEFAULT_WORKSPACE = "defaultWorkspace";
    @Property(boolValue={true})
    public static final String PROPERTY_LOGIN_ADMIN_ENABLED = "admin.login.enabled";
    public static final String DEFAULT_ADMIN_USER = "admin";
    @Property(value={"admin"})
    public static final String PROPERTY_ADMIN_USER = "admin.name";
    @Reference
    private ServiceUserMapper serviceUserMapper;
    private NamespaceMapper[] namespaceMappers;
    private ComponentContext componentContext;
    private String adminUserName;
    private Map<String, ServiceRegistration> statisticsServices = new ConcurrentHashMap<String, ServiceRegistration>();
    private Map<Long, NamespaceMapper> namespaceMapperRefs = new TreeMap<Long, NamespaceMapper>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Repository acquireRepository() {
        String configURLObj;
        File homeFile;
        BundleContext bundleContext = this.getComponentContext().getBundleContext();
        String overrideUrl = bundleContext.getProperty("sling.repository.url");
        if (overrideUrl != null && !overrideUrl.isEmpty()) {
            return null;
        }
        String slingHomePath = bundleContext.getProperty("sling.home");
        try {
            homeFile = this.getOrInitRepositoryHome(bundleContext, slingHomePath);
            configURLObj = this.getOrInitConfigFileUrl(bundleContext, homeFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getName() + " initialisation failed", e);
        }
        String home = homeFile.getAbsolutePath();
        if (System.getProperty("derby.stream.error.file") == null) {
            String derbyLog = home + "/derby.log";
            System.setProperty("derby.stream.error.file", derbyLog);
        }
        InputStream ins = null;
        try {
            RepositoryConfig crc;
            if (configURLObj != null && configURLObj.length() > 0) {
                File configFile = new File(configURLObj);
                if (configFile.canRead()) {
                    ins = new FileInputStream(configFile);
                    this.log.info("Using configuration file " + configFile.getAbsolutePath());
                } else {
                    try {
                        URL configURL = new URL(configURLObj);
                        ins = configURL.openStream();
                        this.log.info("Using configuration URL " + configURL);
                    }
                    catch (MalformedURLException mue) {
                        this.log.info("Configuration File " + configFile.getAbsolutePath() + " has been lost, trying to recreate");
                        Bundle bundle = bundleContext.getBundle();
                        SlingServerRepositoryManager.copyFile(bundle, "repository.xml", configFile);
                        ins = new FileInputStream(configFile);
                        this.log.info("Using configuration file " + configFile.getAbsolutePath());
                    }
                }
                crc = RepositoryConfig.create(ins, home);
            } else {
                crc = RepositoryConfig.create(homeFile);
            }
            Repository repository = this.registerStatistics(RepositoryImpl.create(crc));
            return repository;
        }
        catch (IOException ioe) {
            this.log.error("acquireRepository: IO problem starting repository from " + configURLObj + " in " + home, (Throwable)ioe);
        }
        catch (RepositoryException re) {
            this.log.error("acquireRepository: Repository problem starting repository from " + configURLObj + " in " + home, (Throwable)re);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ioe) {}
            }
        }
        return null;
    }

    private File getOrInitRepositoryHome(BundleContext bundleContext, String slingHomePath) throws IOException {
        File homeDir;
        String repoHomePath = (String)this.getComponentContext().getProperties().get(REPOSITORY_HOME_DIR);
        if (repoHomePath == null || repoHomePath.isEmpty()) {
            repoHomePath = bundleContext.getProperty("sling.repository.home");
        }
        if (!(homeDir = repoHomePath != null && !repoHomePath.isEmpty() ? new File(repoHomePath, this.getRepositoryName(bundleContext)) : (slingHomePath != null ? new File(slingHomePath, this.getRepositoryName(bundleContext)) : new File(this.getRepositoryName(bundleContext)))).isDirectory()) {
            this.log.info("Creating default config for Jackrabbit in " + homeDir);
            if (!homeDir.mkdirs()) {
                throw new IOException("verifyConfiguration: Cannot create Jackrabbit home " + homeDir + ", failed creating default configuration");
            }
        }
        return homeDir;
    }

    private String getRepositoryName(BundleContext bundleContext) {
        String repoName = bundleContext.getProperty("sling.repository.name");
        if (repoName != null) {
            return repoName;
        }
        return "jackrabbit";
    }

    private Repository registerStatistics(Repository repository) {
        if (repository instanceof RepositoryImpl) {
            try {
                RepositoryImpl repositoryImpl = (RepositoryImpl)repository;
                StatisticsMBeanImpl mbean = new StatisticsMBeanImpl(repositoryImpl);
                Hashtable<String, String> properties = new Hashtable<String, String>();
                String mbeanName = StatisticsMBeanImpl.getMBeanName(repositoryImpl);
                ((Dictionary)properties).put("jmx.objectname", mbeanName);
                ((Dictionary)properties).put("service.vendor", "Apache");
                this.statisticsServices.put(mbeanName, this.getComponentContext().getBundleContext().registerService(DynamicMBean.class.getName(), (Object)mbean, properties));
            }
            catch (Exception e) {
                this.log.error("Unable to register statistics ", (Throwable)e);
            }
        }
        return repository;
    }

    protected Dictionary<String, Object> getServiceRegistrationProperties() {
        return this.getComponentContext().getProperties();
    }

    protected String[] getServiceRegistrationInterfaces() {
        return new String[]{SlingRepository.class.getName(), Repository.class.getName(), RepositoryManager.class.getName()};
    }

    protected AbstractSlingRepository2 create(Bundle usingBundle) {
        return new SlingServerRepository(this, usingBundle, this.adminUserName);
    }

    protected void destroy(AbstractSlingRepository2 repositoryServiceInstance) {
    }

    protected NamespaceMapper[] getNamespaceMapperServices() {
        return this.namespaceMappers;
    }

    protected ServiceUserMapper getServiceUserMapper() {
        return this.serviceUserMapper;
    }

    protected void disposeRepository(Repository repository) {
        this.unregisterStatistics(repository);
        if (repository instanceof RepositoryImpl) {
            try {
                ((RepositoryImpl)repository).shutdown();
            }
            catch (Throwable t) {
                this.log.error("deactivate: Unexpected problem shutting down repository", t);
            }
        } else {
            this.log.error("Repository is not a RepositoryImpl, nothing to do");
        }
    }

    private void unregisterStatistics(Repository repository) {
        if (repository instanceof RepositoryImpl) {
            String mbeanName = StatisticsMBeanImpl.getMBeanName((RepositoryImpl)repository);
            try {
                ServiceRegistration serviceRegistration = this.statisticsServices.get(mbeanName);
                if (serviceRegistration != null) {
                    serviceRegistration.unregister();
                }
            }
            catch (Exception e) {
                this.log.warn("Failed to unregister statistics JMX bean {} ", (Object)e.getMessage());
            }
            this.statisticsServices.remove(mbeanName);
        }
    }

    protected ComponentContext getComponentContext() {
        return this.componentContext;
    }

    @Activate
    private void activate(ComponentContext componentContext) throws Exception {
        this.componentContext = componentContext;
        Dictionary properties = componentContext.getProperties();
        String defaultWorkspace = PropertiesUtil.toString(properties.get(PROPERTY_DEFAULT_WORKSPACE), null);
        boolean disableLoginAdministrative = !PropertiesUtil.toBoolean(properties.get(PROPERTY_LOGIN_ADMIN_ENABLED), true);
        this.adminUserName = PropertiesUtil.toString(properties.get(PROPERTY_ADMIN_USER), DEFAULT_ADMIN_USER);
        super.start(componentContext.getBundleContext(), defaultWorkspace, disableLoginAdministrative);
    }

    @Deactivate
    private void deactivate(ComponentContext componentContext) {
        super.stop();
        this.adminUserName = null;
        this.componentContext = null;
        this.namespaceMapperRefs.clear();
        this.namespaceMappers = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindNamespaceMapper(NamespaceMapper namespaceMapper, Map<String, Object> props) {
        Map<Long, NamespaceMapper> map = this.namespaceMapperRefs;
        synchronized (map) {
            this.namespaceMapperRefs.put((Long)props.get("service.id"), namespaceMapper);
            this.namespaceMappers = this.namespaceMapperRefs.values().toArray(new NamespaceMapper[this.namespaceMapperRefs.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindNamespaceMapper(NamespaceMapper namespaceMapper, Map<String, Object> props) {
        Map<Long, NamespaceMapper> map = this.namespaceMapperRefs;
        synchronized (map) {
            this.namespaceMapperRefs.remove(props.get("service.id"));
            this.namespaceMappers = this.namespaceMapperRefs.values().toArray(new NamespaceMapper[this.namespaceMapperRefs.size()]);
        }
    }

    private String getOrInitConfigFileUrl(BundleContext bundleContext, String home) throws IOException {
        block8: {
            String repoConfigFileUrl = (String)this.getComponentContext().getProperties().get(REPOSITORY_CONFIG_URL);
            if (repoConfigFileUrl == null || repoConfigFileUrl.isEmpty()) {
                repoConfigFileUrl = bundleContext.getProperty("sling.repository.config.file.url");
            }
            if (repoConfigFileUrl != null) {
                URL configFileUrl = null;
                try {
                    configFileUrl = new URL(repoConfigFileUrl);
                    return repoConfigFileUrl;
                }
                catch (MalformedURLException e) {
                    configFileUrl = new URL("file:///" + repoConfigFileUrl);
                    File configFile = new File(configFileUrl.getFile());
                    if (!configFile.canRead()) break block8;
                    return configFileUrl.toString();
                }
            }
        }
        File configFile = new File(home, "repository.xml");
        boolean copied = false;
        try {
            URL contextConfigURL = new URL("context:repository.xml");
            InputStream contextConfigStream = contextConfigURL.openStream();
            if (contextConfigStream != null) {
                SlingServerRepositoryManager.copyStream(contextConfigStream, configFile);
                copied = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!copied) {
            SlingServerRepositoryManager.copyFile(bundleContext.getBundle(), "repository.xml", configFile);
        }
        return null;
    }

    private static void copyFile(Bundle bundle, String entryPath, File destFile) throws FileNotFoundException, IOException {
        if (destFile.canRead()) {
            return;
        }
        URL entryURL = bundle.getEntry(entryPath);
        if (entryURL == null) {
            throw new FileNotFoundException(entryPath);
        }
        InputStream source = entryURL.openStream();
        SlingServerRepositoryManager.copyStream(source, destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStream(InputStream source, File destFile) throws FileNotFoundException, IOException {
        OutputStream dest = null;
        try {
            int rd;
            destFile.getParentFile().mkdirs();
            dest = new FileOutputStream(destFile);
            byte[] buf = new byte[2048];
            while ((rd = source.read(buf)) >= 0) {
                dest.write(buf, 0, rd);
            }
        }
        finally {
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException ignore) {}
            }
            try {
                source.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void bindServiceUserMapper(ServiceUserMapper serviceUserMapper) {
        this.serviceUserMapper = serviceUserMapper;
    }

    protected void unbindServiceUserMapper(ServiceUserMapper serviceUserMapper) {
        if (this.serviceUserMapper == serviceUserMapper) {
            this.serviceUserMapper = null;
        }
    }
}

