/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.server.impl;

import org.apache.sling.jcr.jackrabbit.server.impl.AccessManagerFactoryTracker;
import org.apache.sling.jcr.jackrabbit.server.security.LoginModulePlugin;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String SERVER_REPOSITORY_FACTORY_PID = "org.apache.sling.jcr.jackrabbit.server.SlingServerRepository";
    public static final String SLING_CONTEXT = "sling.context";
    public static final String SLING_CONTEXT_DEFAULT = "sling.context.default";
    private static BundleContext bundleContext;
    private static ServiceTracker loginModuleTracker;
    private static int lastTrackingCount;
    private static LoginModulePlugin[] moduleCache;
    private static LoginModulePlugin[] EMPTY;
    private String slingContext;
    private static AccessManagerFactoryTracker accessManagerFactoryTracker;

    public void start(BundleContext context) {
        bundleContext = context;
        moduleCache = null;
        this.slingContext = context.getProperty(SLING_CONTEXT_DEFAULT);
        if (this.slingContext == null) {
            this.slingContext = "default";
        }
        if (accessManagerFactoryTracker == null) {
            accessManagerFactoryTracker = new AccessManagerFactoryTracker(bundleContext);
        }
        accessManagerFactoryTracker.open();
    }

    public void stop(BundleContext arg0) {
        moduleCache = null;
        if (loginModuleTracker != null) {
            loginModuleTracker.close();
            loginModuleTracker = null;
        }
        if (accessManagerFactoryTracker != null) {
            accessManagerFactoryTracker.close();
            accessManagerFactoryTracker = null;
        }
        bundleContext = null;
    }

    private static BundleContext getBundleContext() {
        return bundleContext;
    }

    public static LoginModulePlugin[] getLoginModules() {
        if (moduleCache != null && lastTrackingCount == loginModuleTracker.getTrackingCount()) {
            return moduleCache;
        }
        if (loginModuleTracker == null) {
            loginModuleTracker = new ServiceTracker(Activator.getBundleContext(), LoginModulePlugin.class.getName(), null);
            loginModuleTracker.open();
        }
        if (moduleCache == null || lastTrackingCount < loginModuleTracker.getTrackingCount()) {
            Object[] services = loginModuleTracker.getServices();
            if (services == null || services.length == 0) {
                moduleCache = EMPTY;
            } else {
                moduleCache = new LoginModulePlugin[services.length];
                System.arraycopy(services, 0, moduleCache, 0, services.length);
            }
            lastTrackingCount = loginModuleTracker.getTrackingCount();
        }
        return moduleCache;
    }

    public static AccessManagerFactoryTracker getAccessManagerFactoryTracker() {
        return accessManagerFactoryTracker;
    }

    static {
        lastTrackingCount = -1;
        EMPTY = new LoginModulePlugin[0];
    }
}

