/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.value;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.value.AbstractQValueFactory;

public final class InternalValueFactory
extends AbstractQValueFactory {
    private static final QValueFactory INSTANCE = new InternalValueFactory(null);
    private final DataStore store;

    InternalValueFactory(DataStore store) {
        this.store = store;
    }

    public static QValueFactory getInstance() {
        return INSTANCE;
    }

    public QValue create(Calendar value) throws RepositoryException {
        return InternalValue.create(value);
    }

    public QValue create(double value) throws RepositoryException {
        return InternalValue.create(value);
    }

    public QValue create(long value) throws RepositoryException {
        return InternalValue.create(value);
    }

    public QValue create(boolean value) throws RepositoryException {
        return InternalValue.create(value);
    }

    public QValue create(Name value) throws RepositoryException {
        return InternalValue.create(value);
    }

    public QValue create(Path value) throws RepositoryException {
        return InternalValue.create(value);
    }

    public QValue create(URI value) throws RepositoryException {
        return InternalValue.create(value);
    }

    public QValue create(BigDecimal value) throws RepositoryException {
        return InternalValue.create(value);
    }

    public QValue create(byte[] value) throws RepositoryException {
        if (this.store == null) {
            return InternalValue.create(value);
        }
        return InternalValue.create(new ByteArrayInputStream(value), this.store);
    }

    public QValue create(InputStream value) throws RepositoryException, IOException {
        if (this.store == null) {
            return InternalValue.createTemporary(value);
        }
        return InternalValue.create(value, this.store);
    }

    public QValue create(File value) throws RepositoryException, IOException {
        FileInputStream in = new FileInputStream(value);
        if (this.store == null) {
            return InternalValue.createTemporary(in);
        }
        return InternalValue.create(in, this.store);
    }

    protected QValue createReference(String ref, boolean weak) {
        return InternalValue.create(new NodeId(ref), weak);
    }

    protected QValue createString(String value) {
        return InternalValue.create(value);
    }
}

