/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.mem;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.bundle.AbstractBundlePersistenceManager;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.persistence.util.BundleBinding;
import org.apache.jackrabbit.core.persistence.util.ErrorHandling;
import org.apache.jackrabbit.core.persistence.util.FileSystemBLOBStore;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.persistence.util.Serializer;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemBundlePersistenceManager
extends AbstractBundlePersistenceManager {
    private static Logger log = LoggerFactory.getLogger(InMemBundlePersistenceManager.class);
    protected boolean initialized = false;
    protected static final String BUNDLE_FILE_PATH = "/data/.bundle.bin";
    protected static final String BLOBS_FILE_PATH = "/data/.blobs.bin";
    protected static final String REFS_FILE_PATH = "/data/.refs.bin";
    protected FileSystem wspFS;
    protected FileSystem blobFS;
    protected static final int INITIAL_BUFFER_SIZE = 1024;
    private int minBlobSize = 4096;
    protected ErrorHandling errorHandling = new ErrorHandling();
    protected BundleBinding binding;
    protected Map<NodeId, byte[]> bundleStore;
    protected Map<NodeId, byte[]> refsStore;
    protected BLOBStore blobStore;
    private Map<String, byte[]> blobs;
    protected int initialCapacity = 32768;
    protected float loadFactor = 0.75f;
    protected boolean persistent = true;
    protected boolean useFileBlobStore = false;

    public void setInitialCapacity(int initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public void setInitialCapacity(String initialCapacity) {
        this.initialCapacity = Integer.parseInt(initialCapacity);
    }

    public String getInitialCapacity() {
        return Integer.toString(this.initialCapacity);
    }

    public void setLoadFactor(float loadFactor) {
        this.loadFactor = loadFactor;
    }

    public void setLoadFactor(String loadFactor) {
        this.loadFactor = Float.parseFloat(loadFactor);
    }

    public String getLoadFactor() {
        return Float.toString(this.loadFactor);
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setPersistent(String persistent) {
        this.persistent = Boolean.valueOf(persistent);
    }

    public void setUseFileBlobStore(boolean useFileBlobStore) {
        this.useFileBlobStore = useFileBlobStore;
    }

    public void setUseFileBlobStore(String useFileBlobStore) {
        this.useFileBlobStore = Boolean.valueOf(useFileBlobStore);
    }

    public String getMinBlobSize() {
        return String.valueOf(this.minBlobSize);
    }

    public void setMinBlobSize(String minBlobSize) {
        this.minBlobSize = Integer.decode(minBlobSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadContents() throws Exception {
        byte[] data;
        int length;
        NodeId id;
        String s;
        int n;
        FileSystemResource fsRes = new FileSystemResource(this.wspFS, BUNDLE_FILE_PATH);
        if (!fsRes.exists()) {
            return;
        }
        BufferedInputStream bis = new BufferedInputStream(fsRes.getInputStream());
        DataInputStream in = new DataInputStream(bis);
        try {
            n = in.readInt();
            while (n-- > 0) {
                s = in.readUTF();
                id = NodeId.valueOf(s);
                length = in.readInt();
                data = new byte[length];
                in.readFully(data);
                this.bundleStore.put(id, data);
            }
        }
        finally {
            in.close();
        }
        fsRes = new FileSystemResource(this.wspFS, REFS_FILE_PATH);
        bis = new BufferedInputStream(fsRes.getInputStream());
        in = new DataInputStream(bis);
        try {
            n = in.readInt();
            while (n-- > 0) {
                s = in.readUTF();
                id = NodeId.valueOf(s);
                length = in.readInt();
                data = new byte[length];
                in.readFully(data);
                this.refsStore.put(id, data);
            }
        }
        finally {
            in.close();
        }
        if (!this.useFileBlobStore) {
            fsRes = new FileSystemResource(this.wspFS, BLOBS_FILE_PATH);
            bis = new BufferedInputStream(fsRes.getInputStream());
            in = new DataInputStream(bis);
            try {
                n = in.readInt();
                while (n-- > 0) {
                    String id2 = in.readUTF();
                    int length2 = in.readInt();
                    byte[] data2 = new byte[length2];
                    in.readFully(data2);
                    this.blobs.put(id2, data2);
                }
            }
            finally {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void storeContents() throws Exception {
        byte[] data;
        FileSystemResource fsRes = new FileSystemResource(this.wspFS, BUNDLE_FILE_PATH);
        fsRes.makeParentDirs();
        BufferedOutputStream bos = new BufferedOutputStream(fsRes.getOutputStream());
        DataOutputStream out = new DataOutputStream(bos);
        try {
            out.writeInt(this.bundleStore.size());
            for (NodeId nodeId : this.bundleStore.keySet()) {
                out.writeUTF(nodeId.toString());
                data = this.bundleStore.get(nodeId);
                out.writeInt(data.length);
                out.write(data);
            }
        }
        finally {
            out.close();
        }
        fsRes = new FileSystemResource(this.wspFS, REFS_FILE_PATH);
        fsRes.makeParentDirs();
        bos = new BufferedOutputStream(fsRes.getOutputStream());
        out = new DataOutputStream(bos);
        try {
            out.writeInt(this.refsStore.size());
            for (NodeId nodeId : this.refsStore.keySet()) {
                out.writeUTF(nodeId.toString());
                data = this.refsStore.get(nodeId);
                out.writeInt(data.length);
                out.write(data);
            }
        }
        finally {
            out.close();
        }
        if (!this.useFileBlobStore) {
            fsRes = new FileSystemResource(this.wspFS, BLOBS_FILE_PATH);
            fsRes.makeParentDirs();
            bos = new BufferedOutputStream(fsRes.getOutputStream());
            out = new DataOutputStream(bos);
            try {
                out.writeInt(this.blobs.size());
                for (String string : this.blobs.keySet()) {
                    out.writeUTF(string);
                    data = this.blobs.get(string);
                    out.writeInt(data.length);
                    out.write(data);
                }
            }
            finally {
                out.close();
            }
        }
    }

    @Override
    public void init(PMContext context) throws Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        super.init(context);
        this.bundleStore = new LinkedHashMap<NodeId, byte[]>(this.initialCapacity, this.loadFactor);
        this.refsStore = new HashMap<NodeId, byte[]>(this.initialCapacity, this.loadFactor);
        if (this.useFileBlobStore) {
            this.blobFS = new LocalFileSystem();
            ((LocalFileSystem)this.blobFS).setRoot(new File(context.getHomeDir(), "blobs"));
            this.blobFS.init();
            this.blobStore = new FileSystemBLOBStore(this.blobFS);
        } else {
            this.blobStore = new InMemBLOBStore();
        }
        this.wspFS = context.getFileSystem();
        this.binding = new BundleBinding(this.errorHandling, this.blobStore, this.getNsIndex(), this.getNameIndex(), context.getDataStore());
        this.binding.setMinBlobSize(this.minBlobSize);
        if (this.persistent) {
            this.loadContents();
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            if (this.persistent) {
                this.storeContents();
            } else if (this.useFileBlobStore) {
                this.blobFS.close();
                this.wspFS.deleteFolder("blobs");
            }
        }
        finally {
            this.initialized = false;
        }
    }

    @Override
    public NodeReferences loadReferencesTo(NodeId id) throws NoSuchItemStateException, ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        if (!this.refsStore.containsKey(id)) {
            throw new NoSuchItemStateException(id.toString());
        }
        try {
            NodeReferences refs = new NodeReferences(id);
            Serializer.deserialize(refs, (InputStream)new ByteArrayInputStream(this.refsStore.get(id)));
            return refs;
        }
        catch (Exception e) {
            String msg = "failed to read references: " + id;
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, e);
        }
    }

    @Override
    protected void store(NodeReferences refs) throws ItemStateException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Serializer.serialize(refs, (OutputStream)out);
            this.refsStore.put(refs.getTargetId(), out.toByteArray());
        }
        catch (Exception e) {
            String msg = "failed to store " + refs;
            log.debug(msg);
            throw new ItemStateException(msg, e);
        }
    }

    @Override
    public boolean existsReferencesTo(NodeId targetId) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        return this.refsStore.containsKey(targetId);
    }

    @Override
    protected void destroy(NodeReferences refs) throws ItemStateException {
        this.refsStore.remove(refs.getTargetId());
    }

    @Override
    public List<NodeId> getAllNodeIds(NodeId after, int maxCount) throws ItemStateException, RepositoryException {
        ArrayList<NodeId> result = new ArrayList<NodeId>();
        boolean add = after == null;
        int count = 0;
        for (NodeId nodeId : this.bundleStore.keySet()) {
            if (add) {
                result.add(nodeId);
                if (++count != maxCount) continue;
                break;
            }
            add = nodeId.equals(after);
        }
        return result;
    }

    @Override
    protected NodePropBundle loadBundle(NodeId id) throws ItemStateException {
        if (!this.bundleStore.containsKey(id)) {
            return null;
        }
        try {
            return this.binding.readBundle(new ByteArrayInputStream(this.bundleStore.get(id)), id);
        }
        catch (Exception e) {
            String msg = "failed to read bundle: " + id + ": " + e;
            log.error(msg);
            throw new ItemStateException(msg, e);
        }
    }

    @Override
    protected void storeBundle(NodePropBundle bundle) throws ItemStateException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        try {
            this.binding.writeBundle(out, bundle);
            this.bundleStore.put(bundle.getId(), out.toByteArray());
        }
        catch (IOException e) {
            String msg = "failed to write bundle: " + bundle.getId();
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, e);
        }
    }

    @Override
    protected void destroyBundle(NodePropBundle bundle) throws ItemStateException {
        this.bundleStore.remove(bundle.getId());
    }

    @Override
    protected BLOBStore getBlobStore() {
        return this.blobStore;
    }

    protected class InMemBLOBStore
    implements CloseableBLOBStore {
        public InMemBLOBStore() {
            InMemBundlePersistenceManager.this.blobs = new HashMap();
        }

        @Override
        public String createId(PropertyId id, int index) {
            StringBuilder buf = new StringBuilder();
            buf.append(id.getParentId().toString());
            buf.append('.');
            buf.append(InMemBundlePersistenceManager.this.getNsIndex().stringToIndex(id.getName().getNamespaceURI()));
            buf.append('.');
            buf.append(InMemBundlePersistenceManager.this.getNameIndex().stringToIndex(id.getName().getLocalName()));
            buf.append('.');
            buf.append(index);
            return buf.toString();
        }

        @Override
        public void put(String blobId, InputStream in, long size) throws Exception {
            InMemBundlePersistenceManager.this.blobs.put(blobId, IOUtils.toByteArray((InputStream)in));
        }

        @Override
        public InputStream get(String blobId) throws Exception {
            if (InMemBundlePersistenceManager.this.blobs.containsKey(blobId)) {
                return new ByteArrayInputStream((byte[])InMemBundlePersistenceManager.this.blobs.get(blobId));
            }
            return null;
        }

        @Override
        public boolean remove(String blobId) throws Exception {
            return InMemBundlePersistenceManager.this.blobs.remove(blobId) != null;
        }

        @Override
        public void close() {
            InMemBundlePersistenceManager.this.blobs.clear();
        }
    }

    protected static interface CloseableBLOBStore
    extends BLOBStore {
        public void close();
    }
}

