/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal.mapper.jcr;

import java.io.InputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.fsprovider.internal.mapper.ContentFile;
import org.apache.sling.fsprovider.internal.mapper.jcr.FsItem;
import org.apache.sling.fsprovider.internal.mapper.jcr.FsPropertyDefinition;
import org.apache.sling.fsprovider.internal.mapper.jcr.FsValue;

class FsProperty
extends FsItem
implements Property {
    private final String propertyName;
    private final Node node;

    public FsProperty(ContentFile contentFile, ResourceResolver resolver, String propertyName, Node node) {
        super(contentFile, resolver);
        this.propertyName = propertyName;
        this.node = node;
    }

    public String getName() throws RepositoryException {
        return this.propertyName;
    }

    public Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return this.getNode();
    }

    public Node getNode() throws ItemNotFoundException, ValueFormatException, RepositoryException {
        return this.node;
    }

    @Override
    public String getPath() throws RepositoryException {
        return super.getPath() + "/" + this.propertyName;
    }

    public Value getValue() throws ValueFormatException, RepositoryException {
        return new FsValue(this.props, this.propertyName);
    }

    public String getString() throws ValueFormatException, RepositoryException {
        return this.getValue().getString();
    }

    public InputStream getStream() throws ValueFormatException, RepositoryException {
        return this.getValue().getStream();
    }

    public Binary getBinary() throws ValueFormatException, RepositoryException {
        return this.getValue().getBinary();
    }

    public long getLong() throws ValueFormatException, RepositoryException {
        return this.getValue().getLong();
    }

    public double getDouble() throws ValueFormatException, RepositoryException {
        return this.getValue().getDouble();
    }

    public BigDecimal getDecimal() throws ValueFormatException, RepositoryException {
        return this.getValue().getDecimal();
    }

    public Calendar getDate() throws ValueFormatException, RepositoryException {
        return this.getValue().getDate();
    }

    public boolean getBoolean() throws ValueFormatException, RepositoryException {
        return this.getValue().getBoolean();
    }

    public Value[] getValues() throws ValueFormatException, RepositoryException {
        if (!this.isMultiple()) {
            throw new ValueFormatException();
        }
        Object value = this.props.get((Object)this.propertyName);
        int size = Array.getLength(value);
        Value[] result = new Value[size];
        for (int i = 0; i < size; ++i) {
            result[i] = new FsValue(this.props, this.propertyName, i);
        }
        return result;
    }

    public boolean isMultiple() throws RepositoryException {
        Object value = this.props.get((Object)this.propertyName);
        return value != null && value.getClass().isArray();
    }

    public int getType() throws RepositoryException {
        return this.getValue().getType();
    }

    public PropertyDefinition getDefinition() throws RepositoryException {
        return new FsPropertyDefinition(this.propertyName);
    }

    public void setValue(Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void setValue(Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void setValue(String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void setValue(String[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void setValue(InputStream value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void setValue(Binary value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void setValue(long value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void setValue(double value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void setValue(BigDecimal value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void setValue(Calendar value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void setValue(boolean value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void setValue(Node value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property getProperty() throws ItemNotFoundException, ValueFormatException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public long getLength() throws ValueFormatException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public long[] getLengths() throws ValueFormatException, RepositoryException {
        throw new UnsupportedOperationException();
    }
}

