/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.crankstart.launcher;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public class CrankstartBootstrap {
    public static final String CLASSPATH_PREFIX = "classpath ";
    private final String crankFile;
    private final File tempFile;

    public CrankstartBootstrap(String filename) {
        this.tempFile = null;
        this.crankFile = filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrankstartBootstrap(Reader r) throws IOException {
        this.tempFile = File.createTempFile("CRANKSTART", "crank.txt");
        this.tempFile.deleteOnExit();
        this.crankFile = this.tempFile.getAbsolutePath();
        FileWriter w = new FileWriter(this.tempFile);
        char[] buf = new char[4096];
        int len = 0;
        try {
            while ((len = r.read(buf, 0, buf.length)) > 0) {
                w.write(buf, 0, len);
            }
        }
        finally {
            w.flush();
            w.close();
        }
    }

    private void cleanup() {
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        System.setProperty("crankstart.input.filename", this.crankFile);
        System.setProperty("java.protocol.handler.pkgs", "org.ops4j.pax.url");
        URL[] launcherClasspath = CrankstartBootstrap.getClasspath(this.crankFile);
        URLClassLoader launcherClassloader = new URLClassLoader(launcherClasspath, null);
        try {
            String callableClass = "org.apache.sling.crankstart.core.CrankstartFileProcessor";
            Callable c = (Callable)launcherClassloader.loadClass("org.apache.sling.crankstart.core.CrankstartFileProcessor").newInstance();
            c.call();
        }
        finally {
            if (launcherClassloader instanceof Closeable) {
                launcherClassloader.close();
            }
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL[] getClasspath(String filename) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        FileReader input = new FileReader(new File(filename));
        BufferedReader r = new BufferedReader(input);
        try {
            String line = null;
            while ((line = r.readLine()) != null) {
                if (line.length() == 0 || line.startsWith("#") || !line.startsWith(CLASSPATH_PREFIX)) continue;
                urls.add(new URL(line.substring(CLASSPATH_PREFIX.length()).trim()));
            }
            URL[] uRLArray = urls.toArray(new URL[0]);
            return uRLArray;
        }
        finally {
            r.close();
        }
    }
}

