/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal.joran;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.AppenderRefModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.AppenderRefModelHandler;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.AppenderAttachable;
import java.util.Map;
import org.apache.sling.commons.log.logback.internal.AppenderOrigin;
import org.apache.sling.commons.log.logback.internal.LogConfigManager;
import org.jetbrains.annotations.NotNull;

class AppenderRefModelHandlerWrapper
extends AppenderRefModelHandler {
    private LogConfigManager logConfigManager;

    AppenderRefModelHandlerWrapper(@NotNull Context context, @NotNull LogConfigManager manager) {
        super(context);
        this.logConfigManager = manager;
    }

    @Override
    public void handle(@NotNull ModelInterpretationContext mic, @NotNull Model model) throws ModelHandlerException {
        AppenderAttachable appenderAttachable;
        Object o;
        super.handle(mic, model);
        AppenderRefModel appenderRefModel = (AppenderRefModel)model;
        String appenderName = mic.subst(appenderRefModel.getRef());
        Map appenderBag = (Map)mic.getObjectMap().get("APPENDER_BAG");
        Appender appender = (Appender)appenderBag.get(appenderName);
        if (appender != null && (o = mic.peekObject()) instanceof AppenderAttachable && (appenderAttachable = (AppenderAttachable)o) instanceof Logger) {
            appenderAttachable.addAppender(appender);
            String loggerName = ((Logger)appenderAttachable).getName();
            this.logConfigManager.addedAppenderRef(AppenderOrigin.JORAN, appenderName, loggerName);
        }
    }
}

