/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.request.builder.impl;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HeaderSupport {
    private static final DateTimeFormatter RFC_1123_DATE_TIME = DateTimeFormatter.RFC_1123_DATE_TIME;
    private final Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();

    public void addHeader(String name, String value) {
        this.headers.computeIfAbsent(name, key -> new ArrayList()).add(value);
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, Integer.toString(value));
    }

    public void addDateHeader(String name, long date) {
        Date d = new Date(date);
        this.addHeader(name, RFC_1123_DATE_TIME.format(d.toInstant().atOffset(ZoneOffset.UTC)));
    }

    public void setHeader(String name, String value) {
        this.removeHeaders(name);
        this.addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.removeHeaders(name);
        this.addIntHeader(name, value);
    }

    public void setDateHeader(String name, long date) {
        this.removeHeaders(name);
        this.addDateHeader(name, date);
    }

    private void removeHeaders(String name) {
        this.headers.remove(name);
    }

    public boolean containsHeader(String name) {
        return this.headers.get(name) != null;
    }

    public String getHeader(String name) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            return null;
        }
        return values.get(0);
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value != null) {
            return Integer.valueOf(value);
        }
        return -1;
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value != null) {
            try {
                Date date = Date.from(ZonedDateTime.parse(value, RFC_1123_DATE_TIME).toInstant());
                return date.getTime();
            }
            catch (DateTimeParseException ex) {
                throw new IllegalArgumentException("Invalid date value: " + value, ex);
            }
        }
        return -1L;
    }

    public Collection<String> getHeaders(String name) {
        ArrayList<String> values = new ArrayList<String>();
        List<String> headers = this.headers.get(name);
        if (headers != null) {
            values.addAll(headers);
        }
        return values;
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public void reset() {
        this.headers.clear();
    }
}

