/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.jspc;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.sling.scripting.jsp.jasper.compiler.TldLocationsCache;

public class JspCServletContext
implements ServletContext {
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private final TldLocationsCache tldLocationsCache;
    private Hashtable<String, Object> attributes;
    private Log log;
    private URL resourceBaseURL;
    private List<URL> baseURLs = new ArrayList<URL>();

    public JspCServletContext(Log log, URL resourceBaseURL, TldLocationsCache tldLocationsCache) {
        this.tldLocationsCache = tldLocationsCache;
        this.attributes = new Hashtable();
        this.log = log;
        this.resourceBaseURL = resourceBaseURL;
        this.baseURLs.add(resourceBaseURL);
    }

    public void addAlternativeBaseURL(URL altBaseURL) {
        this.baseURLs.add(altBaseURL);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.attributes.keys();
    }

    public ServletContext getContext(String uripath) {
        return null;
    }

    public String getInitParameter(String name) {
        return null;
    }

    public Enumeration<String> getInitParameterNames() {
        return new Vector().elements();
    }

    public int getMajorVersion() {
        return 3;
    }

    public String getMimeType(String file) {
        return null;
    }

    public int getMinorVersion() {
        return 1;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return null;
    }

    public String getRealPath(String path) {
        if (!"file".equals(this.resourceBaseURL.getProtocol())) {
            return null;
        }
        if (!path.startsWith("/")) {
            return null;
        }
        try {
            return this.getResource(path).getFile().replace('/', File.separatorChar);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getResource(String path) throws MalformedURLException {
        if (WEB_XML.equals(path)) {
            return this.getClass().getResource("web.xml");
        }
        if (!path.startsWith("/")) {
            if (path.startsWith("tld:")) {
                int cs = path.indexOf(":/");
                if (cs > 0 && cs < path.length() - 2 && (cs += 2) < path.length() && path.charAt(cs) != '/') {
                    path = path.substring(0, cs) + "/" + path.substring(cs);
                }
                try {
                    String[] location = this.tldLocationsCache.getLocation(path.substring("tld:".length()));
                    if (location != null && location[0].equals(path)) {
                        return new URL(location[1]);
                    }
                }
                catch (Exception location) {
                    // empty catch block
                }
            }
            throw new MalformedURLException("Path '" + path + "' does not start with '/'");
        }
        for (URL base : this.baseURLs) {
            URL url = new URL(base, path.substring(1));
            InputStream is = null;
            try {
                is = url.openStream();
                URL uRL = url;
                return uRL;
            }
            catch (Throwable throwable) {}
            continue;
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        try {
            return this.getResource(path).openStream();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public Set<String> getResourcePaths(String path) {
        String basePath;
        HashSet<String> thePaths = new HashSet<String>();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if ((basePath = this.getRealPath(path)) == null) {
            return thePaths;
        }
        File theBaseDir = new File(basePath);
        if (!theBaseDir.exists() || !theBaseDir.isDirectory()) {
            return thePaths;
        }
        for (String theFile : theBaseDir.list()) {
            File testFile = new File(basePath + File.separator + theFile);
            if (testFile.isFile()) {
                thePaths.add(path + theFile);
                continue;
            }
            if (!testFile.isDirectory()) continue;
            thePaths.add(path + theFile + "/");
        }
        return thePaths;
    }

    public String getServerInfo() {
        return "JspCServletContext/1.0";
    }

    @Deprecated
    public Servlet getServlet(String name) {
        return null;
    }

    public String getServletContextName() {
        return this.getServerInfo();
    }

    public String getContextPath() {
        return "/";
    }

    @Deprecated
    public Enumeration<String> getServletNames() {
        return new Vector().elements();
    }

    @Deprecated
    public Enumeration<Servlet> getServlets() {
        return new Vector().elements();
    }

    public void log(String message) {
        this.log.info((CharSequence)message);
    }

    @Deprecated
    public void log(Exception exception, String message) {
        this.log(message, exception);
    }

    public void log(String message, Throwable exception) {
        this.log.error((CharSequence)message, exception);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public int getEffectiveMajorVersion() {
        return this.getMinorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.getMajorVersion();
    }

    public boolean setInitParameter(String name, String value) {
        throw new IllegalStateException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        throw new IllegalStateException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        throw new IllegalStateException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        throw new IllegalStateException();
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        throw new IllegalStateException();
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return null;
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        throw new IllegalStateException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        throw new IllegalStateException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        throw new IllegalStateException();
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        throw new IllegalStateException();
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return null;
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return null;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return null;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return null;
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return null;
    }

    public void addListener(String className) {
        throw new IllegalStateException();
    }

    public <T extends EventListener> void addListener(T t) {
        throw new IllegalStateException();
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        throw new IllegalStateException();
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        throw new IllegalStateException();
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public void declareRoles(String ... roleNames) {
        throw new IllegalStateException();
    }

    public String getVirtualServerName() {
        return null;
    }
}

