/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.handler.governance;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.decorators.Decorators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.ProviderFilter;
import org.apache.servicecomb.core.governance.MatchType;
import org.apache.servicecomb.governance.handler.CircuitBreakerHandler;
import org.apache.servicecomb.governance.marker.GovernanceRequestExtractor;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ProviderCircuitBreakerFilter
extends AbstractFilter
implements ProviderFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProviderCircuitBreakerFilter.class);
    private final CircuitBreakerHandler circuitBreakerHandler;

    @Autowired
    public ProviderCircuitBreakerFilter(CircuitBreakerHandler circuitBreakerHandler) {
        this.circuitBreakerHandler = circuitBreakerHandler;
    }

    public int getOrder() {
        return -1890;
    }

    public String getName() {
        return "provider-circuit-breaker";
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        Supplier<CompletionStage<Response>> next = this.createBusinessCompletionStageSupplier(invocation, nextNode);
        Decorators.DecorateCompletionStage dcs = Decorators.ofCompletionStage(next);
        GovernanceRequestExtractor request = MatchType.createGovHttpRequest((Invocation)invocation);
        this.addCircuitBreaker((Decorators.DecorateCompletionStage<Response>)dcs, request);
        CompletableFuture<Response> future = new CompletableFuture<Response>();
        dcs.get().whenComplete((r, e) -> {
            if (e == null) {
                future.complete((Response)r);
                return;
            }
            if (e instanceof CallNotPermittedException) {
                future.completeExceptionally((Throwable)new InvocationException(429, "circuitBreaker is open.", (Object)new CommonExceptionData("circuitBreaker is open.")));
                LOGGER.warn("circuitBreaker is open by policy : {}", (Object)e.getMessage());
            } else {
                future.completeExceptionally((Throwable)e);
            }
        });
        return future;
    }

    private void addCircuitBreaker(Decorators.DecorateCompletionStage<Response> dcs, GovernanceRequestExtractor request) {
        CircuitBreaker circuitBreaker = (CircuitBreaker)this.circuitBreakerHandler.getActuator(request);
        if (circuitBreaker != null) {
            dcs.withCircuitBreaker(circuitBreaker);
        }
    }

    private Supplier<CompletionStage<Response>> createBusinessCompletionStageSupplier(Invocation invocation, FilterNode nextNode) {
        return () -> nextNode.onFilter(invocation);
    }
}

