/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance.filter;

import com.netflix.config.DynamicPropertyFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.cache.VersionedCache;
import org.apache.servicecomb.loadbalance.Configuration;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.discovery.AbstractDiscoveryFilter;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryContext;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryTreeNode;

public class InstancePropertyDiscoveryFilter
extends AbstractDiscoveryFilter {
    private static final String MATCHED = "matched";

    public int getOrder() {
        return 400;
    }

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.loadbalance.filter.instanceProperty.enabled", true).get();
    }

    public boolean isGroupingFilter() {
        return false;
    }

    protected void init(DiscoveryContext context, DiscoveryTreeNode parent) {
        HashMap matchedInstance = new HashMap();
        Invocation invocation = (Invocation)context.getInputParameters();
        Map instances = (Map)parent.data();
        Map<String, String> filterOptions = Configuration.INSTANCE.getFlowsplitFilterOptions(invocation.getMicroserviceName());
        instances.forEach((key, target) -> {
            if (this.allowVisit((MicroserviceInstance)target, filterOptions)) {
                matchedInstance.put(key, target);
            }
        });
        parent.child(MATCHED, (DiscoveryTreeNode)new DiscoveryTreeNode().subName((VersionedCache)parent, MATCHED).data(matchedInstance));
    }

    protected String findChildName(DiscoveryContext context, DiscoveryTreeNode parent) {
        return MATCHED;
    }

    protected boolean allowVisit(MicroserviceInstance instance, Map<String, String> filterOptions) {
        Map propertiesMap = instance.getProperties();
        for (Map.Entry<String, String> entry : filterOptions.entrySet()) {
            if (entry.getValue().equals(propertiesMap.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }
}

