/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics.publish.spectator;

import com.netflix.spectator.api.Measurement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MeasurementNode {
    private String name;
    private List<Measurement> measurements = new ArrayList<Measurement>();
    private Map<String, MeasurementNode> children;

    public MeasurementNode(String name, Map<String, MeasurementNode> children) {
        this.name = name;
        this.children = children;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, MeasurementNode> getChildren() {
        return this.children;
    }

    public MeasurementNode findChild(String childName) {
        if (this.children == null) {
            return null;
        }
        return this.children.get(childName);
    }

    public MeasurementNode findChild(String ... childNames) {
        MeasurementNode node = this;
        for (String childName : childNames) {
            if (node == null) {
                return null;
            }
            node = node.findChild(childName);
        }
        return node;
    }

    public MeasurementNode addChild(String childName, Measurement measurement) {
        if (this.children == null) {
            this.children = new LinkedHashMap<String, MeasurementNode>();
        }
        MeasurementNode node = this.children.computeIfAbsent(childName, name -> new MeasurementNode((String)name, null));
        node.addMeasurement(measurement);
        return node;
    }

    public List<Measurement> getMeasurements() {
        return this.measurements;
    }

    public void addMeasurement(Measurement measurement) {
        this.measurements.add(measurement);
    }

    public double summary() {
        double result = 0.0;
        for (Measurement measurement : this.measurements) {
            result += measurement.value();
        }
        return result;
    }
}

