/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core;

import io.swagger.models.Info;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.foundation.common.utils.JvmUtils;
import org.apache.servicecomb.swagger.generator.core.ClassAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.core.OperationGenerator;
import org.apache.servicecomb.swagger.generator.core.SwaggerGeneratorContext;
import org.apache.servicecomb.swagger.generator.core.utils.MethodUtils;
import org.springframework.util.StringUtils;

public class SwaggerGenerator {
    protected SwaggerGeneratorContext context;
    protected String packageName;
    protected ClassLoader classLoader;
    protected Class<?> cls;
    protected Swagger swagger;
    protected Set<String> defaultTags = new LinkedHashSet<String>();
    private Map<String, OperationGenerator> operationGeneratorMap = new LinkedHashMap<String, OperationGenerator>();
    private String httpMethod;

    public SwaggerGenerator(SwaggerGeneratorContext context, Class<?> cls) {
        this.swagger = new Swagger();
        this.context = context;
        this.cls = cls;
        this.classLoader = JvmUtils.findClassLoader();
        this.packageName = "gen.swagger";
    }

    public SwaggerGeneratorContext getContext() {
        return this.context;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String ensureGetPackageName() {
        if (this.packageName == null) {
            throw new Error("package name must not be null.");
        }
        return this.packageName;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Swagger getSwagger() {
        return this.swagger;
    }

    public Class<?> getCls() {
        return this.cls;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod.toLowerCase(Locale.US);
    }

    public Swagger generate() {
        for (Annotation annotation : this.cls.getAnnotations()) {
            ClassAnnotationProcessor processor = this.context.findClassAnnotationProcessor(annotation.annotationType());
            if (processor == null) continue;
            processor.process(annotation, this);
        }
        this.scanMethods();
        this.addOperationsToSwagger();
        this.correctSwagger();
        return this.swagger;
    }

    protected void correctSwagger() {
        if (StringUtils.isEmpty((Object)this.swagger.getSwagger())) {
            this.swagger.setSwagger("2.0");
        }
        this.correctBasePath();
        this.correctInfo();
        this.correctProduces();
        this.correctConsumes();
    }

    private void correctProduces() {
        List<String> produces = this.swagger.getProduces();
        if (produces == null || produces.isEmpty()) {
            produces = Arrays.asList("application/json");
            this.swagger.setProduces(produces);
        }
    }

    private void correctConsumes() {
        List<String> consumes = this.swagger.getConsumes();
        if (consumes == null || consumes.isEmpty()) {
            consumes = Arrays.asList("application/json");
            this.swagger.setConsumes(consumes);
        }
    }

    protected void correctBasePath() {
        String basePath = this.swagger.getBasePath();
        if (StringUtils.isEmpty((Object)basePath)) {
            basePath = "/" + this.cls.getSimpleName();
        }
        if (!basePath.startsWith("/")) {
            basePath = "/" + basePath;
        }
        this.swagger.setBasePath(basePath);
    }

    private void correctInfo() {
        Info info = this.swagger.getInfo();
        if (info == null) {
            info = new Info();
            this.swagger.setInfo(info);
        }
        if (StringUtils.isEmpty((Object)info.getTitle())) {
            info.setTitle("swagger definition for " + this.cls.getName());
        }
        if (StringUtils.isEmpty((Object)info.getVersion())) {
            info.setVersion("1.0.0");
        }
        this.setJavaInterface(info, this.cls);
    }

    protected void setJavaInterface(Info info, Class<?> cls) {
        if (cls.isInterface() && !this.isInterfaceReactive(cls)) {
            info.setVendorExtension("x-java-interface", (Object)cls.getName());
            return;
        }
        String intfName = this.ensureGetPackageName() + "." + cls.getSimpleName() + "Intf";
        info.setVendorExtension("x-java-interface", (Object)intfName);
    }

    private boolean isInterfaceReactive(Class<?> interfaceCls) {
        for (Method method : MethodUtils.findProducerMethods(interfaceCls)) {
            if (this.isSkipMethod(method) || !CompletableFuture.class.isAssignableFrom(method.getReturnType())) continue;
            return true;
        }
        return false;
    }

    protected boolean isSkipMethod(Method m) {
        return !this.context.canProcess(m);
    }

    protected void scanMethods() {
        List<Method> methods = MethodUtils.findProducerMethods(this.cls);
        for (Method method : methods) {
            if (this.isSkipMethod(method)) continue;
            OperationGenerator operationGenerator = new OperationGenerator(this, method);
            operationGenerator.setHttpMethod(this.httpMethod);
            try {
                operationGenerator.generate();
            }
            catch (Throwable e) {
                String msg = String.format("generate operation swagger failed, %s:%s", this.cls.getName(), method.getName());
                throw new Error(msg, e);
            }
            String operationId = operationGenerator.getOperation().getOperationId();
            if (this.operationGeneratorMap.containsKey(operationId)) {
                throw new Error(String.format("OperationId must be unique. %s:%s", this.cls.getName(), method.getName()));
            }
            this.operationGeneratorMap.put(operationId, operationGenerator);
        }
    }

    protected void addOperationsToSwagger() {
        for (OperationGenerator operationGenerator : this.operationGeneratorMap.values()) {
            operationGenerator.addOperationToSwagger();
        }
    }

    public void setBasePath(String basePath) {
        basePath = this.context.resolveStringValue(basePath);
        this.swagger.setBasePath(basePath);
    }

    public Map<String, OperationGenerator> getOperationGeneratorMap() {
        return this.operationGeneratorMap;
    }

    public List<Parameter> findProviderParameter(String methodName) {
        OperationGenerator operationGenerator = this.operationGeneratorMap.get(methodName);
        if (operationGenerator == null) {
            throw new Error("method not found, name=" + methodName);
        }
        return operationGenerator.getProviderParameters();
    }

    public List<Parameter> findSwaggerParameter(String methodName) {
        for (Path path : this.swagger.getPaths().values()) {
            for (Operation operation : path.getOperations()) {
                if (!methodName.equals(operation.getOperationId())) continue;
                return operation.getParameters();
            }
        }
        throw new Error("method not found, name=" + methodName);
    }

    public void addDefaultTag(String tagName) {
        if (StringUtils.isEmpty((Object)tagName) || this.defaultTags.contains(tagName)) {
            return;
        }
        this.defaultTags.add(tagName);
    }

    public Set<String> getDefaultTags() {
        return this.defaultTags;
    }
}

