/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.support;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedDaemonThreadFactory
implements ThreadFactory {
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private final String prefix;
    private final boolean daemon;
    private final ClassLoader contextClassLoader;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    public NamedDaemonThreadFactory(String prefix) {
        this(prefix, new ClassLoader(Thread.currentThread().getContextClassLoader()){});
    }

    public NamedDaemonThreadFactory(String prefix, ClassLoader contextClassLoader) {
        this(prefix, contextClassLoader, null, true);
    }

    public NamedDaemonThreadFactory(String prefix, ClassLoader contextClassLoader, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, boolean daemon) {
        this.prefix = prefix;
        this.daemon = daemon;
        this.contextClassLoader = contextClassLoader;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread t = new Thread(runnable);
        t.setName(this.prefix + "-" + COUNTER.incrementAndGet());
        t.setDaemon(this.daemon);
        if (this.contextClassLoader != null) {
            t.setContextClassLoader(this.contextClassLoader);
        }
        if (null != this.uncaughtExceptionHandler) {
            t.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        }
        return t;
    }
}

