/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx.accesslog.element.impl;

import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import org.apache.servicecomb.transport.rest.vertx.accesslog.AccessLogParam;
import org.apache.servicecomb.transport.rest.vertx.accesslog.element.AccessLogItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpStatusItem
implements AccessLogItem<RoutingContext> {
    private static Logger LOGGER = LoggerFactory.getLogger(HttpStatusItem.class);
    public static final String EMPTY_RESULT = "-";

    @Override
    public String getFormattedItem(AccessLogParam<RoutingContext> accessLogParam) {
        HttpServerResponse response = accessLogParam.getContextData().response();
        if (null == response) {
            return EMPTY_RESULT;
        }
        if (response.closed() && !response.ended()) {
            LOGGER.warn("Response is closed before sending any data. Please check idle connection timeout for provider is properly configured.");
            return EMPTY_RESULT;
        }
        return String.valueOf(response.getStatusCode());
    }
}

