/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import com.alibaba.fastjson.JSON;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.net.SocketAddress;
import java.util.Map;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.metrics.PopMetricsManager;
import org.apache.rocketmq.broker.processor.PopMessageProcessor;
import org.apache.rocketmq.broker.processor.PopReviveService;
import org.apache.rocketmq.common.PopAckConstants;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.utils.DataConverter;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.body.BatchAck;
import org.apache.rocketmq.remoting.protocol.body.BatchAckMessageRequestBody;
import org.apache.rocketmq.remoting.protocol.header.AckMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ExtraInfoUtil;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.pop.AckMsg;
import org.apache.rocketmq.store.pop.BatchAckMsg;

public class AckMessageProcessor
implements NettyRequestProcessor {
    private static final Logger POP_LOGGER = LoggerFactory.getLogger((String)"RocketmqPop");
    private final BrokerController brokerController;
    private final String reviveTopic;
    private final PopReviveService[] popReviveServices;

    public AckMessageProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.reviveTopic = PopAckConstants.buildClusterReviveTopic((String)this.brokerController.getBrokerConfig().getBrokerClusterName());
        this.popReviveServices = new PopReviveService[this.brokerController.getBrokerConfig().getReviveQueueNum()];
        for (int i = 0; i < this.brokerController.getBrokerConfig().getReviveQueueNum(); ++i) {
            this.popReviveServices[i] = new PopReviveService(brokerController, this.reviveTopic, i);
            this.popReviveServices[i].setShouldRunPopRevive(brokerController.getBrokerConfig().getBrokerId() == 0L);
        }
    }

    public PopReviveService[] getPopReviveServices() {
        return this.popReviveServices;
    }

    public void startPopReviveService() {
        for (PopReviveService popReviveService : this.popReviveServices) {
            popReviveService.start();
        }
    }

    public void shutdownPopReviveService() {
        for (PopReviveService popReviveService : this.popReviveServices) {
            popReviveService.shutdown();
        }
    }

    public void setPopReviveServiceStatus(boolean shouldStart) {
        for (PopReviveService popReviveService : this.popReviveServices) {
            popReviveService.setShouldRunPopRevive(shouldStart);
        }
    }

    public boolean isPopReviveServiceRunning() {
        for (PopReviveService popReviveService : this.popReviveServices) {
            if (!popReviveService.isShouldRunPopRevive()) continue;
            return true;
        }
        return false;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        return this.processRequest(ctx.channel(), request, true);
    }

    public boolean rejectRequest() {
        return false;
    }

    private RemotingCommand processRequest(Channel channel, RemotingCommand request, boolean brokerAllowSuspend) throws RemotingCommandException {
        BatchAckMessageRequestBody reqBody = null;
        RemotingCommand response = RemotingCommand.createResponseCommand((int)0, null);
        response.setOpaque(request.getOpaque());
        if (request.getCode() == 200051) {
            AckMessageRequestHeader requestHeader = (AckMessageRequestHeader)request.decodeCommandCustomHeader(AckMessageRequestHeader.class);
            TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(requestHeader.getTopic());
            if (null == topicConfig) {
                POP_LOGGER.error("The topic {} not exist, consumer: {} ", (Object)requestHeader.getTopic(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)channel));
                response.setCode(17);
                response.setRemark(String.format("topic[%s] not exist, apply first please! %s", requestHeader.getTopic(), FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ")));
                return response;
            }
            if (requestHeader.getQueueId() >= topicConfig.getReadQueueNums() || requestHeader.getQueueId() < 0) {
                String errorInfo = String.format("queueId[%d] is illegal, topic:[%s] topicConfig.readQueueNums:[%d] consumer:[%s]", requestHeader.getQueueId(), requestHeader.getTopic(), topicConfig.getReadQueueNums(), channel.remoteAddress());
                POP_LOGGER.warn(errorInfo);
                response.setCode(13);
                response.setRemark(errorInfo);
                return response;
            }
            long minOffset = this.brokerController.getMessageStore().getMinOffsetInQueue(requestHeader.getTopic(), requestHeader.getQueueId().intValue());
            long maxOffset = this.brokerController.getMessageStore().getMaxOffsetInQueue(requestHeader.getTopic(), requestHeader.getQueueId().intValue());
            if (requestHeader.getOffset() < minOffset || requestHeader.getOffset() > maxOffset) {
                String errorInfo = String.format("offset is illegal, key:%s@%d, commit:%d, store:%d~%d", requestHeader.getTopic(), requestHeader.getQueueId(), requestHeader.getOffset(), minOffset, maxOffset);
                POP_LOGGER.warn(errorInfo);
                response.setCode(208);
                response.setRemark(errorInfo);
                return response;
            }
            this.appendAck(requestHeader, null, response, channel, null);
        } else if (request.getCode() == 200151) {
            if (request.getBody() != null) {
                reqBody = (BatchAckMessageRequestBody)BatchAckMessageRequestBody.decode((byte[])request.getBody(), BatchAckMessageRequestBody.class);
            }
            if (reqBody == null || reqBody.getAcks() == null || reqBody.getAcks().isEmpty()) {
                response.setCode(208);
                return response;
            }
            for (BatchAck bAck : reqBody.getAcks()) {
                this.appendAck(null, bAck, response, channel, reqBody.getBrokerName());
            }
        } else {
            POP_LOGGER.error("AckMessageProcessor failed to process RequestCode: {}, consumer: {} ", (Object)request.getCode(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)channel));
            response.setCode(13);
            response.setRemark(String.format("AckMessageProcessor failed to process RequestCode: %d", request.getCode()));
            return response;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendAck(AckMessageRequestHeader requestHeader, BatchAck batchAck, RemotingCommand response, Channel channel, String brokerName) {
        AckMsg ackMsg;
        long invisibleTime;
        long popTime;
        long ackOffset;
        long startOffset;
        int rqId;
        int qId;
        String topic;
        String consumeGroup;
        int ackCount = 0;
        if (batchAck == null) {
            String[] extraInfo = ExtraInfoUtil.split((String)requestHeader.getExtraInfo());
            brokerName = ExtraInfoUtil.getBrokerName((String[])extraInfo);
            consumeGroup = requestHeader.getConsumerGroup();
            topic = requestHeader.getTopic();
            qId = requestHeader.getQueueId();
            rqId = ExtraInfoUtil.getReviveQid((String[])extraInfo);
            startOffset = ExtraInfoUtil.getCkQueueOffset((String[])extraInfo);
            ackOffset = requestHeader.getOffset();
            popTime = ExtraInfoUtil.getPopTime((String[])extraInfo);
            invisibleTime = ExtraInfoUtil.getInvisibleTime((String[])extraInfo);
            if (rqId == 999) {
                String lockKey = topic + "@" + consumeGroup + "@" + qId;
                long oldOffset = this.brokerController.getConsumerOffsetManager().queryOffset(consumeGroup, topic, qId);
                if (ackOffset < oldOffset) {
                    return;
                }
                while (!this.brokerController.getPopMessageProcessor().getQueueLockManager().tryLock(lockKey)) {
                }
                try {
                    oldOffset = this.brokerController.getConsumerOffsetManager().queryOffset(consumeGroup, topic, qId);
                    if (ackOffset < oldOffset) {
                        return;
                    }
                    long nextOffset = this.brokerController.getConsumerOrderInfoManager().commitAndNext(topic, consumeGroup, qId, ackOffset, popTime);
                    if (nextOffset > -1L) {
                        if (!this.brokerController.getConsumerOffsetManager().hasOffsetReset(topic, consumeGroup, qId)) {
                            this.brokerController.getConsumerOffsetManager().commitOffset(channel.remoteAddress().toString(), consumeGroup, topic, qId, nextOffset);
                        }
                        if (!this.brokerController.getConsumerOrderInfoManager().checkBlock(null, topic, consumeGroup, qId, invisibleTime)) {
                            this.brokerController.getPopMessageProcessor().notifyMessageArriving(topic, consumeGroup, qId);
                        }
                    } else if (nextOffset == -1L) {
                        String errorInfo = String.format("offset is illegal, key:%s, old:%d, commit:%d, next:%d, %s", lockKey, oldOffset, ackOffset, nextOffset, channel.remoteAddress());
                        POP_LOGGER.warn(errorInfo);
                        response.setCode(13);
                        response.setRemark(errorInfo);
                        return;
                    }
                }
                finally {
                    this.brokerController.getPopMessageProcessor().getQueueLockManager().unLock(lockKey);
                }
                this.brokerController.getPopInflightMessageCounter().decrementInFlightMessageNum(topic, consumeGroup, popTime, qId, ackCount);
                return;
            }
            ackMsg = new AckMsg();
            ackCount = 1;
        } else {
            consumeGroup = batchAck.getConsumerGroup();
            topic = ExtraInfoUtil.getRealTopic((String)batchAck.getTopic(), (String)batchAck.getConsumerGroup(), (boolean)"1".equals(batchAck.getRetry()));
            qId = batchAck.getQueueId();
            rqId = batchAck.getReviveQueueId();
            startOffset = batchAck.getStartOffset();
            ackOffset = -1L;
            popTime = batchAck.getPopTime();
            invisibleTime = batchAck.getInvisibleTime();
            long minOffset = this.brokerController.getMessageStore().getMinOffsetInQueue(topic, qId);
            long maxOffset = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, qId);
            if (minOffset == -1L || maxOffset == -1L) {
                POP_LOGGER.error("Illegal topic or queue found when batch ack {}", (Object)batchAck);
                return;
            }
            BatchAckMsg batchAckMsg = new BatchAckMsg();
            for (int i = 0; batchAck.getBitSet() != null && i < batchAck.getBitSet().length(); ++i) {
                long offset;
                if (!batchAck.getBitSet().get(i) || (offset = startOffset + (long)i) < minOffset || offset > maxOffset) continue;
                batchAckMsg.getAckOffsetList().add(offset);
            }
            if (batchAckMsg.getAckOffsetList().isEmpty()) {
                return;
            }
            ackMsg = batchAckMsg;
            ackCount = batchAckMsg.getAckOffsetList().size();
        }
        this.brokerController.getBrokerStatsManager().incBrokerAckNums(ackCount);
        this.brokerController.getBrokerStatsManager().incGroupAckNums(consumeGroup, topic, ackCount);
        ackMsg.setConsumerGroup(consumeGroup);
        ackMsg.setTopic(topic);
        ackMsg.setQueueId(qId);
        ackMsg.setStartOffset(startOffset);
        ackMsg.setAckOffset(ackOffset);
        ackMsg.setPopTime(popTime);
        ackMsg.setBrokerName(brokerName);
        if (this.brokerController.getPopMessageProcessor().getPopBufferMergeService().addAk(rqId, ackMsg)) {
            this.brokerController.getPopInflightMessageCounter().decrementInFlightMessageNum(topic, consumeGroup, popTime, qId, ackCount);
            return;
        }
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        msgInner.setTopic(this.reviveTopic);
        msgInner.setBody(JSON.toJSONString((Object)ackMsg).getBytes(DataConverter.charset));
        msgInner.setQueueId(rqId);
        if (ackMsg instanceof BatchAckMsg) {
            msgInner.setTags("bAck");
            msgInner.getProperties().put("UNIQ_KEY", PopMessageProcessor.genBatchAckUniqueId((BatchAckMsg)ackMsg));
        } else {
            msgInner.setTags("ack");
            msgInner.getProperties().put("UNIQ_KEY", PopMessageProcessor.genAckUniqueId(ackMsg));
        }
        msgInner.setBornTimestamp(System.currentTimeMillis());
        msgInner.setBornHost((SocketAddress)this.brokerController.getStoreHost());
        msgInner.setStoreHost((SocketAddress)this.brokerController.getStoreHost());
        msgInner.setDeliverTimeMs(popTime + invisibleTime);
        msgInner.getProperties().put("UNIQ_KEY", PopMessageProcessor.genAckUniqueId(ackMsg));
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
        PutMessageResult putMessageResult = this.brokerController.getEscapeBridge().putMessageToSpecificQueue(msgInner);
        if (putMessageResult.getPutMessageStatus() != PutMessageStatus.PUT_OK && putMessageResult.getPutMessageStatus() != PutMessageStatus.FLUSH_DISK_TIMEOUT && putMessageResult.getPutMessageStatus() != PutMessageStatus.FLUSH_SLAVE_TIMEOUT && putMessageResult.getPutMessageStatus() != PutMessageStatus.SLAVE_NOT_AVAILABLE) {
            POP_LOGGER.error("put ack msg error:" + putMessageResult);
        }
        System.out.printf("put ack to store %s", ackMsg);
        PopMetricsManager.incPopReviveAckPutCount(ackMsg, putMessageResult.getPutMessageStatus());
        this.brokerController.getPopInflightMessageCounter().decrementInFlightMessageNum(topic, consumeGroup, popTime, qId, ackCount);
    }
}

