/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.ArrayList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicSortComparer;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.ma.arrays.ArraySort;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;

public class Sort_1
extends SystemFunction {
    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        ArrayList<ItemToBeSorted> inputList = this.getItemsToBeSorted(arguments[0]);
        StringCollator collation = context.getConfiguration().getCollation(this.getRetainedStaticContext().getDefaultCollationName());
        return this.doSort(inputList, collation, context);
    }

    protected ArrayList<ItemToBeSorted> getItemsToBeSorted(Sequence input) throws XPathException {
        Item item;
        ArrayList<ItemToBeSorted> inputList = new ArrayList<ItemToBeSorted>();
        int i = 0;
        SequenceIterator iterator = input.iterate();
        while ((item = iterator.next()) != null) {
            ItemToBeSorted member = new ItemToBeSorted();
            member.value = item;
            member.originalPosition = i++;
            member.sortKey = item.atomize();
            inputList.add(member);
        }
        return inputList;
    }

    protected Sequence doSort(ArrayList<ItemToBeSorted> inputList, StringCollator collation, XPathContext context) throws XPathException {
        AtomicComparer atomicComparer = AtomicSortComparer.makeSortComparer(collation, 632, context);
        try {
            inputList.sort((a, b) -> {
                int result = ArraySort.compareSortKeys(a.sortKey, b.sortKey, atomicComparer);
                if (result == 0) {
                    return a.originalPosition - b.originalPosition;
                }
                return result;
            });
        }
        catch (ClassCastException e) {
            throw new XPathException("Non-comparable types found while sorting: " + e.getMessage(), "XPTY0004").asTypeError();
        }
        ArrayList<Item> outputList = new ArrayList<Item>(inputList.size());
        for (ItemToBeSorted member : inputList) {
            outputList.add(member.value);
        }
        return new SequenceExtent.Of(outputList);
    }

    public static class ItemToBeSorted {
        public Item value;
        public GroundedValue sortKey;
        public int originalPosition;
    }
}

