/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// NLMVendorProprietaryMessage is the corresponding interface of NLMVendorProprietaryMessage
type NLMVendorProprietaryMessage interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	NLM
	// GetVendorId returns VendorId (property field)
	GetVendorId() BACnetVendorId
	// GetProprietaryMessage returns ProprietaryMessage (property field)
	GetProprietaryMessage() []byte
	// IsNLMVendorProprietaryMessage is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsNLMVendorProprietaryMessage()
	// CreateBuilder creates a NLMVendorProprietaryMessageBuilder
	CreateNLMVendorProprietaryMessageBuilder() NLMVendorProprietaryMessageBuilder
}

// _NLMVendorProprietaryMessage is the data-structure of this message
type _NLMVendorProprietaryMessage struct {
	NLMContract
	VendorId           BACnetVendorId
	ProprietaryMessage []byte
}

var _ NLMVendorProprietaryMessage = (*_NLMVendorProprietaryMessage)(nil)
var _ NLMRequirements = (*_NLMVendorProprietaryMessage)(nil)

// NewNLMVendorProprietaryMessage factory function for _NLMVendorProprietaryMessage
func NewNLMVendorProprietaryMessage(vendorId BACnetVendorId, proprietaryMessage []byte, apduLength uint16) *_NLMVendorProprietaryMessage {
	_result := &_NLMVendorProprietaryMessage{
		NLMContract:        NewNLM(apduLength),
		VendorId:           vendorId,
		ProprietaryMessage: proprietaryMessage,
	}
	_result.NLMContract.(*_NLM)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// NLMVendorProprietaryMessageBuilder is a builder for NLMVendorProprietaryMessage
type NLMVendorProprietaryMessageBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(vendorId BACnetVendorId, proprietaryMessage []byte) NLMVendorProprietaryMessageBuilder
	// WithVendorId adds VendorId (property field)
	WithVendorId(BACnetVendorId) NLMVendorProprietaryMessageBuilder
	// WithProprietaryMessage adds ProprietaryMessage (property field)
	WithProprietaryMessage(...byte) NLMVendorProprietaryMessageBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() NLMBuilder
	// Build builds the NLMVendorProprietaryMessage or returns an error if something is wrong
	Build() (NLMVendorProprietaryMessage, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() NLMVendorProprietaryMessage
}

// NewNLMVendorProprietaryMessageBuilder() creates a NLMVendorProprietaryMessageBuilder
func NewNLMVendorProprietaryMessageBuilder() NLMVendorProprietaryMessageBuilder {
	return &_NLMVendorProprietaryMessageBuilder{_NLMVendorProprietaryMessage: new(_NLMVendorProprietaryMessage)}
}

type _NLMVendorProprietaryMessageBuilder struct {
	*_NLMVendorProprietaryMessage

	parentBuilder *_NLMBuilder

	collectedErr []error
}

var _ (NLMVendorProprietaryMessageBuilder) = (*_NLMVendorProprietaryMessageBuilder)(nil)

func (b *_NLMVendorProprietaryMessageBuilder) setParent(contract NLMContract) {
	b.NLMContract = contract
	contract.(*_NLM)._SubType = b._NLMVendorProprietaryMessage
}

func (b *_NLMVendorProprietaryMessageBuilder) WithMandatoryFields(vendorId BACnetVendorId, proprietaryMessage []byte) NLMVendorProprietaryMessageBuilder {
	return b.WithVendorId(vendorId).WithProprietaryMessage(proprietaryMessage...)
}

func (b *_NLMVendorProprietaryMessageBuilder) WithVendorId(vendorId BACnetVendorId) NLMVendorProprietaryMessageBuilder {
	b.VendorId = vendorId
	return b
}

func (b *_NLMVendorProprietaryMessageBuilder) WithProprietaryMessage(proprietaryMessage ...byte) NLMVendorProprietaryMessageBuilder {
	b.ProprietaryMessage = proprietaryMessage
	return b
}

func (b *_NLMVendorProprietaryMessageBuilder) Build() (NLMVendorProprietaryMessage, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._NLMVendorProprietaryMessage.deepCopy(), nil
}

func (b *_NLMVendorProprietaryMessageBuilder) MustBuild() NLMVendorProprietaryMessage {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_NLMVendorProprietaryMessageBuilder) Done() NLMBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewNLMBuilder().(*_NLMBuilder)
	}
	return b.parentBuilder
}

func (b *_NLMVendorProprietaryMessageBuilder) buildForNLM() (NLM, error) {
	return b.Build()
}

func (b *_NLMVendorProprietaryMessageBuilder) DeepCopy() any {
	_copy := b.CreateNLMVendorProprietaryMessageBuilder().(*_NLMVendorProprietaryMessageBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateNLMVendorProprietaryMessageBuilder creates a NLMVendorProprietaryMessageBuilder
func (b *_NLMVendorProprietaryMessage) CreateNLMVendorProprietaryMessageBuilder() NLMVendorProprietaryMessageBuilder {
	if b == nil {
		return NewNLMVendorProprietaryMessageBuilder()
	}
	return &_NLMVendorProprietaryMessageBuilder{_NLMVendorProprietaryMessage: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_NLMVendorProprietaryMessage) GetMessageType() uint8 {
	return 0
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_NLMVendorProprietaryMessage) GetParent() NLMContract {
	return m.NLMContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_NLMVendorProprietaryMessage) GetVendorId() BACnetVendorId {
	return m.VendorId
}

func (m *_NLMVendorProprietaryMessage) GetProprietaryMessage() []byte {
	return m.ProprietaryMessage
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastNLMVendorProprietaryMessage(structType any) NLMVendorProprietaryMessage {
	if casted, ok := structType.(NLMVendorProprietaryMessage); ok {
		return casted
	}
	if casted, ok := structType.(*NLMVendorProprietaryMessage); ok {
		return *casted
	}
	return nil
}

func (m *_NLMVendorProprietaryMessage) GetTypeName() string {
	return "NLMVendorProprietaryMessage"
}

func (m *_NLMVendorProprietaryMessage) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.NLMContract.(*_NLM).getLengthInBits(ctx))

	// Simple field (vendorId)
	lengthInBits += 16

	// Array field
	if len(m.ProprietaryMessage) > 0 {
		lengthInBits += 8 * uint16(len(m.ProprietaryMessage))
	}

	return lengthInBits
}

func (m *_NLMVendorProprietaryMessage) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_NLMVendorProprietaryMessage) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_NLM, apduLength uint16) (__nLMVendorProprietaryMessage NLMVendorProprietaryMessage, err error) {
	m.NLMContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("NLMVendorProprietaryMessage"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for NLMVendorProprietaryMessage")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	vendorId, err := ReadEnumField[BACnetVendorId](ctx, "vendorId", "BACnetVendorId", ReadEnum(BACnetVendorIdByValue, ReadUnsignedShort(readBuffer, uint8(16))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'vendorId' field"))
	}
	m.VendorId = vendorId

	proprietaryMessage, err := readBuffer.ReadByteArray("proprietaryMessage", int(utils.InlineIf((bool((apduLength) > (0))), func() any { return int32((int32(apduLength) - int32(int32(3)))) }, func() any { return int32(int32(0)) }).(int32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'proprietaryMessage' field"))
	}
	m.ProprietaryMessage = proprietaryMessage

	if closeErr := readBuffer.CloseContext("NLMVendorProprietaryMessage"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for NLMVendorProprietaryMessage")
	}

	return m, nil
}

func (m *_NLMVendorProprietaryMessage) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_NLMVendorProprietaryMessage) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("NLMVendorProprietaryMessage"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for NLMVendorProprietaryMessage")
		}

		if err := WriteSimpleEnumField[BACnetVendorId](ctx, "vendorId", "BACnetVendorId", m.GetVendorId(), WriteEnum[BACnetVendorId, uint16](BACnetVendorId.GetValue, BACnetVendorId.PLC4XEnumName, WriteUnsignedShort(writeBuffer, 16))); err != nil {
			return errors.Wrap(err, "Error serializing 'vendorId' field")
		}

		if err := WriteByteArrayField(ctx, "proprietaryMessage", m.GetProprietaryMessage(), WriteByteArray(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'proprietaryMessage' field")
		}

		if popErr := writeBuffer.PopContext("NLMVendorProprietaryMessage"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for NLMVendorProprietaryMessage")
		}
		return nil
	}
	return m.NLMContract.(*_NLM).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_NLMVendorProprietaryMessage) IsNLMVendorProprietaryMessage() {}

func (m *_NLMVendorProprietaryMessage) DeepCopy() any {
	return m.deepCopy()
}

func (m *_NLMVendorProprietaryMessage) deepCopy() *_NLMVendorProprietaryMessage {
	if m == nil {
		return nil
	}
	_NLMVendorProprietaryMessageCopy := &_NLMVendorProprietaryMessage{
		m.NLMContract.(*_NLM).deepCopy(),
		m.VendorId,
		utils.DeepCopySlice[byte, byte](m.ProprietaryMessage),
	}
	_NLMVendorProprietaryMessageCopy.NLMContract.(*_NLM)._SubType = m
	return _NLMVendorProprietaryMessageCopy
}

func (m *_NLMVendorProprietaryMessage) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
