/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetProgramStateTagged is the corresponding interface of BACnetProgramStateTagged
type BACnetProgramStateTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetProgramState
	// IsBACnetProgramStateTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetProgramStateTagged()
	// CreateBuilder creates a BACnetProgramStateTaggedBuilder
	CreateBACnetProgramStateTaggedBuilder() BACnetProgramStateTaggedBuilder
}

// _BACnetProgramStateTagged is the data-structure of this message
type _BACnetProgramStateTagged struct {
	Header BACnetTagHeader
	Value  BACnetProgramState

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetProgramStateTagged = (*_BACnetProgramStateTagged)(nil)

// NewBACnetProgramStateTagged factory function for _BACnetProgramStateTagged
func NewBACnetProgramStateTagged(header BACnetTagHeader, value BACnetProgramState, tagNumber uint8, tagClass TagClass) *_BACnetProgramStateTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetProgramStateTagged must not be nil")
	}
	return &_BACnetProgramStateTagged{Header: header, Value: value, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetProgramStateTaggedBuilder is a builder for BACnetProgramStateTagged
type BACnetProgramStateTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetProgramState) BACnetProgramStateTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetProgramStateTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetProgramStateTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetProgramState) BACnetProgramStateTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetProgramStateTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetProgramStateTaggedBuilder
	// Build builds the BACnetProgramStateTagged or returns an error if something is wrong
	Build() (BACnetProgramStateTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetProgramStateTagged
}

// NewBACnetProgramStateTaggedBuilder() creates a BACnetProgramStateTaggedBuilder
func NewBACnetProgramStateTaggedBuilder() BACnetProgramStateTaggedBuilder {
	return &_BACnetProgramStateTaggedBuilder{_BACnetProgramStateTagged: new(_BACnetProgramStateTagged)}
}

type _BACnetProgramStateTaggedBuilder struct {
	*_BACnetProgramStateTagged

	collectedErr []error
}

var _ (BACnetProgramStateTaggedBuilder) = (*_BACnetProgramStateTaggedBuilder)(nil)

func (b *_BACnetProgramStateTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetProgramState) BACnetProgramStateTaggedBuilder {
	return b.WithHeader(header).WithValue(value)
}

func (b *_BACnetProgramStateTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetProgramStateTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetProgramStateTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetProgramStateTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetProgramStateTaggedBuilder) WithValue(value BACnetProgramState) BACnetProgramStateTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetProgramStateTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetProgramStateTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetProgramStateTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetProgramStateTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetProgramStateTaggedBuilder) Build() (BACnetProgramStateTagged, error) {
	if b.Header == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'header' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetProgramStateTagged.deepCopy(), nil
}

func (b *_BACnetProgramStateTaggedBuilder) MustBuild() BACnetProgramStateTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetProgramStateTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetProgramStateTaggedBuilder().(*_BACnetProgramStateTaggedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetProgramStateTaggedBuilder creates a BACnetProgramStateTaggedBuilder
func (b *_BACnetProgramStateTagged) CreateBACnetProgramStateTaggedBuilder() BACnetProgramStateTaggedBuilder {
	if b == nil {
		return NewBACnetProgramStateTaggedBuilder()
	}
	return &_BACnetProgramStateTaggedBuilder{_BACnetProgramStateTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetProgramStateTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetProgramStateTagged) GetValue() BACnetProgramState {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetProgramStateTagged(structType any) BACnetProgramStateTagged {
	if casted, ok := structType.(BACnetProgramStateTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetProgramStateTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetProgramStateTagged) GetTypeName() string {
	return "BACnetProgramStateTagged"
}

func (m *_BACnetProgramStateTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(int32(m.GetHeader().GetActualLength()) * int32(int32(8)))

	return lengthInBits
}

func (m *_BACnetProgramStateTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetProgramStateTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetProgramStateTagged, error) {
	return BACnetProgramStateTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetProgramStateTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetProgramStateTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetProgramStateTagged, error) {
		return BACnetProgramStateTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetProgramStateTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetProgramStateTagged, error) {
	v, err := (&_BACnetProgramStateTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetProgramStateTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetProgramStateTagged BACnetProgramStateTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetProgramStateTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetProgramStateTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetProgramState](ctx, "value", readBuffer, EnsureType[BACnetProgramState](ReadEnumGenericFailing(ctx, readBuffer, header.GetActualLength(), BACnetProgramState_IDLE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("BACnetProgramStateTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetProgramStateTagged")
	}

	return m, nil
}

func (m *_BACnetProgramStateTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetProgramStateTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetProgramStateTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetProgramStateTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetProgramState](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}

	if popErr := writeBuffer.PopContext("BACnetProgramStateTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetProgramStateTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetProgramStateTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetProgramStateTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetProgramStateTagged) IsBACnetProgramStateTagged() {}

func (m *_BACnetProgramStateTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetProgramStateTagged) deepCopy() *_BACnetProgramStateTagged {
	if m == nil {
		return nil
	}
	_BACnetProgramStateTaggedCopy := &_BACnetProgramStateTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetProgramStateTaggedCopy
}

func (m *_BACnetProgramStateTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
