/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataAuthenticationStatus is the corresponding interface of BACnetConstructedDataAuthenticationStatus
type BACnetConstructedDataAuthenticationStatus interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetAuthenticationStatus returns AuthenticationStatus (property field)
	GetAuthenticationStatus() BACnetAuthenticationStatusTagged
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetAuthenticationStatusTagged
	// IsBACnetConstructedDataAuthenticationStatus is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataAuthenticationStatus()
	// CreateBuilder creates a BACnetConstructedDataAuthenticationStatusBuilder
	CreateBACnetConstructedDataAuthenticationStatusBuilder() BACnetConstructedDataAuthenticationStatusBuilder
}

// _BACnetConstructedDataAuthenticationStatus is the data-structure of this message
type _BACnetConstructedDataAuthenticationStatus struct {
	BACnetConstructedDataContract
	AuthenticationStatus BACnetAuthenticationStatusTagged
}

var _ BACnetConstructedDataAuthenticationStatus = (*_BACnetConstructedDataAuthenticationStatus)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataAuthenticationStatus)(nil)

// NewBACnetConstructedDataAuthenticationStatus factory function for _BACnetConstructedDataAuthenticationStatus
func NewBACnetConstructedDataAuthenticationStatus(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, authenticationStatus BACnetAuthenticationStatusTagged, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataAuthenticationStatus {
	if authenticationStatus == nil {
		panic("authenticationStatus of type BACnetAuthenticationStatusTagged for BACnetConstructedDataAuthenticationStatus must not be nil")
	}
	_result := &_BACnetConstructedDataAuthenticationStatus{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		AuthenticationStatus:          authenticationStatus,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataAuthenticationStatusBuilder is a builder for BACnetConstructedDataAuthenticationStatus
type BACnetConstructedDataAuthenticationStatusBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(authenticationStatus BACnetAuthenticationStatusTagged) BACnetConstructedDataAuthenticationStatusBuilder
	// WithAuthenticationStatus adds AuthenticationStatus (property field)
	WithAuthenticationStatus(BACnetAuthenticationStatusTagged) BACnetConstructedDataAuthenticationStatusBuilder
	// WithAuthenticationStatusBuilder adds AuthenticationStatus (property field) which is build by the builder
	WithAuthenticationStatusBuilder(func(BACnetAuthenticationStatusTaggedBuilder) BACnetAuthenticationStatusTaggedBuilder) BACnetConstructedDataAuthenticationStatusBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataAuthenticationStatus or returns an error if something is wrong
	Build() (BACnetConstructedDataAuthenticationStatus, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataAuthenticationStatus
}

// NewBACnetConstructedDataAuthenticationStatusBuilder() creates a BACnetConstructedDataAuthenticationStatusBuilder
func NewBACnetConstructedDataAuthenticationStatusBuilder() BACnetConstructedDataAuthenticationStatusBuilder {
	return &_BACnetConstructedDataAuthenticationStatusBuilder{_BACnetConstructedDataAuthenticationStatus: new(_BACnetConstructedDataAuthenticationStatus)}
}

type _BACnetConstructedDataAuthenticationStatusBuilder struct {
	*_BACnetConstructedDataAuthenticationStatus

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataAuthenticationStatusBuilder) = (*_BACnetConstructedDataAuthenticationStatusBuilder)(nil)

func (b *_BACnetConstructedDataAuthenticationStatusBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataAuthenticationStatus
}

func (b *_BACnetConstructedDataAuthenticationStatusBuilder) WithMandatoryFields(authenticationStatus BACnetAuthenticationStatusTagged) BACnetConstructedDataAuthenticationStatusBuilder {
	return b.WithAuthenticationStatus(authenticationStatus)
}

func (b *_BACnetConstructedDataAuthenticationStatusBuilder) WithAuthenticationStatus(authenticationStatus BACnetAuthenticationStatusTagged) BACnetConstructedDataAuthenticationStatusBuilder {
	b.AuthenticationStatus = authenticationStatus
	return b
}

func (b *_BACnetConstructedDataAuthenticationStatusBuilder) WithAuthenticationStatusBuilder(builderSupplier func(BACnetAuthenticationStatusTaggedBuilder) BACnetAuthenticationStatusTaggedBuilder) BACnetConstructedDataAuthenticationStatusBuilder {
	builder := builderSupplier(b.AuthenticationStatus.CreateBACnetAuthenticationStatusTaggedBuilder())
	var err error
	b.AuthenticationStatus, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetAuthenticationStatusTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataAuthenticationStatusBuilder) Build() (BACnetConstructedDataAuthenticationStatus, error) {
	if b.AuthenticationStatus == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'authenticationStatus' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataAuthenticationStatus.deepCopy(), nil
}

func (b *_BACnetConstructedDataAuthenticationStatusBuilder) MustBuild() BACnetConstructedDataAuthenticationStatus {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataAuthenticationStatusBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataAuthenticationStatusBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataAuthenticationStatusBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataAuthenticationStatusBuilder().(*_BACnetConstructedDataAuthenticationStatusBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataAuthenticationStatusBuilder creates a BACnetConstructedDataAuthenticationStatusBuilder
func (b *_BACnetConstructedDataAuthenticationStatus) CreateBACnetConstructedDataAuthenticationStatusBuilder() BACnetConstructedDataAuthenticationStatusBuilder {
	if b == nil {
		return NewBACnetConstructedDataAuthenticationStatusBuilder()
	}
	return &_BACnetConstructedDataAuthenticationStatusBuilder{_BACnetConstructedDataAuthenticationStatus: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataAuthenticationStatus) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataAuthenticationStatus) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_AUTHENTICATION_STATUS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataAuthenticationStatus) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataAuthenticationStatus) GetAuthenticationStatus() BACnetAuthenticationStatusTagged {
	return m.AuthenticationStatus
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataAuthenticationStatus) GetActualValue() BACnetAuthenticationStatusTagged {
	ctx := context.Background()
	_ = ctx
	return CastBACnetAuthenticationStatusTagged(m.GetAuthenticationStatus())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataAuthenticationStatus(structType any) BACnetConstructedDataAuthenticationStatus {
	if casted, ok := structType.(BACnetConstructedDataAuthenticationStatus); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataAuthenticationStatus); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataAuthenticationStatus) GetTypeName() string {
	return "BACnetConstructedDataAuthenticationStatus"
}

func (m *_BACnetConstructedDataAuthenticationStatus) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (authenticationStatus)
	lengthInBits += m.AuthenticationStatus.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataAuthenticationStatus) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataAuthenticationStatus) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataAuthenticationStatus BACnetConstructedDataAuthenticationStatus, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataAuthenticationStatus"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataAuthenticationStatus")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	authenticationStatus, err := ReadSimpleField[BACnetAuthenticationStatusTagged](ctx, "authenticationStatus", ReadComplex[BACnetAuthenticationStatusTagged](BACnetAuthenticationStatusTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'authenticationStatus' field"))
	}
	m.AuthenticationStatus = authenticationStatus

	actualValue, err := ReadVirtualField[BACnetAuthenticationStatusTagged](ctx, "actualValue", (*BACnetAuthenticationStatusTagged)(nil), authenticationStatus)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataAuthenticationStatus"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataAuthenticationStatus")
	}

	return m, nil
}

func (m *_BACnetConstructedDataAuthenticationStatus) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataAuthenticationStatus) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataAuthenticationStatus"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataAuthenticationStatus")
		}

		if err := WriteSimpleField[BACnetAuthenticationStatusTagged](ctx, "authenticationStatus", m.GetAuthenticationStatus(), WriteComplex[BACnetAuthenticationStatusTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'authenticationStatus' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataAuthenticationStatus"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataAuthenticationStatus")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataAuthenticationStatus) IsBACnetConstructedDataAuthenticationStatus() {}

func (m *_BACnetConstructedDataAuthenticationStatus) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataAuthenticationStatus) deepCopy() *_BACnetConstructedDataAuthenticationStatus {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataAuthenticationStatusCopy := &_BACnetConstructedDataAuthenticationStatus{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetAuthenticationStatusTagged](m.AuthenticationStatus),
	}
	_BACnetConstructedDataAuthenticationStatusCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataAuthenticationStatusCopy
}

func (m *_BACnetConstructedDataAuthenticationStatus) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
