/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#include <stdio.h>
#include <plc4c/spi/context.h>
#include <plc4c/spi/evaluation_helper.h>
#include <plc4c/driver_s7_static.h>

#include "state.h"

// Code generated by code-generation. DO NOT EDIT.


// Parse function.
plc4c_return_code plc4c_s7_read_write_state_parse(plc4x_spi_context ctx, plc4c_spi_read_buffer* readBuffer, plc4c_s7_read_write_state** _message) {
  uint16_t startPos = plc4c_spi_read_get_pos(readBuffer);
  plc4c_return_code _res = OK;

  // Allocate enough memory to contain this data structure.
  (*_message) = malloc(sizeof(plc4c_s7_read_write_state));
  if(*_message == NULL) {
    return NO_MEMORY;
  }

  // Simple Field (SIG_8)
  bool SIG_8 = false;
  _res = plc4c_spi_read_bit(readBuffer, (bool*) &SIG_8);
  if(_res != OK) {
    return _res;
  }
  (*_message)->si_g_8 = SIG_8;

  // Simple Field (SIG_7)
  bool SIG_7 = false;
  _res = plc4c_spi_read_bit(readBuffer, (bool*) &SIG_7);
  if(_res != OK) {
    return _res;
  }
  (*_message)->si_g_7 = SIG_7;

  // Simple Field (SIG_6)
  bool SIG_6 = false;
  _res = plc4c_spi_read_bit(readBuffer, (bool*) &SIG_6);
  if(_res != OK) {
    return _res;
  }
  (*_message)->si_g_6 = SIG_6;

  // Simple Field (SIG_5)
  bool SIG_5 = false;
  _res = plc4c_spi_read_bit(readBuffer, (bool*) &SIG_5);
  if(_res != OK) {
    return _res;
  }
  (*_message)->si_g_5 = SIG_5;

  // Simple Field (SIG_4)
  bool SIG_4 = false;
  _res = plc4c_spi_read_bit(readBuffer, (bool*) &SIG_4);
  if(_res != OK) {
    return _res;
  }
  (*_message)->si_g_4 = SIG_4;

  // Simple Field (SIG_3)
  bool SIG_3 = false;
  _res = plc4c_spi_read_bit(readBuffer, (bool*) &SIG_3);
  if(_res != OK) {
    return _res;
  }
  (*_message)->si_g_3 = SIG_3;

  // Simple Field (SIG_2)
  bool SIG_2 = false;
  _res = plc4c_spi_read_bit(readBuffer, (bool*) &SIG_2);
  if(_res != OK) {
    return _res;
  }
  (*_message)->si_g_2 = SIG_2;

  // Simple Field (SIG_1)
  bool SIG_1 = false;
  _res = plc4c_spi_read_bit(readBuffer, (bool*) &SIG_1);
  if(_res != OK) {
    return _res;
  }
  (*_message)->si_g_1 = SIG_1;

  return OK;
}

plc4c_return_code plc4c_s7_read_write_state_serialize(plc4x_spi_context ctx, plc4c_spi_write_buffer* writeBuffer, plc4c_s7_read_write_state* _message) {
  plc4c_return_code _res = OK;

  // Simple Field (SIG_8)
  _res = plc4c_spi_write_bit(writeBuffer, _message->si_g_8);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (SIG_7)
  _res = plc4c_spi_write_bit(writeBuffer, _message->si_g_7);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (SIG_6)
  _res = plc4c_spi_write_bit(writeBuffer, _message->si_g_6);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (SIG_5)
  _res = plc4c_spi_write_bit(writeBuffer, _message->si_g_5);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (SIG_4)
  _res = plc4c_spi_write_bit(writeBuffer, _message->si_g_4);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (SIG_3)
  _res = plc4c_spi_write_bit(writeBuffer, _message->si_g_3);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (SIG_2)
  _res = plc4c_spi_write_bit(writeBuffer, _message->si_g_2);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (SIG_1)
  _res = plc4c_spi_write_bit(writeBuffer, _message->si_g_1);
  if(_res != OK) {
    return _res;
  }

  return OK;
}

uint16_t plc4c_s7_read_write_state_length_in_bytes(plc4x_spi_context ctx, plc4c_s7_read_write_state* _message) {
  return plc4c_s7_read_write_state_length_in_bits(ctx, _message) / 8;
}

uint16_t plc4c_s7_read_write_state_length_in_bits(plc4x_spi_context ctx, plc4c_s7_read_write_state* _message) {
  uint16_t lengthInBits = 0;

  // Simple field (SIG_8)
  lengthInBits += 1;

  // Simple field (SIG_7)
  lengthInBits += 1;

  // Simple field (SIG_6)
  lengthInBits += 1;

  // Simple field (SIG_5)
  lengthInBits += 1;

  // Simple field (SIG_4)
  lengthInBits += 1;

  // Simple field (SIG_3)
  lengthInBits += 1;

  // Simple field (SIG_2)
  lengthInBits += 1;

  // Simple field (SIG_1)
  lengthInBits += 1;

  return lengthInBits;
}

