/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.xobject;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.content.PreflightContentStream;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.utils.COSUtils;
import org.apache.pdfbox.preflight.utils.ContextHelper;
import org.apache.pdfbox.preflight.xobject.AbstractXObjValidator;

public class XObjFormValidator
extends AbstractXObjValidator {
    PDFormXObject pdXObj = null;

    public XObjFormValidator(PreflightContext context, PDFormXObject xobj) {
        super(context, xobj.getCOSObject());
        this.pdXObj = xobj;
    }

    @Override
    public void validate() throws ValidationException {
        super.validate();
        this.checkGroup();
        this.checkSubtype2Value();
        this.validateXObjectResources();
        this.validateXObjectContent();
    }

    @Override
    protected void checkMandatoryFields() {
        boolean pieceInfo;
        boolean lastMod = this.xobject.getItem(COSName.LAST_MODIFIED) != null;
        boolean bl = pieceInfo = this.xobject.getItem(COSName.PIECE_INFO) != null;
        if (lastMod ^ pieceInfo) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.1.7"));
            return;
        }
        COSBase bbBase = this.xobject.getItem(COSName.BBOX);
        if (bbBase == null || !COSUtils.isArray(bbBase, this.cosDocument)) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.1.1"));
            return;
        }
    }

    protected void validateXObjectContent() throws ValidationException {
        PreflightPath vPath = this.context.getValidationPath();
        PreflightContentStream csWrapper = new PreflightContentStream(this.context, vPath.getClosestPathElement(PDPage.class));
        csWrapper.validateXObjContentStream(this.pdXObj);
    }

    protected void checkGroup() {
        COSBase baseGroup = this.xobject.getItem("Group");
        COSDictionary groupDictionary = COSUtils.getAsDictionary(baseGroup, this.cosDocument);
        if (groupDictionary != null) {
            if (!"Group".equals(groupDictionary.getNameAsString(COSName.TYPE))) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.1.7", "The Group dictionary hasn't Group as Type value"));
            } else {
                String sVal = groupDictionary.getNameAsString(COSName.S);
                if (sVal == null || "Transparency".equals(sVal)) {
                    this.context.addValidationError(new ValidationResult.ValidationError("2.2.1", "Group has a transparency S entry or the S entry is null [" + this.xobject.toString() + "]"));
                    return;
                }
            }
        }
    }

    protected void checkPS() {
        if (this.xobject.getItem(COSName.getPDFName("PS")) != null) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.3", "Unexpected 'PS' Key"));
            return;
        }
    }

    protected void checkSubtype2Value() {
        if (this.xobject.getItem(COSName.getPDFName("Subtype2")) != null && "PS".equals(this.xobject.getNameAsString("Subtype2"))) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.3.2", "Unexpected 'PS' value for 'Subtype2' Key"));
            return;
        }
    }

    protected void validateXObjectResources() throws ValidationException {
        PDResources resources = this.pdXObj.getResources();
        if (resources != null) {
            ContextHelper.validateElement(this.context, resources, "resources-process");
        }
    }
}

