/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal.builder.multithreaded;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.BuildThreadFactory;
import org.apache.maven.lifecycle.internal.LifecycleModuleBuilder;
import org.apache.maven.lifecycle.internal.ProjectBuildList;
import org.apache.maven.lifecycle.internal.ProjectSegment;
import org.apache.maven.lifecycle.internal.ReactorBuildStatus;
import org.apache.maven.lifecycle.internal.ReactorContext;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.lifecycle.internal.builder.Builder;
import org.apache.maven.lifecycle.internal.builder.multithreaded.ConcurrencyDependencyGraph;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="multithreaded")
@Singleton
public class MultiThreadedBuilder
implements Builder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LifecycleModuleBuilder lifecycleModuleBuilder;

    @Inject
    public MultiThreadedBuilder(LifecycleModuleBuilder lifecycleModuleBuilder) {
        this.lifecycleModuleBuilder = lifecycleModuleBuilder;
    }

    @Override
    public void build(MavenSession session, ReactorContext reactorContext, ProjectBuildList projectBuilds, List<TaskSegment> taskSegments, ReactorBuildStatus reactorBuildStatus) throws ExecutionException, InterruptedException {
        int nThreads = Math.min(session.getRequest().getDegreeOfConcurrency(), session.getProjects().size());
        boolean parallel = nThreads > 1;
        session.setParallel(parallel);
        for (ProjectSegment segment : projectBuilds) {
            segment.getSession().setParallel(parallel);
        }
        ExecutorService executor = Executors.newFixedThreadPool(nThreads, new BuildThreadFactory());
        ExecutorCompletionService<ProjectSegment> service = new ExecutorCompletionService<ProjectSegment>(executor);
        for (TaskSegment taskSegment : taskSegments) {
            ProjectBuildList segmentProjectBuilds = projectBuilds.getByTaskSegment(taskSegment);
            Map<MavenProject, ProjectSegment> projectBuildMap = projectBuilds.selectSegment(taskSegment);
            try {
                ConcurrencyDependencyGraph analyzer = new ConcurrencyDependencyGraph(segmentProjectBuilds, session.getProjectDependencyGraph());
                this.multiThreadedProjectTaskSegmentBuild(analyzer, reactorContext, session, service, taskSegment, projectBuildMap);
                if (!reactorContext.getReactorBuildStatus().isHalted()) continue;
            }
            catch (Exception e) {
                session.getResult().addException(e);
            }
            break;
        }
        executor.shutdown();
        executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    private void multiThreadedProjectTaskSegmentBuild(ConcurrencyDependencyGraph analyzer, ReactorContext reactorContext, MavenSession rootSession, CompletionService<ProjectSegment> service, TaskSegment taskSegment, Map<MavenProject, ProjectSegment> projectBuildList) {
        Set<String> duplicateArtifactIds = projectBuildList.keySet().stream().map(MavenProject::getArtifactId).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(p -> (Long)p.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        for (MavenProject mavenProject : analyzer.getRootSchedulableBuilds()) {
            ProjectSegment projectSegment = projectBuildList.get(mavenProject);
            this.logger.debug("Scheduling: {}", (Object)projectSegment.getProject());
            Callable<ProjectSegment> cb = this.createBuildCallable(rootSession, projectSegment, reactorContext, taskSegment, duplicateArtifactIds);
            service.submit(cb);
        }
        for (int i = 0; i < analyzer.getNumberOfBuilds(); ++i) {
            try {
                ProjectSegment projectBuild = service.take().get();
                if (reactorContext.getReactorBuildStatus().isHalted()) break;
                if (analyzer.getNumberOfBuilds() <= 1) continue;
                List<MavenProject> newItemsThatCanBeBuilt = analyzer.markAsFinished(projectBuild.getProject());
                for (MavenProject mavenProject : newItemsThatCanBeBuilt) {
                    ProjectSegment scheduledDependent = projectBuildList.get(mavenProject);
                    this.logger.debug("Scheduling: {}", (Object)scheduledDependent);
                    Callable<ProjectSegment> cb = this.createBuildCallable(rootSession, scheduledDependent, reactorContext, taskSegment, duplicateArtifactIds);
                    service.submit(cb);
                }
                continue;
            }
            catch (InterruptedException e) {
                rootSession.getResult().addException(e);
                break;
            }
            catch (ExecutionException e) {
                rootSession.getResult().addException(e);
                break;
            }
        }
    }

    private Callable<ProjectSegment> createBuildCallable(MavenSession rootSession, ProjectSegment projectBuild, ReactorContext reactorContext, TaskSegment taskSegment, Set<String> duplicateArtifactIds) {
        return () -> {
            Thread currentThread = Thread.currentThread();
            String originalThreadName = currentThread.getName();
            MavenProject project = projectBuild.getProject();
            String threadNameSuffix = duplicateArtifactIds.contains(project.getArtifactId()) ? project.getGroupId() + ":" + project.getArtifactId() : project.getArtifactId();
            currentThread.setName("mvn-builder-" + threadNameSuffix);
            try {
                this.lifecycleModuleBuilder.buildProject(projectBuild.getSession(), rootSession, reactorContext, project, taskSegment);
                ProjectSegment projectSegment = projectBuild;
                return projectSegment;
            }
            finally {
                currentThread.setName(originalThreadName);
            }
        };
    }
}

