/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.maven.api.ProtoSession;
import org.apache.maven.api.cli.InvokerException;
import org.apache.maven.api.cli.InvokerRequest;
import org.apache.maven.api.cli.Logger;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.api.toolchain.PersistedToolchains;
import org.apache.maven.cling.invoker.CWD;
import org.apache.maven.cling.invoker.ContainerCapsule;
import org.apache.maven.cling.invoker.Utils;
import org.apache.maven.cling.logging.Slf4jConfiguration;
import org.apache.maven.eventspy.internal.EventSpyDispatcher;
import org.apache.maven.logging.BuildEventListener;
import org.jline.terminal.Terminal;
import org.slf4j.ILoggerFactory;

public class LookupContext
implements AutoCloseable {
    public final InvokerRequest invokerRequest;
    public final CWD cwd;
    public final Path installationDirectory;
    public final Path userDirectory;
    public final boolean containerCapsuleManaged;
    public Logger logger;
    public ProtoSession protoSession;
    public Set<String> pushedUserProperties;
    public ILoggerFactory loggerFactory;
    public Slf4jConfiguration slf4jConfiguration;
    public Slf4jConfiguration.Level loggerLevel;
    public Boolean coloredOutput;
    public Terminal terminal;
    public Consumer<String> writer;
    public ContainerCapsule containerCapsule;
    public Lookup lookup;
    public EventSpyDispatcher eventSpyDispatcher;
    public BuildEventListener buildEventListener;
    public Path installationSettingsPath;
    public Path projectSettingsPath;
    public Path userSettingsPath;
    public boolean interactive;
    public Path localRepositoryPath;
    public Settings effectiveSettings;
    public PersistedToolchains effectiveToolchains;
    public final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();

    public LookupContext(InvokerRequest invokerRequest) {
        this(invokerRequest, true);
    }

    public LookupContext(InvokerRequest invokerRequest, boolean containerCapsuleManaged) {
        this.invokerRequest = Objects.requireNonNull(invokerRequest);
        this.cwd = CWD.create(invokerRequest.cwd());
        this.installationDirectory = Utils.getCanonicalPath(invokerRequest.installationDirectory());
        this.userDirectory = Utils.getCanonicalPath(invokerRequest.userHomeDirectory());
        this.containerCapsuleManaged = containerCapsuleManaged;
        this.logger = invokerRequest.parserRequest().logger();
        HashMap<String, String> user = new HashMap<String, String>(invokerRequest.userProperties());
        user.put("session.topDirectory", invokerRequest.topDirectory().toString());
        if (invokerRequest.rootDirectory().isPresent()) {
            user.put("session.rootDirectory", ((Path)invokerRequest.rootDirectory().get()).toString());
        }
        this.protoSession = ProtoSession.newBuilder().withSystemProperties(invokerRequest.systemProperties()).withUserProperties(user).withTopDirectory(invokerRequest.topDirectory()).withRootDirectory((Path)invokerRequest.rootDirectory().orElse(null)).build();
    }

    @Override
    public void close() throws InvokerException {
        ArrayList<Exception> causes = null;
        ArrayList<AutoCloseable> cs = new ArrayList<AutoCloseable>(this.closeables);
        Collections.reverse(cs);
        for (AutoCloseable c : cs) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Exception e) {
                if (causes == null) {
                    causes = new ArrayList<Exception>();
                }
                causes.add(e);
            }
        }
        if (causes != null) {
            InvokerException exception = new InvokerException("Unable to close context");
            causes.forEach(arg_0 -> exception.addSuppressed(arg_0));
            throw exception;
        }
    }

    public final void closeContainer() throws Exception {
        if (this.containerCapsuleManaged) {
            this.doCloseContainer();
        }
    }

    public void doCloseContainer() throws Exception {
        if (this.containerCapsule != null) {
            try {
                this.containerCapsule.close();
            }
            finally {
                this.eventSpyDispatcher = null;
                this.lookup = null;
                this.containerCapsule = null;
            }
        }
    }
}

