/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler;

import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.core.interfaces.UTF8Stdout;
import org.apache.manifoldcf.crawler.interfaces.BucketDescription;
import org.apache.manifoldcf.crawler.interfaces.FilterCriteria;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.RegExpCriteria;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.SortOrder;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class RunMaxActivityHistory {
    public static final String _rcsid = "@(#)$Id: RunMaxActivityHistory.java 988245 2010-08-23 18:39:35Z kwright $";

    private RunMaxActivityHistory() {
    }

    public static void main(String[] args) {
        if (args.length != 11) {
            System.err.println("Usage: RunMaxActivityHistory <connection_name> <activity_list> <start_time> <end_time> <entity_regexp> <resultcode_regexp> <sortorder_list> <id_bucket_regexp> <interval_ms> <start_row> <row_count>");
            System.err.println("<connection_name> is the name of the repository connection");
            System.err.println("<activity_list> is the comma-separated list of activity names to include");
            System.err.println("<start_time> is the earliest time to include, in ms. since epoch [blank if no limit]");
            System.err.println("<end_time> is the latest time to include, in ms. since epoch [blank if no limit]");
            System.err.println("<entity_regexp> describes which document identifiers to include");
            System.err.println("<resultcode_regexp> describes which result codes to include");
            System.err.println("<sortorder_list> a comma-separated list of fields describing the sort order, preceded by + or -");
            System.err.println("    for ascending or descending; the legal field names are: 'idbucket', 'starttime', 'endtime', 'activitycount'");
            System.err.println("<id_bucket_regexp> is a regular expression which extracts the bucket part from a document identifier");
            System.err.println("<interval_ms> is the measurement interval in milliseconds");
            System.err.println("<start_row> describes which row to start at, beginning at 0");
            System.err.println("<row_count> indicates the maximum number of rows to include");
            System.err.println("");
            System.err.println("The result will be UTF-8 encoded, and will be printed to standard out, and will contain the following columns:");
            System.err.println("    identifier_bucket, starttime_ms, endtime_ms, activity_count");
            System.exit(1);
        }
        String connectionName = args[0];
        String activityList = args[1];
        String startTime = args[2];
        String endTime = args[3];
        String entityRegexp = args[4];
        String resultCodeRegexp = args[5];
        String sortOrder = args[6];
        String entityBucketRegexp = args[7];
        String interval = args[8];
        String startRow = args[9];
        String rowCount = args[10];
        try {
            IThreadContext tc = ThreadContextFactory.make();
            ManifoldCF.initializeEnvironment(tc);
            IRepositoryConnectionManager connManager = RepositoryConnectionManagerFactory.make(tc);
            FilterCriteria filter = RunMaxActivityHistory.parseFilterCriteria(activityList, startTime, endTime, entityRegexp, resultCodeRegexp);
            SortOrder sortOrderValue = RunMaxActivityHistory.parseSortorder(sortOrder);
            BucketDescription entityBucket = RunMaxActivityHistory.parseBucketDescription(entityBucketRegexp);
            long intervalValue = new Long(interval);
            int startRowValue = Integer.parseInt(startRow);
            int rowCountValue = Integer.parseInt(rowCount);
            IResultSet result = connManager.genHistoryActivityCount(connectionName, filter, sortOrderValue, entityBucket, intervalValue, startRowValue, rowCountValue);
            int i = 0;
            while (i < result.getRowCount()) {
                IResultRow row = result.getRow(i++);
                UTF8Stdout.println((Object)(RunMaxActivityHistory.commaEscape((String)row.getValue("idbucket")) + "," + row.getValue("starttime").toString() + "," + row.getValue("endtime").toString() + "," + row.getValue("activitycount").toString()));
            }
            System.err.println("History query done");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    protected static String commaEscape(String input) {
        StringBuilder output = new StringBuilder();
        int i = 0;
        while (i < input.length()) {
            char x;
            if ((x = input.charAt(i++)) < ' ') {
                x = ' ';
            }
            if (x == '\\' || x == ',') {
                output.append("\\");
            }
            output.append(x);
        }
        return output.toString();
    }

    protected static FilterCriteria parseFilterCriteria(String activityList, String startTime, String endTime, String entityRegexp, String resultCodeRegexp) throws Exception {
        String[] activityTypes = RunMaxActivityHistory.parseActivityList(activityList);
        Long startTimeValue = startTime != null && startTime.length() > 0 ? new Long(startTime) : null;
        Long endTimeValue = endTime != null && endTime.length() > 0 ? new Long(endTime) : null;
        RegExpCriteria entityRegexpValue = RunMaxActivityHistory.parseRegexp(entityRegexp);
        RegExpCriteria resultCodeRegexpValue = RunMaxActivityHistory.parseRegexp(resultCodeRegexp);
        return new FilterCriteria(activityTypes, startTimeValue, endTimeValue, entityRegexpValue, resultCodeRegexpValue);
    }

    protected static String[] parseActivityList(String activityList) throws Exception {
        String[] activities = activityList.split(",");
        String[] rval = new String[activities.length];
        for (int i = 0; i < rval.length; ++i) {
            String activity;
            rval[i] = activity = activities[i].trim();
        }
        return rval;
    }

    protected static RegExpCriteria parseRegexp(String regexp) throws Exception {
        if (regexp == null || regexp.length() == 0) {
            return null;
        }
        return new RegExpCriteria(regexp, true);
    }

    protected static BucketDescription parseBucketDescription(String bucketDesc) throws Exception {
        return new BucketDescription(bucketDesc, false);
    }

    protected static SortOrder parseSortorder(String sortorder) throws Exception {
        SortOrder so = new SortOrder();
        if (sortorder == null || sortorder.length() == 0) {
            return so;
        }
        String[] columns = sortorder.split(",");
        int i = 0;
        while (i < columns.length) {
            String column = columns[i++].trim();
            int clickCount = 1;
            if (column.startsWith("+")) {
                column = column.substring(1);
            } else if (column.startsWith("-")) {
                ++clickCount;
                column = column.substring(1);
            }
            while (clickCount > 0) {
                --clickCount;
                so.clickColumn(column);
            }
        }
        return so;
    }
}

