/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.rss;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.connectorcommon.fuzzyml.CharacterReceiver;
import org.apache.manifoldcf.connectorcommon.fuzzyml.Parser;
import org.apache.manifoldcf.connectorcommon.fuzzyml.XMLFileParsingContext;
import org.apache.manifoldcf.connectorcommon.fuzzyml.XMLFuzzyHierarchicalParseState;
import org.apache.manifoldcf.connectorcommon.fuzzyml.XMLParsingContext;
import org.apache.manifoldcf.connectorcommon.fuzzyml.XMLStringParsingContext;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.connectorcommon.interfaces.IThrottleGroups;
import org.apache.manifoldcf.connectorcommon.interfaces.IThrottleSpec;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.connectorcommon.interfaces.ThrottleGroupsFactory;
import org.apache.manifoldcf.core.common.DateParser;
import org.apache.manifoldcf.core.interfaces.CharacterInput;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.NullCharacterInput;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.interfaces.TempFileCharacterInput;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.rss.DataCache;
import org.apache.manifoldcf.crawler.connectors.rss.Messages;
import org.apache.manifoldcf.crawler.connectors.rss.Robots;
import org.apache.manifoldcf.crawler.connectors.rss.ThrottledFetcher;
import org.apache.manifoldcf.crawler.connectors.rss.WebURL;
import org.apache.manifoldcf.crawler.interfaces.IAbortActivity;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.ui.util.Encoder;

public class RSSConnector
extends BaseRepositoryConnector {
    public static final String _rcsid = "@(#)$Id: RSSConnector.java 994959 2010-09-08 10:04:42Z kwright $";
    protected static final String rssThrottleGroupType = "_RSS_";
    protected static final int ROBOTS_NONE = 0;
    protected static final int ROBOTS_DATA = 1;
    protected static final int ROBOTS_ALL = 2;
    public static final int DECHROMED_NONE = 0;
    public static final int DECHROMED_DESCRIPTION = 1;
    public static final int DECHROMED_CONTENT = 2;
    public static final int CHROMED_USE = 0;
    public static final int CHROMED_SKIP = 1;
    public static final int CHROMED_METADATA_ONLY = 2;
    protected int robotsUsage = 2;
    protected String userAgent = null;
    protected String from = null;
    protected long minimumMillisecondsPerFetchPerServer = -1L;
    protected int maxOpenConnectionsPerServer = 0;
    protected double minimumMillisecondsPerBytePerServer = 0.0;
    protected String throttleGroupName = null;
    protected String proxyHost = null;
    protected int proxyPort = -1;
    protected String proxyAuthDomain = null;
    protected String proxyAuthUsername = null;
    protected String proxyAuthPassword = null;
    protected ThrottledFetcher fetcher = null;
    protected Robots robots = null;
    protected static Map<String, ThrottledFetcher> fetcherMap = new HashMap<String, ThrottledFetcher>();
    protected static Map robotsMap = new HashMap();
    protected boolean isInitialized = false;
    protected static DataCache cache = new DataCache();
    protected static final Map understoodProtocols = new HashMap();
    public static final String ACTIVITY_FETCH = "fetch";
    public static final String ACTIVITY_ROBOTSPARSE = "robots parse";
    public static final String ACTIVITY_PROCESS = "process";
    private static final String defaultAuthorityDenyToken = "DEAD_AUTHORITY";
    protected static Set<String> xmlContentTypes;

    protected void getSession() throws ManifoldCFException {
        if (!this.isInitialized) {
            String emailAddress = this.params.getParameter("Email address");
            if (emailAddress == null) {
                throw new ManifoldCFException("Missing email address");
            }
            this.userAgent = "Mozilla/5.0 (ApacheManifoldCFRSSFeedReader; " + (emailAddress == null ? "" : emailAddress) + ")";
            this.from = emailAddress;
            String robotsUsageString = this.params.getParameter("Robots usage");
            this.robotsUsage = 2;
            if (robotsUsageString == null || robotsUsageString.length() == 0 || robotsUsageString.equals("all")) {
                this.robotsUsage = 2;
            } else if (robotsUsageString.equals("none")) {
                this.robotsUsage = 0;
            } else if (robotsUsageString.equals("data")) {
                this.robotsUsage = 1;
            }
            this.proxyHost = this.params.getParameter("Proxy host");
            String proxyPortString = this.params.getParameter("Proxy port");
            this.proxyAuthDomain = this.params.getParameter("Proxy authentication domain");
            this.proxyAuthUsername = this.params.getParameter("Proxy authentication user name");
            this.proxyAuthPassword = this.params.getObfuscatedParameter("Proxy authentication password");
            this.proxyPort = -1;
            if (proxyPortString != null && proxyPortString.length() > 0) {
                try {
                    this.proxyPort = Integer.parseInt(proxyPortString);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException(e.getMessage(), (Throwable)e);
                }
            }
            this.minimumMillisecondsPerBytePerServer = 0.0;
            this.maxOpenConnectionsPerServer = 10;
            this.minimumMillisecondsPerFetchPerServer = 0L;
            String x = this.params.getParameter("KB per second");
            if (x != null && x.length() > 0) {
                try {
                    int maxKBytesPerSecondPerServer = Integer.parseInt(x);
                    if (maxKBytesPerSecondPerServer > 0) {
                        this.minimumMillisecondsPerBytePerServer = 1.0 / (double)maxKBytesPerSecondPerServer;
                    }
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                }
            }
            if ((x = this.params.getParameter("Max server connections")) != null && x.length() > 0) {
                try {
                    this.maxOpenConnectionsPerServer = Integer.parseInt(x);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                }
            }
            if ((x = this.params.getParameter("Max fetches per minute")) != null && x.length() > 0) {
                try {
                    int maxFetches = Integer.parseInt(x);
                    if (maxFetches == 0) {
                        maxFetches = 1;
                    }
                    this.minimumMillisecondsPerFetchPerServer = 60000L / (long)maxFetches;
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                }
            }
            IThrottleGroups tg = ThrottleGroupsFactory.make((IThreadContext)this.currentContext);
            tg.createOrUpdateThrottleGroup(rssThrottleGroupType, this.throttleGroupName, (IThrottleSpec)new ThrottleSpec(this.maxOpenConnectionsPerServer, this.minimumMillisecondsPerFetchPerServer, this.minimumMillisecondsPerBytePerServer));
            this.isInitialized = true;
        }
    }

    public String[] getActivitiesList() {
        return new String[]{ACTIVITY_FETCH, ACTIVITY_ROBOTSPARSE, ACTIVITY_PROCESS};
    }

    public int getConnectorModel() {
        return 0;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.throttleGroupName = this.params.getParameter("Throttle group");
        if (this.throttleGroupName == null) {
            this.throttleGroupName = "";
        }
        this.fetcher = this.getFetcher();
        this.robots = this.getRobots(this.fetcher);
        this.fetcher.noteConnectionEstablished();
        this.robots.noteConnectionEstablished();
    }

    public void poll() throws ManifoldCFException {
        this.fetcher.poll();
        this.robots.poll();
    }

    public String check() throws ManifoldCFException {
        this.getSession();
        return super.check();
    }

    public void disconnect() throws ManifoldCFException {
        this.isInitialized = false;
        this.robots.noteConnectionReleased();
        this.fetcher.noteConnectionReleased();
        this.userAgent = null;
        this.from = null;
        this.minimumMillisecondsPerFetchPerServer = -1L;
        this.maxOpenConnectionsPerServer = 0;
        this.minimumMillisecondsPerBytePerServer = 0.0;
        this.throttleGroupName = null;
        this.proxyHost = null;
        this.proxyPort = -1;
        this.proxyAuthDomain = null;
        this.proxyAuthUsername = null;
        this.proxyAuthPassword = null;
        super.disconnect();
    }

    public String[] getBinNames(String documentIdentifier) {
        try {
            WebURL uri = new WebURL(documentIdentifier);
            return new String[]{uri.getHost()};
        }
        catch (URISyntaxException e) {
            return new String[]{""};
        }
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        Filter f = new Filter(spec, true);
        Iterator<String> iter = f.getSeeds();
        while (iter.hasNext()) {
            String canonicalURL = iter.next();
            activities.addSeedDocument(canonicalURL);
        }
        return "";
    }

    protected static String makeDocumentIdentifier(CanonicalizationPolicies policies, String parentIdentifier, String rawURL) throws ManifoldCFException {
        try {
            WebURL url;
            CanonicalizationPolicy p = policies.findMatch(rawURL);
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < rawURL.length()) {
                char x;
                if ((x = rawURL.charAt(i++)) < ' ' || x >= '\u0080') continue;
                sb.append(x);
            }
            rawURL = sb.toString();
            if (parentIdentifier != null) {
                WebURL parentURL = new WebURL(parentIdentifier);
                url = parentURL.resolve(rawURL);
            } else {
                url = new WebURL(rawURL);
            }
            String protocol = url.getScheme();
            String host = url.getHost();
            if (protocol == null || host == null) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("RSS: Can't use url '" + rawURL + "' because it has no protocol or host"));
                }
                return null;
            }
            if (understoodProtocols.get(protocol) == null) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("RSS: Can't use url '" + rawURL + "' because it has an unsupported protocol '" + protocol + "'"));
                }
                return null;
            }
            String id = RSSConnector.doCanonicalization(p, url);
            if (id == null) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("RSS: Can't use url '" + rawURL + "' because it could not be canonicalized"));
                }
                return null;
            }
            i = 0;
            while (i < id.length()) {
                char x;
                if ((x = id.charAt(i++)) >= ' ' && x <= '\u007f') continue;
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("RSS: Can't use url '" + rawURL + "' because it has illegal characters in it"));
                }
                return null;
            }
            return id;
        }
        catch (URISyntaxException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("RSS: Can't use url '" + rawURL + "' because it is badly formed: " + e.getMessage()));
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("RSS: Can't use url '" + rawURL + "' because there was an argument error: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
        catch (NullPointerException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("RSS: Can't use url '" + rawURL + "' because it is missing fields: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    protected static String doCanonicalization(CanonicalizationPolicy p, WebURL url) throws ManifoldCFException, URISyntaxException {
        String pathString;
        int index;
        String queryString = url.getRawQuery();
        if (queryString != null) {
            if (p == null || p.canReorder()) {
                HashMap<String, ArrayList<String>> argumentMap = new HashMap<String, ArrayList<String>>();
                index = 0;
                while (index < queryString.length()) {
                    String argument;
                    int valueIndex;
                    int newIndex = queryString.indexOf("&", index);
                    if (newIndex == -1) {
                        newIndex = queryString.length();
                    }
                    String key = (valueIndex = (argument = queryString.substring(index, newIndex)).indexOf("=")) == -1 ? argument : argument.substring(0, valueIndex);
                    boolean includeArgument = true;
                    if ((p == null || p.canRemovePhpSession()) && key.equals("PHPSESSID")) {
                        includeArgument = false;
                    }
                    if ((p == null || p.canRemoveBvSession()) && key.indexOf("BVSession@@@@") != -1) {
                        includeArgument = false;
                    }
                    if (includeArgument) {
                        ArrayList<String> list = (ArrayList<String>)argumentMap.get(key);
                        if (list == null) {
                            list = new ArrayList<String>();
                            argumentMap.put(key, list);
                        }
                        list.add(argument);
                    }
                    if (newIndex < queryString.length()) {
                        index = newIndex + 1;
                        continue;
                    }
                    index = newIndex;
                }
                Object[] sortArray = new String[argumentMap.size()];
                int i = 0;
                Iterator iter = argumentMap.keySet().iterator();
                while (iter.hasNext()) {
                    sortArray[i++] = (String)iter.next();
                }
                Arrays.sort(sortArray);
                StringBuilder newString = new StringBuilder();
                boolean isFirst = true;
                i = 0;
                while (i < sortArray.length) {
                    Object key = sortArray[i++];
                    ArrayList list = (ArrayList)argumentMap.get(key);
                    int j = 0;
                    while (j < list.size()) {
                        if (!isFirst) {
                            newString.append("&");
                        } else {
                            isFirst = false;
                        }
                        newString.append((String)list.get(j++));
                    }
                }
                queryString = newString.toString();
            } else {
                StringBuilder newString = new StringBuilder();
                index = 0;
                boolean isFirst = true;
                while (index < queryString.length()) {
                    String argument;
                    int valueIndex;
                    int newIndex = queryString.indexOf("&", index);
                    if (newIndex == -1) {
                        newIndex = queryString.length();
                    }
                    String key = (valueIndex = (argument = queryString.substring(index, newIndex)).indexOf("=")) == -1 ? argument : argument.substring(0, valueIndex);
                    boolean includeArgument = true;
                    if ((p == null || p.canRemovePhpSession()) && key.equals("PHPSESSID")) {
                        includeArgument = false;
                    }
                    if ((p == null || p.canRemoveBvSession()) && key.indexOf("BVSession@@@@") != -1) {
                        includeArgument = false;
                    }
                    if (includeArgument) {
                        if (!isFirst) {
                            newString.append("&");
                        } else {
                            isFirst = false;
                        }
                        newString.append(argument);
                    }
                    if (newIndex < queryString.length()) {
                        index = newIndex + 1;
                        continue;
                    }
                    index = newIndex;
                }
                queryString = newString.toString();
            }
        }
        if ((pathString = url.getPath()) != null) {
            index = pathString.indexOf(";jsessionid=");
            if ((p == null || p.canRemoveJavaSession()) && index != -1) {
                pathString = pathString.substring(0, index);
            }
            if ((p == null || p.canRemoveAspSession()) && pathString.startsWith("/s(") && (index = pathString.indexOf(")")) != -1) {
                pathString = pathString.substring(index + 1);
            }
        }
        url = new WebURL(url.getScheme(), url.getHost(), url.getPort(), pathString, queryString);
        String rval = url.toASCIIString();
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        connectionLimit = 200;
        fixedList = new String[2];
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("RSS: In getDocumentVersions for " + Integer.toString(documentIdentifiers.length) + " documents"));
        }
        f = new Filter(spec, false);
        acls = f.getAcls();
        Arrays.sort(acls);
        feedTimeout = f.getFeedTimeoutValue();
        var12_12 = documentIdentifiers;
        var13_13 = var12_12.length;
        var14_14 = 0;
        while (var14_14 < var13_13) {
            block127: {
                block133: {
                    block131: {
                        block130: {
                            block129: {
                                urlValue = documentIdentifier = var12_12[var14_14];
                                if (Logging.connectors.isDebugEnabled()) {
                                    Logging.connectors.debug((Object)("RSS: Getting version string for '" + urlValue + "'"));
                                }
                                ingestURL = null;
                                pubDates = null;
                                sources = null;
                                titles = null;
                                authorNames = null;
                                authorEmails = null;
                                categories = null;
                                descriptions = null;
                                dechromedData = activities.retrieveParentDataAsFiles(urlValue, "data");
                                if (dechromedData.length > 0) {
                                    ingestURL = f.mapDocumentURL(urlValue);
                                    if (ingestURL != null) {
                                        try {
                                            is = dechromedData[0].getUtf8Stream();
                                            try {
                                                sb = new StringBuilder();
                                                checkSum = RSSConnector.cache.addData(activities, urlValue, "text/html", is);
                                                pubDates = activities.retrieveParentData(urlValue, "pubdate");
                                                sources = activities.retrieveParentData(urlValue, "source");
                                                titles = activities.retrieveParentData(urlValue, "title");
                                                authorNames = activities.retrieveParentData(urlValue, "authorname");
                                                authorEmails = activities.retrieveParentData(urlValue, "authoremail");
                                                categories = activities.retrieveParentData(urlValue, "category");
                                                descriptions = activities.retrieveParentData(urlValue, "description");
                                                Arrays.sort(pubDates);
                                                Arrays.sort(sources);
                                                Arrays.sort(titles);
                                                Arrays.sort(authorNames);
                                                Arrays.sort(authorEmails);
                                                Arrays.sort(categories);
                                                Arrays.sort(descriptions);
                                                if (sources.length == 0 && Logging.connectors.isDebugEnabled()) {
                                                    Logging.connectors.debug((Object)("RSS: Warning; URL '" + ingestURL + "' doesn't seem to have any RSS feed source!"));
                                                }
                                                sb.append('+');
                                                RSSConnector.packList((StringBuilder)sb, (String[])acls, (char)'+');
                                                if (acls.length > 0) {
                                                    sb.append('+');
                                                    RSSConnector.pack((StringBuilder)sb, (String)"DEAD_AUTHORITY", (char)'+');
                                                } else {
                                                    sb.append('-');
                                                }
                                                RSSConnector.pack((StringBuilder)sb, (String)ingestURL, (char)'+');
                                                RSSConnector.packList((StringBuilder)sb, (String[])pubDates, (char)'+');
                                                RSSConnector.packList((StringBuilder)sb, (String[])titles, (char)'+');
                                                RSSConnector.packList((StringBuilder)sb, (String[])sources, (char)'+');
                                                RSSConnector.packList((StringBuilder)sb, (String[])categories, (char)'+');
                                                RSSConnector.packList((StringBuilder)sb, (String[])descriptions, (char)'+');
                                                RSSConnector.packList((StringBuilder)sb, (String[])authorNames, (char)'+');
                                                RSSConnector.packList((StringBuilder)sb, (String[])authorEmails, (char)'+');
                                                sb.append(new Long(checkSum).toString());
                                                versionString = sb.toString();
                                            }
                                            finally {
                                                is.close();
                                            }
                                        }
                                        catch (SocketTimeoutException e) {
                                            throw new ManifoldCFException("IO exception reading data from string: " + e.getMessage(), (Throwable)e);
                                        }
                                        catch (InterruptedIOException e) {
                                            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                                        }
                                        catch (IOException e) {
                                            throw new ManifoldCFException("IO exception reading data from string: " + e.getMessage(), (Throwable)e);
                                        }
                                    }
                                    if (Logging.connectors.isDebugEnabled()) {
                                        Logging.connectors.debug((Object)("RSS: Skipping carry-down document '" + urlValue + "' because it is unmappable or is a seed."));
                                    }
                                } else {
                                    oldVersionString = statuses.getIndexedVersionString(documentIdentifier);
                                    lastETagValue = null;
                                    lastModifiedValue = null;
                                    if (Logging.connectors.isDebugEnabled() && (lastETagValue != null || lastModifiedValue != null)) {
                                        Logging.connectors.debug((Object)("RSS: Document '" + urlValue + "' was found to have a previous ETag value of '" + (lastETagValue == null ? "null" : lastETagValue) + "' and a previous Last-Modified value of '" + (lastModifiedValue == null ? "null" : lastModifiedValue) + "'"));
                                    }
                                    try {
                                        url = new URL(urlValue);
                                    }
                                    catch (MalformedURLException e) {
                                        Logging.connectors.debug((Object)("RSS: URL '" + urlValue + "' is malformed; skipping"), (Throwable)e);
                                        activities.deleteDocument(documentIdentifier);
                                        for (CharacterInput var35_48 : dechromedData) {
                                            if (var35_48 == null) continue;
                                            var35_48.discard();
                                        }
                                        RSSConnector.cache.deleteData(documentIdentifier);
                                        break block127;
                                    }
                                }
                                ** try [egrp 5[TRYBLOCK] [53 : 955->1164)] { 
lbl111:
                                // 1 sources

                                ** try [egrp 6[TRYBLOCK] [44 : 955->1122)] { 
lbl112:
                                // 1 sources

                                protocol = url.getProtocol();
                                port = url.getPort();
                                hostName = url.getHost();
                                pathPart = url.getFile();
                                if (this.robotsUsage >= 1 && !this.robots.isFetchAllowed(this.currentContext, this.throttleGroupName, protocol, port, hostName, url.getPath(), this.userAgent, this.from, this.proxyHost, this.proxyPort, this.proxyAuthDomain, this.proxyAuthUsername, this.proxyAuthPassword, activities, connectionLimit)) {
                                    activities.recordActivity(null, "fetch", null, urlValue, Integer.toString(-2), "Robots exclusion", null);
                                    if (Logging.connectors.isDebugEnabled()) {
                                        Logging.connectors.debug((Object)("RSS: Skipping url '" + urlValue + "' because robots.txt says to"));
                                    }
                                    activities.deleteDocument(documentIdentifier);
                                }
                                var35_50 = this.fetcher.createConnection(this.currentContext, this.throttleGroupName, hostName, connectionLimit, feedTimeout, this.proxyHost, this.proxyPort, this.proxyAuthDomain, this.proxyAuthUsername, this.proxyAuthPassword, (IAbortActivity)activities);
                                try {
                                    var35_50.beginFetch("Data");
                                    try {
                                        status = var35_50.executeFetch(protocol, port, pathPart, this.userAgent, this.from, lastETagValue, lastModifiedValue);
                                        switch (status) {
                                            case 3: {
                                                versionString = oldVersionString;
                                                ** break;
lbl130:
                                                // 1 sources

                                                break;
                                            }
                                            case 0: {
                                                if (Logging.connectors.isDebugEnabled()) {
                                                    Logging.connectors.debug((Object)("RSS: Successfully fetched " + urlValue));
                                                }
                                                if ((contentType = var35_50.getResponseHeader("Content-Type")) != null) {
                                                    contentTypes = contentType.split(",");
                                                    contentType = contentTypes.length > 0 ? contentTypes[contentTypes.length - 1].trim() : null;
                                                }
                                                if ((strippedContentType = contentType) != null && (pos = strippedContentType.indexOf(";")) != -1) {
                                                    strippedContentType = strippedContentType.substring(0, pos).trim();
                                                }
                                                isXML = strippedContentType != null && RSSConnector.xmlContentTypes.contains(strippedContentType) != false;
                                                ingestURL = null;
                                                if (!isXML) {
                                                    if (f.getChromedContentMode() == 1) {
                                                        if (Logging.connectors.isDebugEnabled()) {
                                                            Logging.connectors.debug((Object)("RSS: Removing url '" + urlValue + "' because it no longer has dechromed content available"));
                                                        }
                                                        versionString = null;
                                                        ** break;
lbl148:
                                                        // 1 sources

                                                        break;
                                                    }
                                                    if (!activities.checkMimeTypeIndexable(contentType)) {
                                                        if (Logging.connectors.isDebugEnabled()) {
                                                            Logging.connectors.debug((Object)("RSS: Removing url '" + urlValue + "' because it had the wrong content type: " + (contentType == null ? "null" : "'" + contentType + "'")));
                                                        }
                                                        versionString = null;
                                                        ** break;
lbl154:
                                                        // 1 sources

                                                        break;
                                                    }
                                                    ingestURL = f.mapDocumentURL(urlValue);
                                                } else {
                                                    if (Logging.connectors.isDebugEnabled()) {
                                                        Logging.connectors.debug((Object)("RSS: The url '" + urlValue + "' is a feed"));
                                                    }
                                                    if (!f.isSeed(urlValue)) {
                                                        if (Logging.connectors.isDebugEnabled()) {
                                                            Logging.connectors.debug((Object)("RSS: Removing feed url '" + urlValue + "' because it is not a seed."));
                                                        }
                                                        versionString = null;
                                                        ** break;
lbl164:
                                                        // 1 sources

                                                        break;
                                                    }
                                                }
                                                is = var35_50.getResponseBodyStream();
                                                try {
                                                    checkSum = RSSConnector.cache.addData(activities, urlValue, contentType, is);
                                                    sb = new StringBuilder();
                                                    if (ingestURL != null) {
                                                        pubDates = activities.retrieveParentData(urlValue, "pubdate");
                                                        sources = activities.retrieveParentData(urlValue, "source");
                                                        titles = activities.retrieveParentData(urlValue, "title");
                                                        authorNames = activities.retrieveParentData(urlValue, "authorname");
                                                        authorEmails = activities.retrieveParentData(urlValue, "authoremail");
                                                        categories = activities.retrieveParentData(urlValue, "category");
                                                        descriptions = activities.retrieveParentData(urlValue, "description");
                                                        Arrays.sort(pubDates);
                                                        Arrays.sort(sources);
                                                        Arrays.sort(titles);
                                                        Arrays.sort(authorNames);
                                                        Arrays.sort(authorEmails);
                                                        Arrays.sort(categories);
                                                        Arrays.sort(descriptions);
                                                        if (sources.length == 0 && Logging.connectors.isDebugEnabled()) {
                                                            Logging.connectors.debug((Object)("RSS: Warning; URL '" + ingestURL + "' doesn't seem to have any RSS feed source!"));
                                                        }
                                                        sb.append('+');
                                                        RSSConnector.packList((StringBuilder)sb, (String[])acls, (char)'+');
                                                        if (acls.length > 0) {
                                                            sb.append('+');
                                                            RSSConnector.pack((StringBuilder)sb, (String)"DEAD_AUTHORITY", (char)'+');
                                                        } else {
                                                            sb.append('-');
                                                        }
                                                        RSSConnector.pack((StringBuilder)sb, (String)ingestURL, (char)'+');
                                                        RSSConnector.packList((StringBuilder)sb, (String[])pubDates, (char)'+');
                                                        RSSConnector.packList((StringBuilder)sb, (String[])titles, (char)'+');
                                                        RSSConnector.packList((StringBuilder)sb, (String[])sources, (char)'+');
                                                        RSSConnector.packList((StringBuilder)sb, (String[])categories, (char)'+');
                                                        RSSConnector.packList((StringBuilder)sb, (String[])descriptions, (char)'+');
                                                        RSSConnector.packList((StringBuilder)sb, (String[])authorNames, (char)'+');
                                                        RSSConnector.packList((StringBuilder)sb, (String[])authorEmails, (char)'+');
                                                    } else {
                                                        sb.append('-');
                                                        etag = var35_50.getResponseHeader("ETag");
                                                        if (etag == null) {
                                                            RSSConnector.pack((StringBuilder)sb, (String)"", (char)'+');
                                                        } else {
                                                            RSSConnector.pack((StringBuilder)sb, (String)etag, (char)'+');
                                                        }
                                                        lastModified = var35_50.getResponseHeader("Last-Modified");
                                                        if (lastModified == null) {
                                                            RSSConnector.pack((StringBuilder)sb, (String)"", (char)'+');
                                                        } else {
                                                            RSSConnector.pack((StringBuilder)sb, (String)lastModified, (char)'+');
                                                        }
                                                    }
                                                    sb.append(new Long(checkSum).toString());
                                                    versionString = sb.toString();
                                                    break;
                                                }
                                                finally {
                                                    is.close();
                                                }
                                            }
                                            catch (SocketTimeoutException e) {
                                                Logging.connectors.warn((Object)("RSS: Socket timeout exception fetching document contents '" + urlValue + "' - skipping: " + e.getMessage()), (Throwable)e);
                                                versionString = null;
                                                ** break;
lbl228:
                                                // 1 sources

                                                break;
                                            }
                                            catch (ConnectTimeoutException e) {
                                                Logging.connectors.warn((Object)("RSS: Connecto timeout exception fetching document contents '" + urlValue + "' - skipping: " + e.getMessage()), (Throwable)e);
                                                versionString = null;
                                                ** break;
lbl233:
                                                // 1 sources

                                                break;
                                            }
                                            catch (InterruptedIOException e) {
                                                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                                            }
                                            catch (IOException e) {
                                                Logging.connectors.warn((Object)("RSS: IO exception fetching document contents '" + urlValue + "' - skipping: " + e.getMessage()), (Throwable)e);
                                                versionString = null;
                                                ** break;
lbl240:
                                                // 1 sources

                                                break;
                                            }
                                            default: {
                                                versionString = "";
                                                break;
                                            }
                                        }
                                    }
                                    finally {
                                        var35_50.doneFetch(activities);
                                    }
                                }
                                finally {
                                    var35_50.close();
                                }
                                if (versionString == null) {
                                    activities.deleteDocument(documentIdentifier);
                                }
                                if (versionString.length() != 0 && !activities.checkDocumentNeedsReindexing(documentIdentifier, versionString)) {
                                }
                                if (Logging.connectors.isDebugEnabled()) {
                                    Logging.connectors.debug((Object)("RSS: Processing '" + urlValue + "'"));
                                }
                                if (ingestURL == null) {
                                    if (Logging.connectors.isDebugEnabled()) {
                                        Logging.connectors.debug((Object)("RSS: Interpreting document '" + urlValue + "' as a feed"));
                                    }
                                    this.handleRSSFeedSAX(urlValue, activities, f);
                                    if (Logging.connectors.isDebugEnabled()) {
                                        Logging.connectors.debug((Object)("RSS: Extraction of feed '" + urlValue + "' complete"));
                                    }
                                    activities.recordDocument(documentIdentifier, versionString);
                                }
                                if (Logging.connectors.isDebugEnabled()) {
                                    Logging.connectors.debug((Object)("RSS: Interpreting '" + urlValue + "' as a document"));
                                }
                                errorCode = null;
                                errorDesc = null;
                                startTime = System.currentTimeMillis();
                                fileLengthLong = null;
                                try {
                                    documentLength = RSSConnector.cache.getDataLength(documentIdentifier);
                                    if (!activities.checkLengthIndexable(documentLength)) {
                                        activities.noDocument(documentIdentifier, versionString);
                                        errorCode = "EXCLUDEDLENGTH";
                                        errorDesc = "Document rejected because of length (" + documentLength + ")";
                                        if (Logging.connectors.isDebugEnabled()) {
                                            Logging.connectors.debug((Object)("RSS: Skipping document '" + urlValue + "' because its length was rejected (" + documentLength + ")"));
                                        }
                                        if (errorCode == null) break block129;
                                    }
                                    ** GOTO lbl-1000
                                }
                                catch (ManifoldCFException e) {
                                    try {
                                        if (e.getErrorCode() != 2) throw e;
                                        errorCode = null;
                                        throw e;
                                    }
                                    catch (Throwable var57_105) {
                                        if (errorCode == null) throw var57_105;
                                        activities.recordActivity(new Long(startTime), "process", null, urlValue, errorCode, errorDesc, null);
                                        throw var57_105;
                                    }
                                }
                                activities.recordActivity(new Long(startTime), "process", null, urlValue, errorCode, errorDesc, null);
                            }
lbl-1000:
                            // 1 sources

                            {
                                if (activities.checkURLIndexable(documentIdentifier)) ** GOTO lbl-1000
                                activities.noDocument(documentIdentifier, versionString);
                                errorCode = "EXCLUDEDURL";
                                errorDesc = "Document rejected because of URL ('" + documentIdentifier + "')";
                                if (Logging.connectors.isDebugEnabled()) {
                                    Logging.connectors.debug((Object)("RSS: Skipping document '" + urlValue + "' because its URL was rejected ('" + documentIdentifier + "')"));
                                }
                                if (errorCode == null) break block130;
                            }
                            activities.recordActivity(new Long(startTime), "process", null, urlValue, errorCode, errorDesc, null);
                        }
lbl-1000:
                        // 1 sources

                        {
                            contentType = RSSConnector.cache.getContentType(documentIdentifier);
                            if (contentType != null) {
                                contentTypes = contentType.split(",");
                                contentType = contentTypes.length > 0 ? contentTypes[contentTypes.length - 1].trim() : null;
                            }
                            if (activities.checkMimeTypeIndexable(contentType)) ** GOTO lbl-1000
                            activities.noDocument(documentIdentifier, versionString);
                            errorCode = "EXCLUDEDMIMETYPE";
                            errorDesc = "Document rejected because of mime type (" + contentType + ")";
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("RSS: Skipping document '" + urlValue + "' because its mime type was rejected ('" + contentType + "')"));
                            }
                            if (errorCode == null) break block131;
                        }
                        activities.recordActivity(new Long(startTime), "process", null, urlValue, errorCode, errorDesc, null);
                    }
lbl-1000:
                    // 1 sources

                    {
                        dataSize = RSSConnector.cache.getDataLength(urlValue);
                        rd = new RepositoryDocument();
                        if (contentType != null) {
                            rd.setMimeType(contentType);
                        }
                        denyAcls = acls == null ? null : (acls.length == 0 ? new String[]{} : new String[]{"DEAD_AUTHORITY"});
                        if (acls != null && denyAcls != null) {
                            rd.setSecurity("document", (String[])acls, denyAcls);
                        }
                        if (titles != null && titles.length > 0) {
                            rd.addField("title", (String[])titles);
                        }
                        if (authorNames != null && authorNames.length > 0) {
                            rd.addField("authorname", (String[])authorNames);
                        }
                        if (authorEmails != null && authorEmails.length > 0) {
                            rd.addField("authoremail", (String[])authorEmails);
                        }
                        if (descriptions != null && descriptions.length > 0) {
                            rd.addField("summary", (String[])descriptions);
                        }
                        if (sources != null && sources.length > 0) {
                            rd.addField("source", (String[])sources);
                        }
                        if (categories != null && categories.length > 0) {
                            rd.addField("category", (String[])categories);
                        }
                        minimumOrigTime = null;
                        if (pubDates != null && pubDates.length > 0) {
                            pubDateValuesISO = new String[pubDates.length];
                            tz = TimeZone.getTimeZone("UTC");
                            df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'", Locale.ROOT);
                            df.setTimeZone(tz);
                            for (k = 0; k < pubDates.length; ++k) {
                                pubDate = pubDates[k];
                                try {
                                    pubDateLong = new Long((String)pubDate);
                                    if (minimumOrigTime == null || pubDateLong < minimumOrigTime) {
                                        minimumOrigTime = pubDateLong;
                                    }
                                    pubDateValuesISO[k] = df.format(new Date(pubDateLong));
                                    continue;
                                }
                                catch (NumberFormatException e) {
                                    pubDateValuesISO[k] = "";
                                }
                            }
                            rd.addField("pubdate", (String[])pubDates);
                            rd.addField("pubdateiso", pubDateValuesISO);
                        }
                        if (minimumOrigTime != null) {
                            activities.setDocumentOriginationTime(urlValue, minimumOrigTime);
                        }
                        if ((is = RSSConnector.cache.getData(urlValue)) != null) {
                            try {
                                rd.setBinary(is, dataSize);
                                try {
                                    activities.ingestDocumentWithException(documentIdentifier, versionString, ingestURL, rd);
                                    errorCode = "OK";
                                    fileLengthLong = new Long(dataSize);
                                }
                                catch (IOException e) {
                                    errorCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                    errorDesc = e.getMessage();
                                    RSSConnector.handleIOException(e, "reading data");
                                }
                            }
                            finally {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {
                                    errorCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                    errorDesc = e.getMessage();
                                    RSSConnector.handleIOException(e, "closing stream");
                                }
                            }
                        }
                        if (errorCode == null) break block133;
                    }
                    activities.recordActivity(new Long(startTime), "process", null, urlValue, errorCode, errorDesc, null);
                }
lbl390:
                // 1 sources

                finally {
                    for (CharacterInput ci : dechromedData) {
                        if (ci == null) continue;
                        ci.discard();
                    }
                    break block127;
                }
lbl396:
                // 1 sources

                finally {
                    RSSConnector.cache.deleteData(documentIdentifier);
                }
            }
            ++var14_14;
        }
    }

    protected static void handleIOException(IOException e, String context) throws ManifoldCFException, ServiceInterruption {
        if (e instanceof SocketTimeoutException) {
            throw new ManifoldCFException("IO error " + context + ": " + e.getMessage(), (Throwable)e);
        }
        if (e instanceof InterruptedIOException) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        throw new ManifoldCFException("IO error " + context + ": " + e.getMessage(), (Throwable)e);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "RSSConnector.Email"));
        tabsArray.add(Messages.getString(locale, "RSSConnector.Robots"));
        tabsArray.add(Messages.getString(locale, "RSSConnector.Bandwidth"));
        tabsArray.add(Messages.getString(locale, "RSSConnector.Proxy"));
        out.print("<script type=\"text/javascript\">\n<!--\nfunction checkConfig()\n{\n  if (editconnection.email.value != \"\" && editconnection.email.value.indexOf(\"@\") == -1)\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "RSSConnector.NeedAValidEmailAddress") + "\");\n    editconnection.email.focus();\n    return false;\n  }\n  if (editconnection.bandwidth.value != \"\" && !isInteger(editconnection.bandwidth.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "RSSConnector.EnterAValidNumberOrBlankForNoLimit") + "\");\n    editconnection.bandwidth.focus();\n    return false;\n  }\n  if (editconnection.connections.value == \"\" || !isInteger(editconnection.connections.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "RSSConnector.EnterAValidNumberForTheMaxNumberOfOpenConnectionsPerServer") + "\");\n    editconnection.connections.focus();\n    return false;\n  }\n  if (editconnection.fetches.value != \"\" && !isInteger(editconnection.fetches.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "RSSConnector.EnterAValidNumberOrBlankForNoLimit") + "\");\n    editconnection.fetches.focus();\n    return false;\n  }\n  return true;\n}\n\nfunction checkConfigForSave()\n{\n  if (editconnection.email.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "RSSConnector.EmailAddressRequiredToBeIncludedInAllRequestHeaders") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "RSSConnector.Email") + "\");\n    editconnection.email.focus();\n    return false;\n  }\n  return true;\n}\n\n//-->\n</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String proxyAuthPassword;
        String proxyAuthUsername;
        String proxyAuthDomain;
        String proxyPort;
        String proxyHost;
        String throttleGroup;
        String fetches;
        String connections;
        String bandwidth;
        String robotsUsage;
        String email = parameters.getParameter("Email address");
        if (email == null) {
            email = "";
        }
        if ((robotsUsage = parameters.getParameter("Robots usage")) == null) {
            robotsUsage = "all";
        }
        if ((bandwidth = parameters.getParameter("KB per second")) == null) {
            bandwidth = "64";
        }
        if ((connections = parameters.getParameter("Max server connections")) == null) {
            connections = "2";
        }
        if ((fetches = parameters.getParameter("Max fetches per minute")) == null) {
            fetches = "12";
        }
        if ((throttleGroup = parameters.getParameter("Throttle group")) == null) {
            throttleGroup = "";
        }
        if ((proxyHost = parameters.getParameter("Proxy host")) == null) {
            proxyHost = "";
        }
        if ((proxyPort = parameters.getParameter("Proxy port")) == null) {
            proxyPort = "";
        }
        if ((proxyAuthDomain = parameters.getParameter("Proxy authentication domain")) == null) {
            proxyAuthDomain = "";
        }
        if ((proxyAuthUsername = parameters.getParameter("Proxy authentication user name")) == null) {
            proxyAuthUsername = "";
        }
        proxyAuthPassword = (proxyAuthPassword = parameters.getObfuscatedParameter("Proxy authentication password")) == null ? "" : out.mapPasswordToKey(proxyAuthPassword);
        if (tabName.equals(Messages.getString(locale, "RSSConnector.Email"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.EmailAddressToContactColon") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"32\" name=\"email\" value=\"" + Encoder.attributeEscape((String)email) + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"email\" value=\"" + Encoder.attributeEscape((String)email) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "RSSConnector.Robots"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.RobotsTxtUsageColon") + "</nobr></td>\n    <td class=\"value\">\n      <select name=\"robotsusage\" size=\"3\">\n        <option value=\"none\" " + (robotsUsage.equals("none") ? "selected=\"selected\"" : "") + ">" + Messages.getBodyString(locale, "RSSConnector.DontLookAtRobotsTxt") + "</option>\n        <option value=\"data\" " + (robotsUsage.equals("data") ? "selected=\"selected\"" : "") + ">" + Messages.getBodyString(locale, "RSSConnector.ObeyRobotsTxtForDataFetchesOnly") + "</option>\n        <option value=\"all\" " + (robotsUsage.equals("all") ? "selected=\"selected\"" : "") + ">" + Messages.getBodyString(locale, "RSSConnector.ObeyRobotsTxtForAllFetches") + "</option>\n      </select>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"robotsusage\" value=\"" + robotsUsage + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "RSSConnector.Bandwidth"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.MaxKBytesPerSecondPerServerColon") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"6\" name=\"bandwidth\" value=\"" + Encoder.attributeEscape((String)bandwidth) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.MaxConnectionsPerServerColon") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"4\" name=\"connections\" value=\"" + Encoder.attributeEscape((String)connections) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.MaxFetchesPerMinutePerServerColon") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"4\" name=\"fetches\" value=\"" + Encoder.attributeEscape((String)fetches) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.ThrottleGroupNameColon") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"32\" name=\"throttlegroup\" value=\"" + Encoder.attributeEscape((String)throttleGroup) + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"bandwidth\" value=\"" + Encoder.attributeEscape((String)bandwidth) + "\"/>\n<input type=\"hidden\" name=\"connections\" value=\"" + Encoder.attributeEscape((String)connections) + "\"/>\n<input type=\"hidden\" name=\"fetches\" value=\"" + Encoder.attributeEscape((String)fetches) + "\"/>\n<input type=\"hidden\" name=\"throttlegroup\" value=\"" + Encoder.attributeEscape((String)throttleGroup) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "RSSConnector.Proxy"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.ProxyHostColon") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"40\" name=\"proxyhost\" value=\"" + Encoder.attributeEscape((String)proxyHost) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.ProxyPortColon") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"5\" name=\"proxyport\" value=\"" + Encoder.attributeEscape((String)proxyPort) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.ProxyAuthenticationDomainColon") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"32\" name=\"proxyauthdomain\" value=\"" + Encoder.attributeEscape((String)proxyAuthDomain) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.ProxyAuthenticationUserNameColon") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"32\" name=\"proxyauthusername\" value=\"" + Encoder.attributeEscape((String)proxyAuthUsername) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.ProxyAuthenticationPasswordColon") + "</nobr></td>\n    <td class=\"value\"><input type=\"password\" size=\"16\" name=\"proxyauthpassword\" value=\"" + Encoder.attributeEscape((String)proxyAuthPassword) + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"proxyhost\" value=\"" + Encoder.attributeEscape((String)proxyHost) + "\"/>\n<input type=\"hidden\" name=\"proxyport\" value=\"" + Encoder.attributeEscape((String)proxyPort) + "\"/>\n<input type=\"hidden\" name=\"proxyauthusername\" value=\"" + Encoder.attributeEscape((String)proxyAuthUsername) + "\"/>\n<input type=\"hidden\" name=\"proxyauthdomain\" value=\"" + Encoder.attributeEscape((String)proxyAuthDomain) + "\"/>\n<input type=\"hidden\" name=\"proxyauthpassword\" value=\"" + Encoder.attributeEscape((String)proxyAuthPassword) + "\"/>\n");
        }
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String proxyAuthPassword;
        String proxyAuthUsername;
        String proxyAuthDomain;
        String proxyPort;
        String proxyHost;
        String throttleGroup;
        String fetches;
        String connections;
        String bandwidth;
        String robotsUsage;
        String email = variableContext.getParameter("email");
        if (email != null) {
            parameters.setParameter("Email address", email);
        }
        if ((robotsUsage = variableContext.getParameter("robotsusage")) != null) {
            parameters.setParameter("Robots usage", robotsUsage);
        }
        if ((bandwidth = variableContext.getParameter("bandwidth")) != null) {
            parameters.setParameter("KB per second", bandwidth);
        }
        if ((connections = variableContext.getParameter("connections")) != null) {
            parameters.setParameter("Max server connections", connections);
        }
        if ((fetches = variableContext.getParameter("fetches")) != null) {
            parameters.setParameter("Max fetches per minute", fetches);
        }
        if ((throttleGroup = variableContext.getParameter("throttlegroup")) != null) {
            parameters.setParameter("Throttle group", throttleGroup);
        }
        if ((proxyHost = variableContext.getParameter("proxyhost")) != null) {
            parameters.setParameter("Proxy host", proxyHost);
        }
        if ((proxyPort = variableContext.getParameter("proxyport")) != null) {
            parameters.setParameter("Proxy port", proxyPort);
        }
        if ((proxyAuthDomain = variableContext.getParameter("proxyauthdomain")) != null) {
            parameters.setParameter("Proxy authentication domain", proxyAuthDomain);
        }
        if ((proxyAuthUsername = variableContext.getParameter("proxyauthusername")) != null) {
            parameters.setParameter("Proxy authentication user name", proxyAuthUsername);
        }
        if ((proxyAuthPassword = variableContext.getParameter("proxyauthpassword")) != null) {
            parameters.setObfuscatedParameter("Proxy authentication password", variableContext.mapKeyToPassword(proxyAuthPassword));
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.ParametersColon") + "</nobr></td>\n    <td class=\"value\" colspan=\"3\">\n");
        Iterator iter = parameters.listParameters();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String value = parameters.getParameter(param);
            if (param.length() >= "password".length() && param.substring(param.length() - "password".length()).equalsIgnoreCase("password")) {
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=********</nobr><br/>\n");
                continue;
            }
            if (param.length() >= "keystore".length() && param.substring(param.length() - "keystore".length()).equalsIgnoreCase("keystore")) {
                IKeystoreManager kmanager = KeystoreManagerFactory.make((String)"", (String)value);
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=<" + Integer.toString(kmanager.getContents().length) + Messages.getBodyString(locale, "RSSConnector.certificates") + "></nobr><br/>\n");
                continue;
            }
            out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=" + Encoder.bodyEscape((String)value) + "</nobr><br/>\n");
        }
        out.print("    </td>\n  </tr>\n</table>\n");
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "RSSConnector.URLs"));
        tabsArray.add(Messages.getString(locale, "RSSConnector.Canonicalization"));
        tabsArray.add(Messages.getString(locale, "RSSConnector.URLMappings"));
        tabsArray.add(Messages.getString(locale, "RSSConnector.Exclusions"));
        tabsArray.add(Messages.getString(locale, "RSSConnector.TimeValues"));
        tabsArray.add(Messages.getString(locale, "RSSConnector.Security"));
        tabsArray.add(Messages.getString(locale, "RSSConnector.DechromedContent"));
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        out.print("<script type=\"text/javascript\">\n<!--\nfunction " + seqPrefix + "SpecOp(n, opValue, anchorvalue)\n{\n  eval(\"editjob.\"+n+\".value = \\\"\"+opValue+\"\\\"\");\n  postFormSetAnchor(anchorvalue);\n}\n\nfunction " + seqPrefix + "AddRegexp(anchorvalue)\n{\n  if (editjob." + seqPrefix + "rssmatch.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "RSSConnector.MatchMustHaveARegexpValue") + "\");\n    editjob." + seqPrefix + "rssmatch.focus();\n    return;\n  }\n\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "rssop\",\"Add\",anchorvalue);\n}\n\nfunction " + seqPrefix + "RemoveRegexp(index, anchorvalue)\n{\n  editjob." + seqPrefix + "rssindex.value = index;\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "rssop\",\"Delete\",anchorvalue);\n}\n\nfunction " + seqPrefix + "SpecAddToken(anchorvalue)\n{\n  if (editjob." + seqPrefix + "spectoken.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "RSSConnector.TypeInAnAccessToken") + "\");\n    editjob." + seqPrefix + "spectoken.focus();\n    return;\n  }\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "accessop\",\"Add\",anchorvalue);\n}\n\nfunction " + seqPrefix + "URLRegexpDelete(index, anchorvalue)\n{\n  editjob." + seqPrefix + "urlregexpnumber.value = index;\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "urlregexpop\",\"Delete\",anchorvalue);\n}\n\nfunction " + seqPrefix + "URLRegexpAdd(anchorvalue)\n{\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "urlregexpop\",\"Add\",anchorvalue);\n}\n\nfunction " + seqPrefix + "checkSpecification()\n{\n  if (editjob." + seqPrefix + "feedtimeout.value == \"\" || !isInteger(editjob." + seqPrefix + "feedtimeout.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "RSSConnector.ATimeoutValueInSecondsIsRequired") + "\");\n    editjob." + seqPrefix + "feedtimeout.focus();\n    return false;\n  }\n  if (editjob." + seqPrefix + "feedrefetch.value == \"\" || !isInteger(editjob." + seqPrefix + "feedrefetch.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "RSSConnector.ARefetchIntervalInMinutesIsRequired") + "\");\n    editjob." + seqPrefix + "feedrefetch.focus();\n    return false;\n  }\n  if (editjob." + seqPrefix + "minfeedrefetch.value == \"\" || !isInteger(editjob." + seqPrefix + "minfeedrefetch.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "RSSConnector.AMinimumRefetchIntervalInMinutesIsRequire") + "\");\n    editjob." + seqPrefix + "minfeedrefetch.focus();\n    return false;\n  }\n  if (editjob." + seqPrefix + "badfeedrefetch.value != \"\" && !isInteger(editjob." + seqPrefix + "badfeedrefetch.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "RSSConnector.ABadFeedRefetchIntervalInMinutesIsRequired") + "\");\n    editjob." + seqPrefix + "badfeedrefetch.focus();\n    return false;\n  }\n\n  return true;\n}\n\n//-->\n</script>\n");
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        String accessDescription;
        SpecificationNode sn;
        String allowBVSessionRemoval;
        String allowPHPSessionRemoval;
        String allowASPSessionRemoval;
        String allowJavaSessionRemoval;
        String allowReorder;
        String description;
        String regexpString;
        SpecificationNode specNode;
        int l;
        int q;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        StringBuilder sb = new StringBuilder();
        ArrayList<String> regexp = new ArrayList<String>();
        ArrayList<String> matchStrings = new ArrayList<String>();
        int feedTimeoutValue = 60;
        int feedRefetchValue = 60;
        int minFeedRefetchValue = 15;
        Integer badFeedRefetchValue = null;
        String exclusions = "";
        int i = 0;
        while (i < ds.getChildCount()) {
            String value;
            SpecificationNode sn2;
            if ((sn2 = ds.getChild(i++)).getType().equals("feed")) {
                String rssURL = sn2.getAttributeValue("url");
                if (rssURL == null) continue;
                sb.append(rssURL).append("\n");
                continue;
            }
            if (sn2.getType().equals("excludes")) {
                exclusions = sn2.getValue();
                if (exclusions != null) continue;
                exclusions = "";
                continue;
            }
            if (sn2.getType().equals("map")) {
                String match = sn2.getAttributeValue("match");
                String map = sn2.getAttributeValue("map");
                if (match == null) continue;
                regexp.add(match);
                if (map == null) {
                    map = "";
                }
                matchStrings.add(map);
                continue;
            }
            if (sn2.getType().equals("feedtimeout")) {
                value = sn2.getAttributeValue("value");
                feedTimeoutValue = Integer.parseInt(value);
                continue;
            }
            if (sn2.getType().equals("feedrescan")) {
                value = sn2.getAttributeValue("value");
                feedRefetchValue = Integer.parseInt(value);
                continue;
            }
            if (sn2.getType().equals("minfeedrescan")) {
                value = sn2.getAttributeValue("value");
                minFeedRefetchValue = Integer.parseInt(value);
                continue;
            }
            if (!sn2.getType().equals("badfeedrescan")) continue;
            value = sn2.getAttributeValue("value");
            badFeedRefetchValue = new Integer(value);
        }
        if (tabName.equals(Messages.getString(locale, "RSSConnector.URLs")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"value\" colspan=\"2\">\n      <textarea rows=\"25\" cols=\"80\" name=\"" + seqPrefix + "rssurls\">" + Encoder.bodyEscape((String)sb.toString()) + "</textarea>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "rssurls\" value=\"" + Encoder.attributeEscape((String)sb.toString()) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "RSSConnector.Exclusions")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.Exclude") + "</nobr></td>\n    <td class=\"value\" colspan=\"1\">\n      <textarea rows=\"25\" cols=\"60\" name=\"" + seqPrefix + "exclusions\">" + Encoder.bodyEscape((String)exclusions) + "</textarea>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "exclusions\" value=\"" + Encoder.attributeEscape((String)exclusions) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "RSSConnector.Canonicalization")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"boxcell\" colspan=\"2\">\n      <input type=\"hidden\" name=\"" + seqPrefix + "urlregexpop\" value=\"Continue\"/>\n      <input type=\"hidden\" name=\"" + seqPrefix + "urlregexpnumber\" value=\"\"/>\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.URLRegularExpression") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.Description") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.Reorder") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.RemoveJSPSessions") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.RemoveASPSessions") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.RemovePHPSessions") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.RemoveBVSessions") + "</nobr></td>\n        </tr>\n");
            q = 0;
            l = 0;
            while (q < ds.getChildCount()) {
                if (!(specNode = ds.getChild(q++)).getType().equals("urlspec")) continue;
                regexpString = specNode.getAttributeValue("regexp");
                description = specNode.getAttributeValue("description");
                if (description == null) {
                    description = "";
                }
                if ((allowReorder = specNode.getAttributeValue("reorder")) == null || allowReorder.length() == 0) {
                    allowReorder = "no";
                }
                if ((allowJavaSessionRemoval = specNode.getAttributeValue("javasessionremoval")) == null || allowJavaSessionRemoval.length() == 0) {
                    allowJavaSessionRemoval = "no";
                }
                if ((allowASPSessionRemoval = specNode.getAttributeValue("aspsessionremoval")) == null || allowASPSessionRemoval.length() == 0) {
                    allowASPSessionRemoval = "no";
                }
                if ((allowPHPSessionRemoval = specNode.getAttributeValue("phpsessionremoval")) == null || allowPHPSessionRemoval.length() == 0) {
                    allowPHPSessionRemoval = "no";
                }
                if ((allowBVSessionRemoval = specNode.getAttributeValue("bvsessionremoval")) == null || allowBVSessionRemoval.length() == 0) {
                    allowBVSessionRemoval = "no";
                }
                out.print("        <tr class=\"" + (l % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n          <td class=\"formcolumncell\">\n            <a name=\"" + seqPrefix + "urlregexp_" + Integer.toString(l) + "\">\n              <input type=\"button\" value=\"Delete\" alt=\"" + Messages.getAttributeString(locale, "RSSConnector.DeleteUrlRegexp") + Encoder.attributeEscape((String)regexpString) + "\" onclick='javascript:" + seqPrefix + "URLRegexpDelete(" + Integer.toString(l) + ",\"" + seqPrefix + "urlregexp_" + Integer.toString(l) + "\");'/>\n            </a>\n          </td>\n          <td class=\"formcolumncell\">\n            <input type=\"hidden\" name=\"" + seqPrefix + "urlregexp_" + Integer.toString(l) + "\" value=\"" + Encoder.attributeEscape((String)regexpString) + "\"/>\n            <input type=\"hidden\" name=\"" + seqPrefix + "urlregexpdesc_" + Integer.toString(l) + "\" value=\"" + Encoder.attributeEscape((String)description) + "\"/>\n            <input type=\"hidden\" name=\"" + seqPrefix + "urlregexpreorder_" + Integer.toString(l) + "\" value=\"" + allowReorder + "\"/>\n            <input type=\"hidden\" name=\"" + seqPrefix + "urlregexpjava_" + Integer.toString(l) + "\" value=\"" + allowJavaSessionRemoval + "\"/>\n            <input type=\"hidden\" name=\"" + seqPrefix + "urlregexpasp_" + Integer.toString(l) + "\" value=\"" + allowASPSessionRemoval + "\"/>\n            <input type=\"hidden\" name=\"" + seqPrefix + "urlregexpphp_" + Integer.toString(l) + "\" value=\"" + allowPHPSessionRemoval + "\"/>\n            <input type=\"hidden\" name=\"" + seqPrefix + "urlregexpbv_" + Integer.toString(l) + "\" value=\"" + allowBVSessionRemoval + "\"/>\n            <nobr>" + Encoder.bodyEscape((String)regexpString) + "</nobr>\n          </td>\n          <td class=\"formcolumncell\">" + Encoder.bodyEscape((String)description) + "</td>\n          <td class=\"formcolumncell\">" + allowReorder + "</td>\n          <td class=\"formcolumncell\">" + allowJavaSessionRemoval + "</td>\n          <td class=\"formcolumncell\">" + allowASPSessionRemoval + "</td>\n          <td class=\"formcolumncell\">" + allowPHPSessionRemoval + "</td>\n          <td class=\"formcolumncell\">" + allowBVSessionRemoval + "</td>\n        </tr>\n");
                ++l;
            }
            if (l == 0) {
                out.print("        <tr class=\"formrow\"><td colspan=\"8\" class=\"formcolumnmessage\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.NoCanonicalizationSpecified") + "</nobr></td></tr>\n");
            }
            out.print("        <tr class=\"formrow\"><td colspan=\"8\" class=\"formseparator\"><hr/></td></tr>\n        <tr class=\"formrow\">\n          <td class=\"formcolumncell\">\n            <a name=\"" + seqPrefix + "urlregexp_" + Integer.toString(l) + "\">\n              <input type=\"button\" value=\"Add\" alt=\"" + Messages.getAttributeString(locale, "RSSConnector.AddUlRegexp") + "\" onclick='javascript:" + seqPrefix + "URLRegexpAdd(\"" + seqPrefix + "urlregexp_" + Integer.toString(l + 1) + "\");'/>\n              <input type=\"hidden\" name=\"" + seqPrefix + "urlregexpcount\" value=\"" + Integer.toString(l) + "\"/>\n            </a>\n          </td>\n          <td class=\"formcolumncell\"><input type=\"text\" name=\"" + seqPrefix + "urlregexp\" size=\"30\" value=\"\"/></td>\n          <td class=\"formcolumncell\"><input type=\"text\" name=\"" + seqPrefix + "urlregexpdesc\" size=\"30\" value=\"\"/></td>\n          <td class=\"formcolumncell\"><input type=\"checkbox\" name=\"" + seqPrefix + "urlregexpreorder\" value=\"yes\"/></td>\n          <td class=\"formcolumncell\"><input type=\"checkbox\" name=\"" + seqPrefix + "urlregexpjava\" value=\"yes\" checked=\"true\"/></td>\n          <td class=\"formcolumncell\"><input type=\"checkbox\" name=\"" + seqPrefix + "urlregexpasp\" value=\"yes\" checked=\"true\"/></td>\n          <td class=\"formcolumncell\"><input type=\"checkbox\" name=\"" + seqPrefix + "urlregexpphp\" value=\"yes\" checked=\"true\"/></td>\n          <td class=\"formcolumncell\"><input type=\"checkbox\" name=\"" + seqPrefix + "urlregexpbv\" value=\"yes\" checked=\"true\"/></td>\n        </tr>\n      </table>\n    </td>\n  </tr>\n</table>\n");
        } else {
            q = 0;
            l = 0;
            while (q < ds.getChildCount()) {
                if (!(specNode = ds.getChild(q++)).getType().equals("urlspec")) continue;
                regexpString = specNode.getAttributeValue("regexp");
                description = specNode.getAttributeValue("description");
                if (description == null) {
                    description = "";
                }
                if ((allowReorder = specNode.getAttributeValue("reorder")) == null || allowReorder.length() == 0) {
                    allowReorder = "no";
                }
                if ((allowJavaSessionRemoval = specNode.getAttributeValue("javasessionremoval")) == null || allowJavaSessionRemoval.length() == 0) {
                    allowJavaSessionRemoval = "no";
                }
                if ((allowASPSessionRemoval = specNode.getAttributeValue("aspsessionremoval")) == null || allowASPSessionRemoval.length() == 0) {
                    allowASPSessionRemoval = "no";
                }
                if ((allowPHPSessionRemoval = specNode.getAttributeValue("phpsessionremoval")) == null || allowPHPSessionRemoval.length() == 0) {
                    allowPHPSessionRemoval = "no";
                }
                if ((allowBVSessionRemoval = specNode.getAttributeValue("bvsessionremoval")) == null || allowBVSessionRemoval.length() == 0) {
                    allowBVSessionRemoval = "no";
                }
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "urlregexp_" + Integer.toString(l) + "\" value=\"" + Encoder.attributeEscape((String)regexpString) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "urlregexpdesc_" + Integer.toString(l) + "\" value=\"" + Encoder.attributeEscape((String)description) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "urlregexpreorder_" + Integer.toString(l) + "\" value=\"" + allowReorder + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "urlregexpjava_" + Integer.toString(l) + "\" value=\"" + allowJavaSessionRemoval + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "urlregexpasp_" + Integer.toString(l) + "\" value=\"" + allowASPSessionRemoval + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "urlregexpphp_" + Integer.toString(l) + "\" value=\"" + allowPHPSessionRemoval + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "urlregexpbv_" + Integer.toString(l) + "\" value=\"" + allowBVSessionRemoval + "\"/>\n");
                ++l;
            }
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "urlregexpcount\" value=\"" + Integer.toString(l) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "RSSConnector.URLMappings")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "rssop\" value=\"\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "rssindex\" value=\"\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "rssmapcount\" value=\"" + Integer.toString(regexp.size()) + "\"/>\n\n<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"4\"><hr/></td></tr>\n");
            for (i = 0; i < regexp.size(); ++i) {
                String prefix = seqPrefix + "rssregexp_" + Integer.toString(i) + "_";
                out.print("  <tr>\n    <td class=\"value\">\n      <a name=\"" + seqPrefix + "regexp_" + Integer.toString(i) + "\">\n        <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "RSSConnector.Remove") + "\" onclick='javascript:" + seqPrefix + "RemoveRegexp(" + Integer.toString(i) + ",\"" + seqPrefix + "regexp_" + Integer.toString(i) + "\")' alt=\"" + Messages.getAttributeString(locale, "RSSConnector.RemoveRegexp") + Integer.toString(i) + "\"/>\n      </a>\n    </td>\n    <td class=\"value\"><input type=\"hidden\" name=\"" + prefix + "match\" value=\"" + Encoder.attributeEscape((String)((String)regexp.get(i))) + "\"/>" + Encoder.bodyEscape((String)((String)regexp.get(i))) + "</td>\n    <td class=\"value\">--&gt;</td>\n    <td class=\"value\">\n");
                String match = (String)matchStrings.get(i);
                out.print("      <input type=\"hidden\" name=\"" + prefix + "map\" value=\"" + Encoder.attributeEscape((String)match) + "\"/>\n");
                if (match.length() == 0) {
                    out.print("      &lt;as is&gt;\n");
                } else {
                    out.print("      " + Encoder.bodyEscape((String)match) + "\n");
                }
                out.print("    </td>\n  </tr>\n");
            }
            out.print("  <tr>\n    <td class=\"value\"><a name=\"" + seqPrefix + "regexp_" + Integer.toString(i) + "\"><input type=\"button\" value=\"" + Messages.getAttributeString(locale, "RSSConnector.Add") + "\" onclick='javascript:" + seqPrefix + "AddRegexp(\"" + seqPrefix + "regexp_" + Integer.toString(i + 1) + "\")' alt=\"" + Messages.getAttributeString(locale, "RSSConnector.AddRegexp") + "\"/></a></td>\n    <td class=\"value\"><input type=\"text\" name=\"" + seqPrefix + "rssmatch\" size=\"16\" value=\"\"/></td>\n    <td class=\"value\">--&gt;</td>\n    <td class=\"value\"><input type=\"text\" name=\"" + seqPrefix + "rssmap\" size=\"16\" value=\"\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "rssmapcount\" value=\"" + Integer.toString(regexp.size()) + "\"/>\n");
            for (i = 0; i < regexp.size(); ++i) {
                String prefix = seqPrefix + "rssregexp_" + Integer.toString(i) + "_";
                String match = (String)matchStrings.get(i);
                out.print("<input type=\"hidden\" name=\"" + prefix + "match\" value=\"" + Encoder.attributeEscape((String)((String)regexp.get(i))) + "\"/>\n<input type=\"hidden\" name=\"" + prefix + "map\" value=\"" + Encoder.attributeEscape((String)match) + "\"/>\n");
            }
        }
        if (tabName.equals(Messages.getString(locale, "RSSConnector.TimeValues")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.FeedConnectTimeout") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"5\" name=\"" + seqPrefix + "feedtimeout\" value=\"" + Encoder.attributeEscape((String)Integer.toString(feedTimeoutValue)) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.DefaultFeedRefetchTime") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"5\" name=\"" + seqPrefix + "feedrefetch\" value=\"" + Encoder.attributeEscape((String)Integer.toString(feedRefetchValue)) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.MinimumFeedRefetchTime") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"5\" name=\"" + seqPrefix + "minfeedrefetch\" value=\"" + Encoder.attributeEscape((String)Integer.toString(minFeedRefetchValue)) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.BadFeedRefetchTime") + "</nobr></td>\n    <td class=\"value\">\n      <input type=\"hidden\" name=\"" + seqPrefix + "badfeedrefetch_present\" value=\"true\"/>\n      <input type=\"text\" size=\"5\" name=\"" + seqPrefix + "badfeedrefetch\" value=\"" + (badFeedRefetchValue == null ? "" : Encoder.attributeEscape((String)badFeedRefetchValue.toString())) + "\"/>\n    </td>\n  </tr>\n\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "feedtimeout\" value=\"" + Encoder.attributeEscape((String)Integer.toString(feedTimeoutValue)) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "feedrefetch\" value=\"" + Encoder.attributeEscape((String)Integer.toString(feedRefetchValue)) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "minfeedrefetch\" value=\"" + Encoder.attributeEscape((String)Integer.toString(minFeedRefetchValue)) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "badfeedrefetch_present\" value=\"true\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "badfeedrefetch\" value=\"" + (badFeedRefetchValue == null ? "" : Encoder.attributeEscape((String)badFeedRefetchValue.toString())) + "\"/>\n");
        }
        String dechromedMode = "none";
        String chromedMode = "use";
        i = 0;
        while (i < ds.getChildCount()) {
            if ((sn = ds.getChild(i++)).getType().equals("dechromedmode")) {
                dechromedMode = sn.getAttributeValue("mode");
                continue;
            }
            if (!sn.getType().equals("chromedmode")) continue;
            chromedMode = sn.getAttributeValue("mode");
        }
        if (tabName.equals(Messages.getString(locale, "RSSConnector.DechromedContent")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"1\"><hr/></td></tr>\n  <tr>\n    <td class=\"value\"><nobr><input type=\"radio\" name=\"" + seqPrefix + "dechromedmode\" value=\"none\" " + (dechromedMode.equals("none") ? "checked=\"true\"" : "") + "/>" + Messages.getBodyString(locale, "RSSConnector.NoDechromedContent") + "</nobr></td>\n  </tr>\n  <tr>\n    <td class=\"value\"><nobr><input type=\"radio\" name=\"" + seqPrefix + "dechromedmode\" value=\"description\" " + (dechromedMode.equals("description") ? "checked=\"true\"" : "") + "/>" + Messages.getBodyString(locale, "RSSConnector.DechromedContentIfPresentInDescriptionField") + "</nobr></td>\n  </tr>\n  <tr>\n    <td class=\"value\"><nobr><input type=\"radio\" name=\"" + seqPrefix + "dechromedmode\" value=\"content\" " + (dechromedMode.equals("content") ? "checked=\"true\"" : "") + "/>" + Messages.getBodyString(locale, "RSSConnector.DechromedContentIfPresentInContentField") + "</nobr></td>\n  </tr>\n  <tr>\n    <td class=\"separator\"><hr/></td>\n  </tr>\n  <tr>\n    <td class=\"value\"><nobr><input type=\"radio\" name=\"" + seqPrefix + "chromedmode\" value=\"use\" " + (chromedMode.equals("use") ? "checked=\"true\"" : "") + "/>" + Messages.getBodyString(locale, "RSSConnector.UseChromedContentIfNoDechromedContentFound") + "</nobr></td>\n  </tr>\n  <tr>\n    <td class=\"value\"><nobr><input type=\"radio\" name=\"" + seqPrefix + "chromedmode\" value=\"skip\" " + (chromedMode.equals("skip") ? "checked=\"true\"" : "") + "/>" + Messages.getBodyString(locale, "RSSConnector.NeverUseChromedContent") + "</nobr></td>\n  </tr>\n  <tr>\n    <td class=\"value\"><nobr><input type=\"radio\" name=\"" + seqPrefix + "chromedmode\" value=\"metadata\" " + (chromedMode.equals("metadata") ? "checked=\"true\"" : "") + "/>" + Messages.getBodyString(locale, "RSSConnector.NoContentMetadataOnly") + "</nobr></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "dechromedmode\" value=\"" + Encoder.attributeEscape((String)dechromedMode) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "chromedmode\" value=\"" + Encoder.attributeEscape((String)chromedMode) + "\"/>\n");
        }
        i = 0;
        if (tabName.equals(Messages.getString(locale, "RSSConnector.Security")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
            i = 0;
            int k = 0;
            while (i < ds.getChildCount()) {
                if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
                accessDescription = "_" + Integer.toString(k);
                String accessOpName = seqPrefix + "accessop" + accessDescription;
                String token = sn.getAttributeValue("token");
                out.print("  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"" + accessOpName + "\" value=\"\"/>\n      <input type=\"hidden\" name=\"" + seqPrefix + "spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n      <a name=\"" + seqPrefix + "token_" + Integer.toString(k) + "\">\n        <input type=\"button\" value=\"Delete\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + accessOpName + "\",\"Delete\",\"" + seqPrefix + "token_" + Integer.toString(k) + "\")' alt=\"" + Messages.getAttributeString(locale, "RSSConnector.DeleteToken") + Integer.toString(k) + "\"/>\n      </a>&nbsp;\n    </td>\n    <td class=\"value\">\n      " + Encoder.bodyEscape((String)token) + "\n    </td>\n  </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("  <tr>\n    <td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "RSSConnector.NoAccessTokensPresent") + "</td>\n  </tr>\n");
            }
            out.print("  <tr><td class=\"lightseparator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"" + seqPrefix + "tokencount\" value=\"" + Integer.toString(k) + "\"/>\n      <input type=\"hidden\" name=\"" + seqPrefix + "accessop\" value=\"\"/>\n      <a name=\"" + seqPrefix + "token_" + Integer.toString(k) + "\">\n        <input type=\"button\" value=\"Add\" onClick='Javascript:" + seqPrefix + "SpecAddToken(\"" + seqPrefix + "token_" + Integer.toString(k + 1) + "\")' alt=\"" + Messages.getAttributeString(locale, "RSSConnector.AddAccessToken") + "\"/>\n      </a>&nbsp;\n    </td>\n    <td class=\"value\">\n      <input type=\"text\" size=\"30\" name=\"" + seqPrefix + "spectoken\" value=\"\"/>\n    </td>\n  </tr>\n</table>\n");
        } else {
            i = 0;
            int k = 0;
            while (i < ds.getChildCount()) {
                if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
                accessDescription = "_" + Integer.toString(k);
                String token = sn.getAttributeValue("token");
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n");
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "tokencount\" value=\"" + Integer.toString(k) + "\"/>\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        SpecificationNode sn;
        String rssop;
        String chromedMode;
        String dechromedMode;
        SpecificationNode node;
        SpecificationNode sn2;
        String badFeedRefetchValuePresent;
        String minFeedRefetchValue;
        String feedRefetchValue;
        String feedTimeoutValue;
        String exclusions;
        SpecificationNode sn3;
        String urlRegexpCount;
        String rssURLSequence;
        SpecificationNode node2;
        SpecificationNode sn4;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String value = variableContext.getParameter(seqPrefix + "rssmapcount");
        if (value != null) {
            int mapsize = Integer.parseInt(value);
            int j = 0;
            while (j < ds.getChildCount()) {
                sn4 = ds.getChild(j);
                if (sn4.getType().equals("map")) {
                    ds.removeChild(j);
                    continue;
                }
                ++j;
            }
            for (j = 0; j < mapsize; ++j) {
                String prefix = seqPrefix + "rssregexp_" + Integer.toString(j) + "_";
                String match = variableContext.getParameter(prefix + "match");
                String map = variableContext.getParameter(prefix + "map");
                if (map == null) {
                    map = "";
                }
                node2 = new SpecificationNode("map");
                node2.setAttribute("match", match);
                node2.setAttribute("map", map);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node2);
            }
        }
        if ((rssURLSequence = variableContext.getParameter(seqPrefix + "rssurls")) != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                sn4 = ds.getChild(i);
                if (sn4.getType().equals("feed")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            try (StringReader str = new StringReader(rssURLSequence);
                 BufferedReader is = new BufferedReader(str);){
                String nextString;
                while ((nextString = is.readLine()) != null) {
                    if (nextString.length() == 0) continue;
                    node2 = new SpecificationNode("feed");
                    node2.setAttribute("url", nextString);
                    ds.addChild(ds.getChildCount(), (ConfigurationNode)node2);
                }
            }
            catch (IOException e) {
                throw new ManifoldCFException("IO error: " + e.getMessage(), (Throwable)e);
            }
        }
        if ((urlRegexpCount = variableContext.getParameter(seqPrefix + "urlregexpcount")) != null && urlRegexpCount.length() > 0) {
            SpecificationNode newSn;
            String bvSession;
            String phpSession;
            String aspSession;
            String javaSession;
            String reorder;
            String regexpDescription;
            String regexp;
            int regexpCount = Integer.parseInt(urlRegexpCount);
            int j = 0;
            while (j < ds.getChildCount()) {
                sn3 = ds.getChild(j);
                if (sn3.getType().equals("urlspec")) {
                    ds.removeChild(j);
                    continue;
                }
                ++j;
            }
            String operation = variableContext.getParameter(seqPrefix + "urlregexpop");
            if (operation == null) {
                operation = "Continue";
            }
            int opIndex = -1;
            if (operation.equals("Delete")) {
                opIndex = Integer.parseInt(variableContext.getParameter(seqPrefix + "urlregexpnumber"));
            }
            for (j = 0; j < regexpCount; ++j) {
                if (operation.equals("Delete") && j == opIndex) continue;
                regexp = variableContext.getParameter(seqPrefix + "urlregexp_" + Integer.toString(j));
                regexpDescription = variableContext.getParameter(seqPrefix + "urlregexpdesc_" + Integer.toString(j));
                reorder = variableContext.getParameter(seqPrefix + "urlregexpreorder_" + Integer.toString(j));
                javaSession = variableContext.getParameter(seqPrefix + "urlregexpjava_" + Integer.toString(j));
                aspSession = variableContext.getParameter(seqPrefix + "urlregexpasp_" + Integer.toString(j));
                phpSession = variableContext.getParameter(seqPrefix + "urlregexpphp_" + Integer.toString(j));
                bvSession = variableContext.getParameter(seqPrefix + "urlregexpbv_" + Integer.toString(j));
                newSn = new SpecificationNode("urlspec");
                newSn.setAttribute("regexp", regexp);
                if (regexpDescription != null && regexpDescription.length() > 0) {
                    newSn.setAttribute("description", regexpDescription);
                }
                if (reorder != null && reorder.length() > 0) {
                    newSn.setAttribute("reorder", reorder);
                }
                if (javaSession != null && javaSession.length() > 0) {
                    newSn.setAttribute("javasessionremoval", javaSession);
                }
                if (aspSession != null && aspSession.length() > 0) {
                    newSn.setAttribute("aspsessionremoval", aspSession);
                }
                if (phpSession != null && phpSession.length() > 0) {
                    newSn.setAttribute("phpsessionremoval", phpSession);
                }
                if (bvSession != null && bvSession.length() > 0) {
                    newSn.setAttribute("bvsessionremoval", bvSession);
                }
                ds.addChild(ds.getChildCount(), (ConfigurationNode)newSn);
            }
            if (operation.equals("Add")) {
                regexp = variableContext.getParameter(seqPrefix + "urlregexp");
                regexpDescription = variableContext.getParameter(seqPrefix + "urlregexpdesc");
                reorder = variableContext.getParameter(seqPrefix + "urlregexpreorder");
                javaSession = variableContext.getParameter(seqPrefix + "urlregexpjava");
                aspSession = variableContext.getParameter(seqPrefix + "urlregexpasp");
                phpSession = variableContext.getParameter(seqPrefix + "urlregexpphp");
                bvSession = variableContext.getParameter(seqPrefix + "urlregexpbv");
                newSn = new SpecificationNode("urlspec");
                newSn.setAttribute("regexp", regexp);
                if (regexpDescription != null && regexpDescription.length() > 0) {
                    newSn.setAttribute("description", regexpDescription);
                }
                if (reorder != null && reorder.length() > 0) {
                    newSn.setAttribute("reorder", reorder);
                }
                if (javaSession != null && javaSession.length() > 0) {
                    newSn.setAttribute("javasessionremoval", javaSession);
                }
                if (aspSession != null && aspSession.length() > 0) {
                    newSn.setAttribute("aspsessionremoval", aspSession);
                }
                if (phpSession != null && phpSession.length() > 0) {
                    newSn.setAttribute("phpsessionremoval", phpSession);
                }
                if (bvSession != null && bvSession.length() > 0) {
                    newSn.setAttribute("bvsessionremoval", bvSession);
                }
                ds.addChild(ds.getChildCount(), (ConfigurationNode)newSn);
            }
        }
        if ((exclusions = variableContext.getParameter(seqPrefix + "exclusions")) != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                sn3 = ds.getChild(i);
                if (sn3.getType().equals("excludes")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode cn = new SpecificationNode("excludes");
            cn.setValue(exclusions);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)cn);
        }
        if ((feedTimeoutValue = variableContext.getParameter(seqPrefix + "feedtimeout")) != null && feedTimeoutValue.length() > 0) {
            int j = 0;
            while (j < ds.getChildCount()) {
                SpecificationNode sn5 = ds.getChild(j);
                if (sn5.getType().equals("feedtimeout")) {
                    ds.removeChild(j);
                    continue;
                }
                ++j;
            }
            SpecificationNode node3 = new SpecificationNode("feedtimeout");
            node3.setAttribute("value", feedTimeoutValue);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node3);
        }
        if ((feedRefetchValue = variableContext.getParameter(seqPrefix + "feedrefetch")) != null && feedRefetchValue.length() > 0) {
            int j = 0;
            while (j < ds.getChildCount()) {
                SpecificationNode sn6 = ds.getChild(j);
                if (sn6.getType().equals("feedrescan")) {
                    ds.removeChild(j);
                    continue;
                }
                ++j;
            }
            SpecificationNode node4 = new SpecificationNode("feedrescan");
            node4.setAttribute("value", feedRefetchValue);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node4);
        }
        if ((minFeedRefetchValue = variableContext.getParameter(seqPrefix + "minfeedrefetch")) != null && minFeedRefetchValue.length() > 0) {
            int j = 0;
            while (j < ds.getChildCount()) {
                SpecificationNode sn7 = ds.getChild(j);
                if (sn7.getType().equals("minfeedrescan")) {
                    ds.removeChild(j);
                    continue;
                }
                ++j;
            }
            SpecificationNode node5 = new SpecificationNode("minfeedrescan");
            node5.setAttribute("value", minFeedRefetchValue);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node5);
        }
        if ((badFeedRefetchValuePresent = variableContext.getParameter(seqPrefix + "badfeedrefetch_present")) != null && badFeedRefetchValuePresent.length() > 0) {
            String badFeedRefetchValue = variableContext.getParameter(seqPrefix + "badfeedrefetch");
            int k = 0;
            while (k < ds.getChildCount()) {
                sn2 = ds.getChild(k);
                if (sn2.getType().equals("badfeedrescan")) {
                    ds.removeChild(k);
                    continue;
                }
                ++k;
            }
            if (badFeedRefetchValue != null && badFeedRefetchValue.length() > 0) {
                node = new SpecificationNode("badfeedrescan");
                node.setAttribute("value", badFeedRefetchValue);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((dechromedMode = variableContext.getParameter(seqPrefix + "dechromedmode")) != null && dechromedMode.length() > 0) {
            int j = 0;
            while (j < ds.getChildCount()) {
                sn2 = ds.getChild(j);
                if (sn2.getType().equals("dechromedmode")) {
                    ds.removeChild(j);
                    continue;
                }
                ++j;
            }
            node = new SpecificationNode("dechromedmode");
            node.setAttribute("mode", dechromedMode);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
        }
        if ((chromedMode = variableContext.getParameter(seqPrefix + "chromedmode")) != null && chromedMode.length() > 0) {
            int j = 0;
            while (j < ds.getChildCount()) {
                SpecificationNode sn8 = ds.getChild(j);
                if (sn8.getType().equals("chromedmode")) {
                    ds.removeChild(j);
                    continue;
                }
                ++j;
            }
            SpecificationNode node6 = new SpecificationNode("chromedmode");
            node6.setAttribute("mode", chromedMode);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node6);
        }
        if ((rssop = variableContext.getParameter(seqPrefix + "rssop")) != null && rssop.equals("Add")) {
            String match = variableContext.getParameter(seqPrefix + "rssmatch");
            String map = variableContext.getParameter(seqPrefix + "rssmap");
            SpecificationNode node7 = new SpecificationNode("map");
            node7.setAttribute("match", match);
            node7.setAttribute("map", map);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node7);
        } else if (rssop != null && rssop.equals("Delete")) {
            int index = Integer.parseInt(variableContext.getParameter(seqPrefix + "rssindex"));
            for (int j = 0; j < ds.getChildCount(); ++j) {
                sn = ds.getChild(j);
                if (!sn.getType().equals("map")) continue;
                if (index == 0) {
                    ds.removeChild(j);
                    break;
                }
                --index;
            }
        }
        String xc = variableContext.getParameter(seqPrefix + "tokencount");
        if (xc != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                sn = ds.getChild(i);
                if (sn.getType().equals("access")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int accessCount = Integer.parseInt(xc);
            i = 0;
            while (i < accessCount) {
                String accessDescription = "_" + Integer.toString(i);
                String accessOpName = seqPrefix + "accessop" + accessDescription;
                xc = variableContext.getParameter(accessOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String accessSpec = variableContext.getParameter(seqPrefix + "spectoken" + accessDescription);
                SpecificationNode node8 = new SpecificationNode("access");
                node8.setAttribute("token", accessSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node8);
                ++i;
            }
            String op = variableContext.getParameter(seqPrefix + "accessop");
            if (op != null && op.equals("Add")) {
                String accessspec = variableContext.getParameter(seqPrefix + "spectoken");
                SpecificationNode node9 = new SpecificationNode("access");
                node9.setAttribute("token", accessspec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node9);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        SpecificationNode sn;
        SpecificationNode sn2;
        String exclusions = "";
        out.print("<table class=\"displaytable\">\n");
        int i = 0;
        boolean seenAny = false;
        while (i < ds.getChildCount()) {
            SpecificationNode sn3;
            if ((sn3 = ds.getChild(i++)).getType().equals("feed")) {
                if (!seenAny) {
                    out.print("  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.RSSUrls") + "</nobr></td>\n    <td class=\"value\">\n");
                    seenAny = true;
                }
                out.print("      <nobr>" + Encoder.bodyEscape((String)sn3.getAttributeValue("url")) + "</nobr><br/>\n");
                continue;
            }
            if (!sn3.getType().equals("excludes") || (exclusions = sn3.getValue()) != null) continue;
            exclusions = "";
        }
        if (seenAny) {
            out.print("    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"2\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.NoRSSUrlsSpecified") + "</nobr></td></tr>\n");
        }
        out.print("  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        i = 0;
        int l = 0;
        seenAny = false;
        while (i < ds.getChildCount()) {
            String allowBVSessionRemoval;
            String allowPHPSessionRemoval;
            String allowASPSessionRemoval;
            String allowJavaSessionRemoval;
            String allowReorder;
            if (!(sn2 = ds.getChild(i++)).getType().equals("urlspec")) continue;
            if (l == 0) {
                out.print("  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.URLCanonicalization") + "</nobr></td>\n    <td class=\"value\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.URLRegexp") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.Description") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.Reorder") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.RemoveJSPSessions") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.RemoveASPSessions") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.RemovePHPSessions") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.RemoveBVSessions") + "</nobr></td>\n        </tr>\n");
            }
            String regexpString = sn2.getAttributeValue("regexp");
            String description = sn2.getAttributeValue("description");
            if (description == null) {
                description = "";
            }
            if ((allowReorder = sn2.getAttributeValue("reorder")) == null || allowReorder.length() == 0) {
                allowReorder = "no";
            }
            if ((allowJavaSessionRemoval = sn2.getAttributeValue("javasessionremoval")) == null || allowJavaSessionRemoval.length() == 0) {
                allowJavaSessionRemoval = "no";
            }
            if ((allowASPSessionRemoval = sn2.getAttributeValue("aspsessionremoval")) == null || allowASPSessionRemoval.length() == 0) {
                allowASPSessionRemoval = "no";
            }
            if ((allowPHPSessionRemoval = sn2.getAttributeValue("phpsessionremoval")) == null || allowPHPSessionRemoval.length() == 0) {
                allowPHPSessionRemoval = "no";
            }
            if ((allowBVSessionRemoval = sn2.getAttributeValue("bvsessionremoval")) == null || allowBVSessionRemoval.length() == 0) {
                allowBVSessionRemoval = "no";
            }
            out.print("        <tr class=\"" + (l % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n          <td class=\"formcolumncell\"><nobr>" + Encoder.bodyEscape((String)regexpString) + "</nobr></td>\n          <td class=\"formcolumncell\">" + Encoder.bodyEscape((String)description) + "</td>\n          <td class=\"formcolumncell\"><nobr>" + allowReorder + "</nobr></td>\n          <td class=\"formcolumncell\"><nobr>" + allowJavaSessionRemoval + "</nobr></td>\n          <td class=\"formcolumncell\"><nobr>" + allowASPSessionRemoval + "</nobr></td>\n          <td class=\"formcolumncell\"><nobr>" + allowPHPSessionRemoval + "</nobr></td>\n          <td class=\"formcolumncell\"><nobr>" + allowBVSessionRemoval + "</nobr></td>\n        </tr>\n");
            ++l;
        }
        if (l > 0) {
            out.print("      </table>\n    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"2\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.NoCanonicalizationSpecified") + "</nobr></td></tr>\n");
        }
        out.print("  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        i = 0;
        seenAny = false;
        while (i < ds.getChildCount()) {
            if (!(sn2 = ds.getChild(i++)).getType().equals("map")) continue;
            if (!seenAny) {
                out.print("  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.URLMappingsColon") + "</nobr></td>\n    <td class=\"value\">\n");
                seenAny = true;
            }
            String match = sn2.getAttributeValue("match");
            String map = sn2.getAttributeValue("map");
            out.print("      <nobr>" + Encoder.bodyEscape((String)match) + "</nobr>\n");
            if (map != null && map.length() > 0) {
                out.print("      &nbsp;--&gt;&nbsp;<nobr>" + Encoder.bodyEscape((String)map) + "</nobr>\n");
            }
            out.print("      <br/>\n");
        }
        if (seenAny) {
            out.print("    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"2\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.NoMappingsSpecifiedWillAcceptAllUrls") + "</nobr></td></tr>\n");
        }
        out.print("  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.Exclude") + "</nobr></td>\n    <td class=\"value\">\n");
        try (StringReader str = new StringReader(exclusions);
             BufferedReader is = new BufferedReader(str);){
            String nextString;
            while ((nextString = is.readLine()) != null) {
                if (nextString.length() == 0) continue;
                out.print("      <nobr>" + Encoder.bodyEscape((String)nextString) + "</nobr><br/>\n");
            }
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO error: " + e.getMessage(), (Throwable)e);
        }
        out.print("    </td>\n  </tr>\n");
        out.print("  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        String feedTimeoutValue = "60";
        String feedRefetchValue = "60";
        String minFeedRefetchValue = "15";
        String badFeedRefetchValue = null;
        String dechromedMode = "none";
        String chromedMode = "use";
        i = 0;
        while (i < ds.getChildCount()) {
            if ((sn = ds.getChild(i++)).getType().equals("feedtimeout")) {
                feedTimeoutValue = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("feedrescan")) {
                feedRefetchValue = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("minfeedrescan")) {
                minFeedRefetchValue = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("badfeedrescan")) {
                badFeedRefetchValue = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("dechromedmode")) {
                dechromedMode = sn.getAttributeValue("mode");
                continue;
            }
            if (!sn.getType().equals("chromedmode")) continue;
            chromedMode = sn.getAttributeValue("mode");
        }
        out.print("  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.FeedConnectionTimeout") + "</nobr></td>\n    <td class=\"value\">" + Encoder.bodyEscape((String)feedTimeoutValue) + "</td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.DefaultFeedRescanInterval") + "</nobr></td>\n    <td class=\"value\">" + Encoder.bodyEscape((String)feedRefetchValue) + "</td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.MinimumFeedRescanInterval") + "</nobr></td>\n    <td class=\"value\">" + Encoder.bodyEscape((String)minFeedRefetchValue) + "</td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.BadFeedRescanInterval") + "</nobr></td>\n    <td class=\"value\">" + (badFeedRefetchValue == null ? "(Default feed rescan value)" : Encoder.bodyEscape((String)badFeedRefetchValue)) + "</td>\n  </tr>\n      \n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.DechromedContentSource") + "</nobr></td>\n    <td class=\"value\">" + Encoder.bodyEscape((String)dechromedMode) + "</td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.ChromedContent") + "</nobr></td>\n    <td class=\"value\">" + Encoder.bodyEscape((String)chromedMode) + "</td>\n  </tr>\n\n");
        out.print("  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        seenAny = false;
        i = 0;
        while (i < ds.getChildCount()) {
            if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
            if (!seenAny) {
                out.print("  <tr><td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.AccessTokens") + "</nobr></td>\n    <td class=\"value\">\n");
                seenAny = true;
            }
            String token = sn.getAttributeValue("token");
            out.print("      " + Encoder.bodyEscape((String)token) + "<br/>\n");
        }
        if (seenAny) {
            out.print("    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"2\"><nobr>" + Messages.getBodyString(locale, "RSSConnector.NoAccessTokensSpecified") + "</nobr></td></tr>\n");
        }
        out.print("</table>\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRSSFeedSAX(String documentIdentifier, IProcessActivity activities, Filter filter) throws ManifoldCFException, ServiceInterruption {
        try {
            InputStream is = cache.getData(documentIdentifier);
            if (is == null) {
                Logging.connectors.error((Object)("RSS: Document '" + documentIdentifier + "' should be in cache but isn't"));
                return;
            }
            try {
                Parser p = new Parser();
                XMLFuzzyHierarchicalParseState x = new XMLFuzzyHierarchicalParseState();
                OuterContextClass c = new OuterContextClass(x, documentIdentifier, activities, filter);
                x.setContext((XMLParsingContext)c);
                try {
                    p.parseWithCharsetDetection(null, is, (CharacterReceiver)x);
                    c.checkIfValidFeed();
                    c.setDefaultRescanTimeIfNeeded();
                }
                finally {
                    x.cleanup();
                }
            }
            finally {
                is.close();
            }
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("Socket timeout error: " + e.getMessage(), (Throwable)e);
        }
        catch (ConnectTimeoutException e) {
            throw new ManifoldCFException("Socket connect timeout error: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO error: " + e.getMessage(), (Throwable)e);
        }
    }

    public int getMaxDocumentRequest() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThrottledFetcher getFetcher() {
        Map<String, ThrottledFetcher> map = fetcherMap;
        synchronized (map) {
            ThrottledFetcher tf = fetcherMap.get(this.throttleGroupName);
            if (tf == null) {
                tf = new ThrottledFetcher();
                fetcherMap.put(this.throttleGroupName, tf);
            }
            return tf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<String> stringToArray(String input) {
        ArrayList<String> list = new ArrayList<String>();
        try (StringReader str = new StringReader(input);
             BufferedReader is = new BufferedReader(str);){
            String nextString;
            while ((nextString = is.readLine()) != null) {
                if (nextString.length() == 0) continue;
                nextString.trim();
                if (nextString.startsWith("#")) continue;
                list.add(nextString);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    protected static void compileList(List<Pattern> output, List<String> input) throws ManifoldCFException {
        for (String inputString : input) {
            try {
                output.add(Pattern.compile(inputString));
            }
            catch (PatternSyntaxException e) {
                throw new ManifoldCFException("Mapping regular expression '" + inputString + "' is illegal: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Robots getRobots(ThrottledFetcher fetcher) {
        Map map = robotsMap;
        synchronized (map) {
            Robots r = (Robots)robotsMap.get(this.throttleGroupName);
            if (r == null) {
                r = new Robots(fetcher);
                robotsMap.put(this.throttleGroupName, r);
            }
            return r;
        }
    }

    static {
        understoodProtocols.put("http", "http");
        understoodProtocols.put("https", "https");
        xmlContentTypes = new HashSet<String>();
        xmlContentTypes.add("text/xml");
        xmlContentTypes.add("application/rss+xml");
        xmlContentTypes.add("application/xml");
        xmlContentTypes.add("application/atom+xml");
        xmlContentTypes.add("application/xhtml+xml");
        xmlContentTypes.add("text/XML");
        xmlContentTypes.add("application/rdf+xml");
        xmlContentTypes.add("text/application");
        xmlContentTypes.add("XML");
    }

    protected static class Filter {
        protected final MappingRules mappings = new MappingRules();
        protected final Set<String> seeds;
        protected Integer defaultRescanInterval = null;
        protected Integer minimumRescanInterval = null;
        protected Integer badFeedRescanInterval = null;
        protected int dechromedContentMode = 0;
        protected int chromedContentMode = 0;
        protected int feedTimeoutValue = 60000;
        protected final Set<String> acls = new HashSet<String>();
        protected final CanonicalizationPolicies canonicalizationPolicies = new CanonicalizationPolicies();
        protected final List<Pattern> excludePatterns = new ArrayList<Pattern>();

        public Filter(Specification spec, boolean warnOnBadSeed) throws ManifoldCFException {
            SpecificationNode n;
            String excludes = "";
            int initialSize = spec.getChildCount();
            if (initialSize == 0) {
                initialSize = 1;
            }
            this.seeds = new HashSet<String>(initialSize * 3 >> 1);
            int i = 0;
            while (i < spec.getChildCount()) {
                String reorder;
                if ((n = spec.getChild(i++)).getType().equals("map")) {
                    Pattern p;
                    String match = n.getAttributeValue("match");
                    String map = n.getAttributeValue("map");
                    if (match == null || match.length() <= 0) continue;
                    try {
                        p = Pattern.compile(match);
                    }
                    catch (PatternSyntaxException e) {
                        throw new ManifoldCFException("Regular expression '" + match + "' is illegal: " + e.getMessage(), (Throwable)e);
                    }
                    if (map == null) {
                        map = "";
                    }
                    this.mappings.add(new MappingRule(p, map));
                    continue;
                }
                if (n.getType().equals("excludes")) {
                    excludes = n.getValue();
                    if (excludes != null) continue;
                    excludes = "";
                    continue;
                }
                if (!n.getType().equals("urlspec")) continue;
                String urlRegexp = n.getAttributeValue("regexp");
                if (urlRegexp == null) {
                    urlRegexp = "";
                }
                boolean reorderValue = (reorder = n.getAttributeValue("reorder")) == null ? false : reorder.equals("yes");
                String javaSession = n.getAttributeValue("javasessionremoval");
                boolean javaSessionValue = javaSession == null ? false : javaSession.equals("yes");
                String aspSession = n.getAttributeValue("aspsessionremoval");
                boolean aspSessionValue = aspSession == null ? false : aspSession.equals("yes");
                String phpSession = n.getAttributeValue("phpsessionremoval");
                boolean phpSessionValue = phpSession == null ? false : phpSession.equals("yes");
                String bvSession = n.getAttributeValue("bvsessionremoval");
                boolean bvSessionValue = bvSession == null ? false : bvSession.equals("yes");
                try {
                    this.canonicalizationPolicies.addRule(new CanonicalizationPolicy(Pattern.compile(urlRegexp), reorderValue, javaSessionValue, aspSessionValue, phpSessionValue, bvSessionValue));
                }
                catch (PatternSyntaxException e) {
                    throw new ManifoldCFException("Canonicalization regular expression '" + urlRegexp + "' is illegal: " + e.getMessage(), (Throwable)e);
                }
            }
            RSSConnector.compileList(this.excludePatterns, RSSConnector.stringToArray(excludes));
            i = 0;
            while (i < spec.getChildCount()) {
                String mode;
                String interval;
                if ((n = spec.getChild(i++)).getType().equals("feed")) {
                    String rssURL = n.getAttributeValue("url");
                    if (rssURL == null || rssURL.length() <= 0) continue;
                    String canonicalURL = RSSConnector.makeDocumentIdentifier(this.canonicalizationPolicies, null, rssURL);
                    if (canonicalURL != null) {
                        this.seeds.add(canonicalURL);
                        continue;
                    }
                    if (!warnOnBadSeed) continue;
                    Logging.connectors.warn((Object)("RSS: Illegal seed feed '" + rssURL + "'"));
                    continue;
                }
                if (n.getType().equals("access")) {
                    String token = n.getAttributeValue("token");
                    this.acls.add(token);
                    continue;
                }
                if (n.getType().equals("feedrescan")) {
                    interval = n.getAttributeValue("value");
                    if (interval == null || interval.length() <= 0) continue;
                    try {
                        this.defaultRescanInterval = new Integer(interval);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                    }
                }
                if (n.getType().equals("minfeedrescan")) {
                    interval = n.getAttributeValue("value");
                    if (interval == null || interval.length() <= 0) continue;
                    try {
                        this.minimumRescanInterval = new Integer(interval);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                    }
                }
                if (n.getType().equals("badfeedrescan")) {
                    interval = n.getAttributeValue("value");
                    if (interval == null || interval.length() <= 0) continue;
                    try {
                        this.badFeedRescanInterval = new Integer(interval);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                    }
                }
                if (n.getType().equals("feedtimeout")) {
                    String value = n.getAttributeValue("value");
                    if (value == null || value.length() <= 0) continue;
                    try {
                        this.feedTimeoutValue = Integer.parseInt(value) * 1000;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                    }
                }
                if (n.getType().equals("dechromedmode")) {
                    mode = n.getAttributeValue("mode");
                    if (mode == null || mode.length() <= 0) continue;
                    if (mode.equals("none")) {
                        this.dechromedContentMode = 0;
                        continue;
                    }
                    if (mode.equals("description")) {
                        this.dechromedContentMode = 1;
                        continue;
                    }
                    if (!mode.equals("content")) continue;
                    this.dechromedContentMode = 2;
                    continue;
                }
                if (!n.getType().equals("chromedmode") || (mode = n.getAttributeValue("mode")) == null || mode.length() <= 0) continue;
                if (mode.equals("use")) {
                    this.chromedContentMode = 0;
                    continue;
                }
                if (mode.equals("skip")) {
                    this.chromedContentMode = 1;
                    continue;
                }
                if (!mode.equals("metadata")) continue;
                this.chromedContentMode = 2;
            }
        }

        public boolean isSeed(String canonicalUrl) {
            return this.seeds.contains(canonicalUrl);
        }

        public Iterator<String> getSeeds() {
            return this.seeds.iterator();
        }

        public String[] getAcls() {
            String[] rval = new String[this.acls.size()];
            Iterator<String> iter = this.acls.iterator();
            int i = 0;
            while (iter.hasNext()) {
                rval[i++] = iter.next();
            }
            return rval;
        }

        public int getFeedTimeoutValue() {
            return this.feedTimeoutValue;
        }

        public int getDechromedContentMode() {
            return this.dechromedContentMode;
        }

        public int getChromedContentMode() {
            return this.chromedContentMode;
        }

        public Long getDefaultRescanTime(long currentTime) {
            if (this.defaultRescanInterval == null) {
                return null;
            }
            return new Long((long)this.defaultRescanInterval.intValue() * 60000L + currentTime);
        }

        public Long getMinimumRescanTime(long currentTime) {
            if (this.minimumRescanInterval == null) {
                return null;
            }
            return new Long((long)this.minimumRescanInterval.intValue() * 60000L + currentTime);
        }

        public Long getBadFeedRescanTime(long currentTime) {
            if (this.badFeedRescanInterval == null) {
                return null;
            }
            return new Long((long)this.badFeedRescanInterval.intValue() * 60000L + currentTime);
        }

        public boolean isLegalURL(String url) {
            if (this.seeds.contains(url)) {
                return true;
            }
            if (!this.mappings.isMatch(url)) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("RSS: Url '" + url + "' is illegal because it did not match a mapping rule"));
                }
                return false;
            }
            for (Pattern p : this.excludePatterns) {
                Matcher m = p.matcher(url);
                if (!m.find()) continue;
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("RSS: Url '" + url + "' is illegal because exclude pattern '" + p.toString() + "' matched it"));
                }
                return false;
            }
            return true;
        }

        public String mapDocumentURL(String url) throws ManifoldCFException {
            if (this.seeds.contains(url)) {
                return null;
            }
            return this.mappings.map(url);
        }

        public CanonicalizationPolicies getCanonicalizationPolicies() {
            return this.canonicalizationPolicies;
        }
    }

    protected static class MappingRules {
        protected final List<MappingRule> mappings = new ArrayList<MappingRule>();

        public void add(MappingRule rule) {
            this.mappings.add(rule);
        }

        public boolean isMatch(String url) {
            if (this.mappings.size() == 0) {
                return true;
            }
            for (MappingRule p : this.mappings) {
                if (!p.checkMatch(url)) continue;
                return true;
            }
            return false;
        }

        public String map(String url) throws ManifoldCFException {
            if (this.mappings.size() == 0) {
                return url;
            }
            for (MappingRule p : this.mappings) {
                String rval = p.map(url);
                if (rval == null) continue;
                return rval;
            }
            return null;
        }
    }

    protected static class MappingRule {
        protected final Pattern matchPattern;
        protected final String evalExpression;

        public MappingRule(Pattern matchPattern, String evalExpression) {
            this.matchPattern = matchPattern;
            this.evalExpression = evalExpression;
        }

        public boolean checkMatch(String url) {
            Matcher matcher = this.matchPattern.matcher(url);
            return matcher.matches();
        }

        public String map(String url) throws ManifoldCFException {
            EvaluatorToken t;
            Matcher matcher = this.matchPattern.matcher(url);
            if (!matcher.matches()) {
                return null;
            }
            if (this.evalExpression == null || this.evalExpression.length() == 0) {
                return url;
            }
            StringBuilder sb = new StringBuilder();
            EvaluatorTokenStream et = new EvaluatorTokenStream(this.evalExpression);
            block11: while ((t = et.peek()) != null) {
                switch (t.getType()) {
                    case 2: {
                        et.advance();
                        continue block11;
                    }
                    case 0: {
                        et.advance();
                        String groupValue = matcher.group(t.getGroupNumber());
                        switch (t.getGroupStyle()) {
                            case 0: {
                                sb.append(groupValue);
                                continue block11;
                            }
                            case 1: {
                                sb.append(groupValue.toLowerCase(Locale.ROOT));
                                continue block11;
                            }
                            case 2: {
                                sb.append(groupValue.toUpperCase(Locale.ROOT));
                                continue block11;
                            }
                            case 3: {
                                if (groupValue.length() <= 0) continue block11;
                                sb.append(groupValue.substring(0, 1).toUpperCase(Locale.ROOT));
                                sb.append(groupValue.substring(1).toLowerCase(Locale.ROOT));
                                continue block11;
                            }
                        }
                        throw new ManifoldCFException("Illegal group style");
                    }
                    case 1: {
                        et.advance();
                        sb.append(t.getTextValue());
                        continue block11;
                    }
                }
                throw new ManifoldCFException("Illegal token type");
            }
            return sb.toString();
        }
    }

    protected static class CanonicalizationPolicies {
        protected final List<CanonicalizationPolicy> rules = new ArrayList<CanonicalizationPolicy>();

        public void addRule(CanonicalizationPolicy rule) {
            this.rules.add(rule);
        }

        public CanonicalizationPolicy findMatch(String url) {
            for (CanonicalizationPolicy rule : this.rules) {
                if (!rule.checkMatch(url)) continue;
                return rule;
            }
            return null;
        }
    }

    protected static class CanonicalizationPolicy {
        protected final Pattern matchPattern;
        protected final boolean reorder;
        protected final boolean removeJavaSession;
        protected final boolean removeAspSession;
        protected final boolean removePhpSession;
        protected final boolean removeBVSession;

        public CanonicalizationPolicy(Pattern matchPattern, boolean reorder, boolean removeJavaSession, boolean removeAspSession, boolean removePhpSession, boolean removeBVSession) {
            this.matchPattern = matchPattern;
            this.reorder = reorder;
            this.removeJavaSession = removeJavaSession;
            this.removeAspSession = removeAspSession;
            this.removePhpSession = removePhpSession;
            this.removeBVSession = removeBVSession;
        }

        public boolean checkMatch(String url) {
            Matcher matcher = this.matchPattern.matcher(url);
            return matcher.find();
        }

        public boolean canReorder() {
            return this.reorder;
        }

        public boolean canRemoveJavaSession() {
            return this.removeJavaSession;
        }

        public boolean canRemoveAspSession() {
            return this.removeAspSession;
        }

        public boolean canRemovePhpSession() {
            return this.removePhpSession;
        }

        public boolean canRemoveBvSession() {
            return this.removeBVSession;
        }
    }

    protected static class EvaluatorTokenStream {
        protected String text;
        protected int pos;
        protected EvaluatorToken token = null;

        public EvaluatorTokenStream(String text) {
            this.text = text;
            this.pos = 0;
        }

        public EvaluatorToken peek() throws ManifoldCFException {
            if (this.token == null) {
                this.token = this.nextToken();
            }
            return this.token;
        }

        public void advance() {
            this.token = null;
        }

        protected EvaluatorToken nextToken() throws ManifoldCFException {
            char x;
            while (true) {
                if (this.pos == this.text.length()) {
                    return null;
                }
                x = this.text.charAt(this.pos);
                if (x > ' ') break;
                ++this.pos;
            }
            if (x == '\"') {
                ++this.pos;
                StringBuilder sb = new StringBuilder();
                while (this.pos != this.text.length()) {
                    x = this.text.charAt(this.pos);
                    ++this.pos;
                    if (x == '\"') break;
                    if (x == '\\') {
                        if (this.pos == this.text.length()) break;
                        x = this.text.charAt(this.pos++);
                    }
                    sb.append(x);
                }
                return new EvaluatorToken(sb.toString());
            }
            if (x == ',') {
                ++this.pos;
                return new EvaluatorToken();
            }
            StringBuilder sb = new StringBuilder();
            while (this.pos != this.text.length() && (x = this.text.charAt(this.pos)) >= '0' && x <= '9') {
                sb.append(x);
                ++this.pos;
            }
            String numberValue = sb.toString();
            int groupNumber = 0;
            if (numberValue.length() > 0) {
                groupNumber = new Integer(numberValue);
            }
            int modifierPos = this.pos;
            while (!(this.pos == this.text.length() || (x = this.text.charAt(this.pos)) == ',' || x >= '0' && x <= '9' || x <= ' ' && x >= '\u0000')) {
                ++this.pos;
            }
            int style = 0;
            if (modifierPos != this.pos) {
                String modifier = this.text.substring(modifierPos, this.pos);
                if (modifier.startsWith("u")) {
                    style = 2;
                } else if (modifier.startsWith("l")) {
                    style = 1;
                } else if (modifier.startsWith("m")) {
                    style = 3;
                } else {
                    throw new ManifoldCFException("Unknown style: " + modifier);
                }
            }
            return new EvaluatorToken(groupNumber, style);
        }
    }

    protected static class EvaluatorToken {
        public static final int TYPE_GROUP = 0;
        public static final int TYPE_TEXT = 1;
        public static final int TYPE_COMMA = 2;
        public static final int GROUPSTYLE_NONE = 0;
        public static final int GROUPSTYLE_LOWER = 1;
        public static final int GROUPSTYLE_UPPER = 2;
        public static final int GROUPSTYLE_MIXED = 3;
        protected int type;
        protected int groupNumber = -1;
        protected int groupStyle = 0;
        protected String textValue = null;

        public EvaluatorToken() {
            this.type = 2;
        }

        public EvaluatorToken(int groupNumber, int groupStyle) {
            this.type = 0;
            this.groupNumber = groupNumber;
            this.groupStyle = groupStyle;
        }

        public EvaluatorToken(String text) {
            this.type = 1;
            this.textValue = text;
        }

        public int getType() {
            return this.type;
        }

        public int getGroupNumber() {
            return this.groupNumber;
        }

        public int getGroupStyle() {
            return this.groupStyle;
        }

        public String getTextValue() {
            return this.textValue;
        }
    }

    protected static class NameValue {
        protected String name;
        protected String value;

        public NameValue(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    protected static class ThrottleSpec
    implements IThrottleSpec {
        protected final int maxOpenConnectionsPerServer;
        protected final long minimumMillisecondsPerFetchPerServer;
        protected final double minimumMillisecondsPerBytePerServer;

        public ThrottleSpec(int maxOpenConnectionsPerServer, long minimumMillisecondsPerFetchPerServer, double minimumMillisecondsPerBytePerServer) {
            this.maxOpenConnectionsPerServer = maxOpenConnectionsPerServer;
            this.minimumMillisecondsPerFetchPerServer = minimumMillisecondsPerFetchPerServer;
            this.minimumMillisecondsPerBytePerServer = minimumMillisecondsPerBytePerServer;
        }

        public int getMaxOpenConnections(String binName) {
            return this.maxOpenConnectionsPerServer;
        }

        public double getMinimumMillisecondsPerByte(String binName) {
            return this.minimumMillisecondsPerBytePerServer;
        }

        public long getMinimumMillisecondsPerFetch(String binName) {
            return this.minimumMillisecondsPerFetchPerServer;
        }
    }

    protected class UrlsetItemContextClass
    extends XMLParsingContext {
        protected String linkField;
        protected String pubDateField;

        public UrlsetItemContextClass(XMLFuzzyHierarchicalParseState theStream, String namespace, String localName, String qName, Map<String, String> atts) {
            super(theStream, namespace, localName, qName, atts);
            this.linkField = null;
            this.pubDateField = null;
        }

        protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
            if (localName.equals("loc")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            if (localName.equals("lastmod")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            return super.beginTag(namespace, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException {
            XMLParsingContext theContext = this.theStream.getContext();
            String theTag = theContext.getLocalname();
            if (theTag.equals("loc")) {
                this.linkField = ((XMLStringParsingContext)theContext).getValue();
            } else if (theTag.equals("lastmod")) {
                this.pubDateField = ((XMLStringParsingContext)theContext).getValue();
            } else {
                super.endTag();
            }
        }

        protected void tagCleanup() throws ManifoldCFException {
        }

        public void process(String documentIdentifier, IProcessActivity activities, Filter filter) throws ManifoldCFException {
            if (this.linkField != null && this.linkField.length() > 0) {
                Date origDateDate = null;
                if (this.pubDateField != null && this.pubDateField.length() > 0) {
                    origDateDate = DateParser.parseISO8601Date((String)this.pubDateField);
                }
                Long origDate = origDateDate != null ? new Long(origDateDate.getTime()) : null;
                String[] links = this.linkField.split(", ");
                int l = 0;
                while (l < links.length) {
                    String rawURL = links[l++].trim();
                    String newIdentifier = RSSConnector.makeDocumentIdentifier(filter.getCanonicalizationPolicies(), documentIdentifier, rawURL);
                    if (newIdentifier != null) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("RSS: In SiteMap document '" + documentIdentifier + "', found a link to '" + newIdentifier + "', which has origination date " + (origDate == null ? "null" : origDate.toString())));
                        }
                        if (filter.isLegalURL(newIdentifier)) {
                            String[] dataNames = new String[]{"pubdate", "source"};
                            Object[][] dataValues = new String[dataNames.length][];
                            if (origDate != null) {
                                dataValues[0] = new String[]{origDate.toString()};
                            }
                            dataValues[1] = new String[]{documentIdentifier};
                            activities.addDocumentReference(newIdentifier, documentIdentifier, null, dataNames, dataValues, origDate);
                            continue;
                        }
                        if (!Logging.connectors.isDebugEnabled()) continue;
                        Logging.connectors.debug((Object)("RSS: Identifier '" + newIdentifier + "' is excluded"));
                        continue;
                    }
                    if (!Logging.connectors.isDebugEnabled()) continue;
                    Logging.connectors.debug((Object)("RSS: In SiteMap document '" + documentIdentifier + "', found an unincluded URL '" + rawURL + "'"));
                }
            }
        }
    }

    protected class UrlsetContextClass
    extends XMLParsingContext {
        protected String documentIdentifier;
        protected IProcessActivity activities;
        protected Filter filter;
        protected String ttlValue;

        public UrlsetContextClass(XMLFuzzyHierarchicalParseState theStream, String namespace, String localName, String qName, Map<String, String> atts, String documentIdentifier, IProcessActivity activities, Filter filter) {
            super(theStream, namespace, localName, qName, atts);
            this.ttlValue = null;
            this.documentIdentifier = documentIdentifier;
            this.activities = activities;
            this.filter = filter;
        }

        protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
            if (localName.equals("url") || localName.equals("sitemap")) {
                return new UrlsetItemContextClass(this.theStream, namespace, localName, qName, atts);
            }
            return super.beginTag(namespace, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException {
            XMLParsingContext theContext = this.theStream.getContext();
            String theTag = theContext.getLocalname();
            if (theTag.equals("url") || theTag.equals("sitemap")) {
                UrlsetItemContextClass itemContext = (UrlsetItemContextClass)theContext;
                itemContext.process(this.documentIdentifier, this.activities, this.filter);
            } else {
                super.endTag();
            }
        }

        protected boolean process() throws ManifoldCFException {
            Long minimumTime;
            long currentTime = System.currentTimeMillis();
            Long rescanTime = this.filter.getDefaultRescanTime(currentTime);
            if (this.ttlValue != null) {
                try {
                    int minutes = Integer.parseInt(this.ttlValue);
                    long nextTime = currentTime + (long)minutes * 60000L;
                    rescanTime = new Long(nextTime);
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("RSS: In SiteMap document '" + this.documentIdentifier + "', found a ttl value of " + this.ttlValue + "; setting refetch time accordingly"));
                    }
                }
                catch (NumberFormatException e) {
                    Logging.connectors.warn((Object)("RSS: SiteMap document '" + this.documentIdentifier + "' has illegal ttl value '" + this.ttlValue + "'"));
                }
            }
            if (rescanTime != null && (minimumTime = this.filter.getMinimumRescanTime(currentTime)) != null && rescanTime < minimumTime) {
                rescanTime = minimumTime;
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("RSS: In SiteMap document '" + this.documentIdentifier + "' setting rescan time to " + (rescanTime == null ? "null" : rescanTime.toString())));
            }
            this.activities.setDocumentScheduleBounds(this.documentIdentifier, rescanTime, rescanTime, null, null);
            return true;
        }
    }

    protected class FeedAuthorContextClass
    extends XMLParsingContext {
        protected String authorNameField;
        protected String authorEmailField;

        public FeedAuthorContextClass(XMLFuzzyHierarchicalParseState theStream, String namespace, String localName, String qName, Map<String, String> atts) {
            super(theStream, namespace, localName, qName, atts);
            this.authorNameField = null;
            this.authorEmailField = null;
        }

        protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
            if (localName.equals("name")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            if (localName.equals("email")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            return super.beginTag(namespace, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException {
            XMLParsingContext theContext = this.theStream.getContext();
            String theTag = theContext.getLocalname();
            if (theTag.equals("name")) {
                this.authorNameField = ((XMLStringParsingContext)theContext).getValue();
            } else if (theTag.equals("email")) {
                this.authorEmailField = ((XMLStringParsingContext)theContext).getValue();
            } else {
                super.endTag();
            }
        }

        public String getAuthorName() {
            return this.authorNameField;
        }

        public String getAuthorEmail() {
            return this.authorEmailField;
        }
    }

    protected class FeedItemContextClass
    extends XMLParsingContext {
        protected int dechromedContentMode;
        protected List<String> linkField;
        protected String pubDateField;
        protected String titleField;
        protected String authorNameField;
        protected String authorEmailField;
        protected ArrayList categoryField;
        protected File contentsFile;
        protected String descriptionField;

        public FeedItemContextClass(XMLFuzzyHierarchicalParseState theStream, String namespace, String localName, String qName, Map<String, String> atts, int dechromedContentMode) {
            super(theStream, namespace, localName, qName, atts);
            this.linkField = new ArrayList<String>();
            this.pubDateField = null;
            this.titleField = null;
            this.authorNameField = null;
            this.authorEmailField = null;
            this.categoryField = new ArrayList();
            this.contentsFile = null;
            this.descriptionField = null;
            this.dechromedContentMode = dechromedContentMode;
        }

        protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
            if (localName.equals("link")) {
                String ref = atts.get("href");
                if (ref != null && ref.length() > 0) {
                    this.linkField.add(ref);
                }
                return super.beginTag(namespace, localName, qName, atts);
            }
            if (localName.equals("published") || localName.equals("updated")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            if (localName.equals("title")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            if (localName.equals("author")) {
                return new FeedAuthorContextClass(this.theStream, namespace, localName, qName, atts);
            }
            if (localName.equals("category")) {
                String category = atts.get("term");
                if (category != null && category.length() > 0) {
                    this.categoryField.add(category);
                }
                return super.beginTag(namespace, localName, qName, atts);
            }
            switch (this.dechromedContentMode) {
                case 0: {
                    if (!localName.equals("subtitle")) break;
                    return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
                }
                case 1: {
                    if (!localName.equals("subtitle")) break;
                    try {
                        File tempFile = File.createTempFile("_rssdata_", "tmp");
                        return new XMLFileParsingContext(this.theStream, namespace, localName, qName, atts, tempFile);
                    }
                    catch (SocketTimeoutException e) {
                        throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                    }
                    catch (InterruptedIOException e) {
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    catch (IOException e) {
                        throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                    }
                }
                case 2: {
                    if (localName.equals("content")) {
                        try {
                            File tempFile = File.createTempFile("_rssdata_", "tmp");
                            return new XMLFileParsingContext(this.theStream, namespace, localName, qName, atts, tempFile);
                        }
                        catch (SocketTimeoutException e) {
                            throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                        }
                        catch (InterruptedIOException e) {
                            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                        }
                        catch (IOException e) {
                            throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (!localName.equals("subtitle")) break;
                    return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
                }
            }
            return super.beginTag(namespace, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException {
            XMLParsingContext theContext = this.theStream.getContext();
            String theTag = theContext.getLocalname();
            if (theTag.equals("published") || theTag.equals("updated")) {
                this.pubDateField = ((XMLStringParsingContext)theContext).getValue();
            } else if (theTag.equals("title")) {
                this.titleField = ((XMLStringParsingContext)theContext).getValue();
            } else if (theTag.equals("author")) {
                FeedAuthorContextClass authorContext = (FeedAuthorContextClass)theContext;
                this.authorEmailField = authorContext.getAuthorEmail();
                this.authorNameField = authorContext.getAuthorName();
            } else {
                switch (this.dechromedContentMode) {
                    case 0: {
                        if (!theTag.equals("subtitle")) break;
                        this.titleField = ((XMLStringParsingContext)theContext).getValue();
                        break;
                    }
                    case 1: {
                        if (!theTag.equals("subtitle")) break;
                        this.tagCleanup();
                        this.contentsFile = ((XMLFileParsingContext)theContext).getCompletedFile();
                        return;
                    }
                    case 2: {
                        if (theTag.equals("content")) {
                            this.tagCleanup();
                            this.contentsFile = ((XMLFileParsingContext)theContext).getCompletedFile();
                            return;
                        }
                        if (!theTag.equals("subtitle")) break;
                        this.titleField = ((XMLStringParsingContext)theContext).getValue();
                        break;
                    }
                }
                super.endTag();
            }
        }

        protected void tagCleanup() throws ManifoldCFException {
            if (this.contentsFile != null) {
                this.contentsFile.delete();
                this.contentsFile = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(String documentIdentifier, IProcessActivity activities, Filter filter) throws ManifoldCFException {
            if (this.linkField.size() > 0) {
                Date origDateDate = null;
                if (this.pubDateField != null && this.pubDateField.length() > 0) {
                    origDateDate = DateParser.parseISO8601Date((String)this.pubDateField);
                }
                Long origDate = origDateDate != null ? new Long(origDateDate.getTime()) : null;
                for (String linkValue : this.linkField) {
                    String[] links = linkValue.split(", ");
                    int l = 0;
                    while (l < links.length) {
                        String rawURL = links[l++].trim();
                        String newIdentifier = RSSConnector.makeDocumentIdentifier(filter.getCanonicalizationPolicies(), documentIdentifier, rawURL);
                        if (newIdentifier != null) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("RSS: In Atom document '" + documentIdentifier + "', found a link to '" + newIdentifier + "', which has origination date " + (origDate == null ? "null" : origDate.toString())));
                            }
                            if (filter.isLegalURL(newIdentifier)) {
                                NullCharacterInput ci;
                                int q;
                                Object[][] dataValues;
                                String[] dataNames;
                                if (this.contentsFile == null && filter.getChromedContentMode() != 2) {
                                    dataNames = new String[]{"pubdate", "title", "source", "category", "description"};
                                    dataValues = new String[dataNames.length][];
                                    if (origDate != null) {
                                        dataValues[0] = new String[]{origDate.toString()};
                                    }
                                    if (this.titleField != null) {
                                        dataValues[1] = new String[]{this.titleField};
                                    }
                                    dataValues[2] = new String[]{documentIdentifier};
                                    dataValues[3] = new String[this.categoryField.size()];
                                    for (q = 0; q < this.categoryField.size(); ++q) {
                                        dataValues[3][q] = (String)this.categoryField.get(q);
                                    }
                                    if (this.descriptionField != null) {
                                        dataValues[4] = new String[]{this.descriptionField};
                                    }
                                    activities.addDocumentReference(newIdentifier, documentIdentifier, null, dataNames, dataValues, origDate);
                                    continue;
                                }
                                dataNames = new String[]{"pubdate", "title", "source", "category", "data", "description"};
                                dataValues = new Object[dataNames.length][];
                                if (origDate != null) {
                                    dataValues[0] = new String[]{origDate.toString()};
                                }
                                if (this.titleField != null) {
                                    dataValues[1] = new String[]{this.titleField};
                                }
                                dataValues[2] = new String[]{documentIdentifier};
                                dataValues[3] = new String[this.categoryField.size()];
                                for (q = 0; q < this.categoryField.size(); ++q) {
                                    dataValues[3][q] = (String)this.categoryField.get(q);
                                }
                                if (this.descriptionField != null) {
                                    dataValues[5] = new String[]{this.descriptionField};
                                }
                                if (this.contentsFile == null) {
                                    ci = new NullCharacterInput();
                                    try {
                                        dataValues[4] = new Object[]{ci};
                                        activities.addDocumentReference(newIdentifier, documentIdentifier, null, dataNames, dataValues, origDate);
                                        continue;
                                    }
                                    finally {
                                        ci.discard();
                                        continue;
                                    }
                                }
                                ci = new TempFileCharacterInput(this.contentsFile);
                                try {
                                    this.contentsFile = null;
                                    dataValues[4] = new Object[]{ci};
                                    activities.addDocumentReference(newIdentifier, documentIdentifier, null, dataNames, dataValues, origDate);
                                    continue;
                                }
                                finally {
                                    ci.discard();
                                    continue;
                                }
                            }
                            if (!Logging.connectors.isDebugEnabled()) continue;
                            Logging.connectors.debug((Object)("RSS: Identifier '" + newIdentifier + "' is excluded"));
                            continue;
                        }
                        if (!Logging.connectors.isDebugEnabled()) continue;
                        Logging.connectors.debug((Object)("RSS: In Atom document '" + documentIdentifier + "', found an unincluded URL '" + rawURL + "'"));
                    }
                }
            }
        }
    }

    protected class FeedContextClass
    extends XMLParsingContext {
        protected String documentIdentifier;
        protected IProcessActivity activities;
        protected Filter filter;
        protected String ttlValue;

        public FeedContextClass(XMLFuzzyHierarchicalParseState theStream, String namespace, String localName, String qName, Map<String, String> atts, String documentIdentifier, IProcessActivity activities, Filter filter) {
            super(theStream, namespace, localName, qName, atts);
            this.ttlValue = null;
            this.documentIdentifier = documentIdentifier;
            this.activities = activities;
            this.filter = filter;
        }

        protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
            if (localName.equals("ttl")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            if (localName.equals("entry")) {
                return new FeedItemContextClass(this.theStream, namespace, localName, qName, atts, this.filter.getDechromedContentMode());
            }
            return super.beginTag(namespace, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException {
            XMLParsingContext theContext = this.theStream.getContext();
            String theTag = theContext.getLocalname();
            if (theTag.equals("ttl")) {
                this.ttlValue = ((XMLStringParsingContext)theContext).getValue();
            } else if (theTag.equals("entry")) {
                FeedItemContextClass itemContext = (FeedItemContextClass)theContext;
                itemContext.process(this.documentIdentifier, this.activities, this.filter);
            } else {
                super.endTag();
            }
        }

        protected boolean process() throws ManifoldCFException {
            Long minimumTime;
            long currentTime = System.currentTimeMillis();
            Long rescanTime = this.filter.getDefaultRescanTime(currentTime);
            if (this.ttlValue != null) {
                try {
                    int minutes = Integer.parseInt(this.ttlValue);
                    long nextTime = currentTime + (long)minutes * 60000L;
                    rescanTime = new Long(nextTime);
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("RSS: In Atom document '" + this.documentIdentifier + "', found a ttl value of " + this.ttlValue + "; setting refetch time accordingly"));
                    }
                }
                catch (NumberFormatException e) {
                    Logging.connectors.warn((Object)("RSS: Atom document '" + this.documentIdentifier + "' has illegal ttl value '" + this.ttlValue + "'"));
                }
            }
            if (rescanTime != null && (minimumTime = this.filter.getMinimumRescanTime(currentTime)) != null && rescanTime < minimumTime) {
                rescanTime = minimumTime;
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("RSS: In Atom document '" + this.documentIdentifier + "' setting rescan time to " + (rescanTime == null ? "null" : rescanTime.toString())));
            }
            this.activities.setDocumentScheduleBounds(this.documentIdentifier, rescanTime, rescanTime, null, null);
            return true;
        }
    }

    protected class RDFItemContextClass
    extends XMLParsingContext {
        protected int dechromedContentMode;
        protected String linkField;
        protected String pubDateField;
        protected String titleField;
        protected String authorNameField;
        protected String descriptionField;
        protected File contentsFile;

        public RDFItemContextClass(XMLFuzzyHierarchicalParseState theStream, String namespace, String localName, String qName, Map<String, String> atts, int dechromedContentMode) {
            super(theStream, namespace, localName, qName, atts);
            this.linkField = null;
            this.pubDateField = null;
            this.titleField = null;
            this.authorNameField = null;
            this.descriptionField = null;
            this.contentsFile = null;
            this.dechromedContentMode = dechromedContentMode;
        }

        protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
            if (localName.equals("link")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            if (localName.equals("date")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            if (localName.equals("title")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            if (localName.equals("creator")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            switch (this.dechromedContentMode) {
                case 0: {
                    if (!localName.equals("description")) break;
                    return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
                }
                case 1: {
                    if (!localName.equals("description")) break;
                    try {
                        File tempFile = File.createTempFile("_rssdata_", "tmp");
                        return new XMLFileParsingContext(this.theStream, namespace, localName, qName, atts, tempFile);
                    }
                    catch (SocketTimeoutException e) {
                        throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                    }
                    catch (InterruptedIOException e) {
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    catch (IOException e) {
                        throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                    }
                }
                case 2: {
                    if (localName.equals("content")) {
                        try {
                            File tempFile = File.createTempFile("_rssdata_", "tmp");
                            return new XMLFileParsingContext(this.theStream, namespace, localName, qName, atts, tempFile);
                        }
                        catch (SocketTimeoutException e) {
                            throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                        }
                        catch (InterruptedIOException e) {
                            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                        }
                        catch (IOException e) {
                            throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (!localName.equals("description")) break;
                    return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
                }
            }
            return super.beginTag(namespace, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException {
            XMLParsingContext theContext = this.theStream.getContext();
            String theTag = theContext.getLocalname();
            if (theTag.equals("link")) {
                this.linkField = ((XMLStringParsingContext)theContext).getValue();
            } else if (theTag.equals("date")) {
                this.pubDateField = ((XMLStringParsingContext)theContext).getValue();
            } else if (theTag.equals("title")) {
                this.titleField = ((XMLStringParsingContext)theContext).getValue();
            } else if (theTag.equals("creator")) {
                this.authorNameField = ((XMLStringParsingContext)theContext).getValue();
            } else {
                switch (this.dechromedContentMode) {
                    case 0: {
                        if (!theTag.equals("description")) break;
                        this.descriptionField = ((XMLStringParsingContext)theContext).getValue();
                        break;
                    }
                    case 1: {
                        if (!theTag.equals("description")) break;
                        this.tagCleanup();
                        this.contentsFile = ((XMLFileParsingContext)theContext).getCompletedFile();
                        return;
                    }
                    case 2: {
                        if (theTag.equals("dc:content")) {
                            this.tagCleanup();
                            this.contentsFile = ((XMLFileParsingContext)theContext).getCompletedFile();
                            return;
                        }
                        if (!theTag.equals("description")) break;
                        this.descriptionField = ((XMLStringParsingContext)theContext).getValue();
                        break;
                    }
                }
                super.endTag();
            }
        }

        protected void tagCleanup() throws ManifoldCFException {
            if (this.contentsFile != null) {
                this.contentsFile.delete();
                this.contentsFile = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(String documentIdentifier, IProcessActivity activities, Filter filter) throws ManifoldCFException {
            if (this.linkField != null && this.linkField.length() > 0) {
                Date origDateDate = null;
                if (this.pubDateField != null && this.pubDateField.length() > 0) {
                    origDateDate = DateParser.parseISO8601Date((String)this.pubDateField);
                }
                Long origDate = origDateDate != null ? new Long(origDateDate.getTime()) : null;
                String[] links = this.linkField.split(", ");
                int l = 0;
                while (l < links.length) {
                    String rawURL = links[l++].trim();
                    String newIdentifier = RSSConnector.makeDocumentIdentifier(filter.getCanonicalizationPolicies(), documentIdentifier, rawURL);
                    if (newIdentifier != null) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("RSS: In RDF document '" + documentIdentifier + "', found a link to '" + newIdentifier + "', which has origination date " + (origDate == null ? "null" : origDate.toString())));
                        }
                        if (filter.isLegalURL(newIdentifier)) {
                            NullCharacterInput ci;
                            Object[][] dataValues;
                            String[] dataNames;
                            if (this.contentsFile == null && filter.getChromedContentMode() != 2) {
                                dataNames = new String[]{"pubdate", "title", "source", "authorname", "description"};
                                dataValues = new String[dataNames.length][];
                                if (origDate != null) {
                                    dataValues[0] = new String[]{origDate.toString()};
                                }
                                if (this.titleField != null) {
                                    dataValues[1] = new String[]{this.titleField};
                                }
                                dataValues[2] = new String[]{documentIdentifier};
                                if (this.authorNameField != null) {
                                    dataValues[3] = new String[]{this.authorNameField};
                                }
                                if (this.descriptionField != null) {
                                    dataValues[4] = new String[]{this.descriptionField};
                                }
                                activities.addDocumentReference(newIdentifier, documentIdentifier, null, dataNames, dataValues, origDate);
                                continue;
                            }
                            dataNames = new String[]{"pubdate", "title", "source", "authorname", "data", "description"};
                            dataValues = new Object[dataNames.length][];
                            if (origDate != null) {
                                dataValues[0] = new String[]{origDate.toString()};
                            }
                            if (this.titleField != null) {
                                dataValues[1] = new String[]{this.titleField};
                            }
                            dataValues[2] = new String[]{documentIdentifier};
                            if (this.authorNameField != null) {
                                dataValues[3] = new String[]{this.authorNameField};
                            }
                            if (this.descriptionField != null) {
                                dataValues[5] = new String[]{this.descriptionField};
                            }
                            if (this.contentsFile == null) {
                                ci = new NullCharacterInput();
                                try {
                                    dataValues[4] = new Object[]{ci};
                                    activities.addDocumentReference(newIdentifier, documentIdentifier, null, dataNames, dataValues, origDate);
                                    continue;
                                }
                                finally {
                                    ci.discard();
                                    continue;
                                }
                            }
                            ci = new TempFileCharacterInput(this.contentsFile);
                            try {
                                this.contentsFile = null;
                                dataValues[4] = new Object[]{ci};
                                activities.addDocumentReference(newIdentifier, documentIdentifier, null, dataNames, dataValues, origDate);
                                continue;
                            }
                            finally {
                                ci.discard();
                                continue;
                            }
                        }
                        if (!Logging.connectors.isDebugEnabled()) continue;
                        Logging.connectors.debug((Object)("RSS: Identifier '" + newIdentifier + "' is excluded"));
                        continue;
                    }
                    if (!Logging.connectors.isDebugEnabled()) continue;
                    Logging.connectors.debug((Object)("RSS: In RSS document '" + documentIdentifier + "', found an unincluded URL '" + rawURL + "'"));
                }
            }
        }
    }

    protected class RDFContextClass
    extends XMLParsingContext {
        protected String documentIdentifier;
        protected IProcessActivity activities;
        protected Filter filter;
        protected String ttlValue;

        public RDFContextClass(XMLFuzzyHierarchicalParseState theStream, String namespace, String localName, String qName, Map<String, String> atts, String documentIdentifier, IProcessActivity activities, Filter filter) {
            super(theStream, namespace, localName, qName, atts);
            this.ttlValue = null;
            this.documentIdentifier = documentIdentifier;
            this.activities = activities;
            this.filter = filter;
        }

        protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
            if (localName.equals("ttl")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            if (localName.equals("item")) {
                return new RDFItemContextClass(this.theStream, namespace, localName, qName, atts, this.filter.getDechromedContentMode());
            }
            return super.beginTag(namespace, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException {
            XMLParsingContext theContext = this.theStream.getContext();
            String theTag = theContext.getLocalname();
            if (theTag.equals("ttl")) {
                this.ttlValue = ((XMLStringParsingContext)theContext).getValue();
            } else if (theTag.equals("item")) {
                RDFItemContextClass itemContext = (RDFItemContextClass)theContext;
                itemContext.process(this.documentIdentifier, this.activities, this.filter);
            } else {
                super.endTag();
            }
        }

        protected boolean process() throws ManifoldCFException {
            Long minimumTime;
            long currentTime = System.currentTimeMillis();
            Long rescanTime = this.filter.getDefaultRescanTime(currentTime);
            if (this.ttlValue != null) {
                try {
                    int minutes = Integer.parseInt(this.ttlValue);
                    long nextTime = currentTime + (long)minutes * 60000L;
                    rescanTime = new Long(nextTime);
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("RSS: In RDF document '" + this.documentIdentifier + "', found a ttl value of " + this.ttlValue + "; setting refetch time accordingly"));
                    }
                }
                catch (NumberFormatException e) {
                    Logging.connectors.warn((Object)("RSS: RDF document '" + this.documentIdentifier + "' has illegal ttl value '" + this.ttlValue + "'"));
                }
            }
            if (rescanTime != null && (minimumTime = this.filter.getMinimumRescanTime(currentTime)) != null && rescanTime < minimumTime) {
                rescanTime = minimumTime;
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("RSS: In RDF document '" + this.documentIdentifier + "' setting rescan time to " + (rescanTime == null ? "null" : rescanTime.toString())));
            }
            this.activities.setDocumentScheduleBounds(this.documentIdentifier, rescanTime, rescanTime, null, null);
            return true;
        }
    }

    protected class RSSItemContextClass
    extends XMLParsingContext {
        protected int dechromedContentMode;
        protected String guidField;
        protected String linkField;
        protected String pubDateField;
        protected String titleField;
        protected String descriptionField;
        protected String authorEmailField;
        protected String authorNameField;
        protected ArrayList categoryField;
        protected File contentsFile;

        public RSSItemContextClass(XMLFuzzyHierarchicalParseState theStream, String namespace, String localName, String qName, Map<String, String> atts, int dechromedContentMode) {
            super(theStream, namespace, localName, qName, atts);
            this.guidField = null;
            this.linkField = null;
            this.pubDateField = null;
            this.titleField = null;
            this.descriptionField = null;
            this.authorEmailField = null;
            this.authorNameField = null;
            this.categoryField = new ArrayList();
            this.contentsFile = null;
            this.dechromedContentMode = dechromedContentMode;
        }

        protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
            if (localName.equals("link")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            if (localName.equals("guid")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            if (localName.equals("pubdate")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            if (localName.equals("title")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            if (localName.equals("category")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            if (localName.equals("author")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            if (localName.equals("creator")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            switch (this.dechromedContentMode) {
                case 0: {
                    if (!localName.equals("description")) break;
                    return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
                }
                case 1: {
                    if (!localName.equals("description")) break;
                    try {
                        File tempFile = File.createTempFile("_rssdata_", "tmp");
                        return new XMLFileParsingContext(this.theStream, namespace, localName, qName, atts, tempFile);
                    }
                    catch (SocketTimeoutException e) {
                        throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                    }
                    catch (InterruptedIOException e) {
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    catch (IOException e) {
                        throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                    }
                }
                case 2: {
                    if (localName.equals("content")) {
                        try {
                            File tempFile = File.createTempFile("_rssdata_", "tmp");
                            return new XMLFileParsingContext(this.theStream, namespace, localName, qName, atts, tempFile);
                        }
                        catch (SocketTimeoutException e) {
                            throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                        }
                        catch (InterruptedIOException e) {
                            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                        }
                        catch (IOException e) {
                            throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (!localName.equals("description")) break;
                    return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
                }
            }
            return super.beginTag(namespace, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException {
            XMLParsingContext theContext = this.theStream.getContext();
            String theTag = theContext.getLocalname();
            if (theTag.equals("link")) {
                this.linkField = ((XMLStringParsingContext)theContext).getValue();
            } else if (theTag.equals("guid")) {
                this.guidField = ((XMLStringParsingContext)theContext).getValue();
            } else if (theTag.equals("pubdate")) {
                this.pubDateField = ((XMLStringParsingContext)theContext).getValue();
            } else if (theTag.equals("title")) {
                this.titleField = ((XMLStringParsingContext)theContext).getValue();
            } else if (theTag.equals("category")) {
                this.categoryField.add(((XMLStringParsingContext)theContext).getValue());
            } else if (theTag.equals("author")) {
                this.authorEmailField = ((XMLStringParsingContext)theContext).getValue();
            } else if (theTag.equals("creator")) {
                this.authorNameField = ((XMLStringParsingContext)theContext).getValue();
            } else {
                switch (this.dechromedContentMode) {
                    case 0: {
                        if (!theTag.equals("description")) break;
                        this.descriptionField = ((XMLStringParsingContext)theContext).getValue();
                        break;
                    }
                    case 1: {
                        if (!theTag.equals("description")) break;
                        this.tagCleanup();
                        this.contentsFile = ((XMLFileParsingContext)theContext).getCompletedFile();
                        return;
                    }
                    case 2: {
                        if (theTag.equals("content")) {
                            this.tagCleanup();
                            this.contentsFile = ((XMLFileParsingContext)theContext).getCompletedFile();
                            return;
                        }
                        if (!theTag.equals("description")) break;
                        this.descriptionField = ((XMLStringParsingContext)theContext).getValue();
                        break;
                    }
                }
                super.endTag();
            }
        }

        protected void tagCleanup() throws ManifoldCFException {
            if (this.contentsFile != null) {
                this.contentsFile.delete();
                this.contentsFile = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(String documentIdentifier, IProcessActivity activities, Filter filter) throws ManifoldCFException {
            if (this.linkField == null || this.linkField.length() == 0) {
                this.linkField = this.guidField;
            }
            if (this.linkField != null && this.linkField.length() > 0) {
                Date origDateDate = null;
                if (this.pubDateField != null && this.pubDateField.length() > 0) {
                    origDateDate = DateParser.parseRFC822Date((String)this.pubDateField);
                    if (origDateDate == null) {
                        origDateDate = DateParser.parseChinaDate((String)this.pubDateField);
                    }
                    if (origDateDate == null) {
                        origDateDate = DateParser.parseISO8601Date((String)this.pubDateField);
                    }
                }
                Long origDate = origDateDate != null ? new Long(origDateDate.getTime()) : null;
                String[] links = this.linkField.split(", ");
                int l = 0;
                while (l < links.length) {
                    String rawURL = links[l++].trim();
                    String newIdentifier = RSSConnector.makeDocumentIdentifier(filter.getCanonicalizationPolicies(), documentIdentifier, rawURL);
                    if (newIdentifier != null) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("RSS: In RSS document '" + documentIdentifier + "', found a link to '" + newIdentifier + "', which has origination date " + (origDate == null ? "null" : origDate.toString())));
                        }
                        if (filter.isLegalURL(newIdentifier)) {
                            NullCharacterInput ci;
                            int q;
                            Object[][] dataValues;
                            String[] dataNames;
                            if (this.contentsFile == null && filter.getChromedContentMode() != 2) {
                                dataNames = new String[]{"pubdate", "title", "source", "authoremail", "authorname", "category", "description"};
                                dataValues = new String[dataNames.length][];
                                if (origDate != null) {
                                    dataValues[0] = new String[]{origDate.toString()};
                                }
                                if (this.titleField != null) {
                                    dataValues[1] = new String[]{this.titleField};
                                }
                                dataValues[2] = new String[]{documentIdentifier};
                                if (this.authorEmailField != null) {
                                    dataValues[3] = new String[]{this.authorEmailField};
                                }
                                if (this.authorNameField != null) {
                                    dataValues[4] = new String[]{this.authorNameField};
                                }
                                dataValues[5] = new String[this.categoryField.size()];
                                for (q = 0; q < this.categoryField.size(); ++q) {
                                    dataValues[5][q] = (String)this.categoryField.get(q);
                                }
                                if (this.descriptionField != null) {
                                    dataValues[6] = new String[]{this.descriptionField};
                                }
                                activities.addDocumentReference(newIdentifier, documentIdentifier, null, dataNames, dataValues, origDate);
                                continue;
                            }
                            dataNames = new String[]{"pubdate", "title", "source", "authoremail", "authorname", "category", "data", "description"};
                            dataValues = new Object[dataNames.length][];
                            if (origDate != null) {
                                dataValues[0] = new String[]{origDate.toString()};
                            }
                            if (this.titleField != null) {
                                dataValues[1] = new String[]{this.titleField};
                            }
                            dataValues[2] = new String[]{documentIdentifier};
                            if (this.authorEmailField != null) {
                                dataValues[3] = new String[]{this.authorEmailField};
                            }
                            if (this.authorNameField != null) {
                                dataValues[4] = new String[]{this.authorNameField};
                            }
                            dataValues[5] = new String[this.categoryField.size()];
                            for (q = 0; q < this.categoryField.size(); ++q) {
                                dataValues[5][q] = (String)this.categoryField.get(q);
                            }
                            if (this.descriptionField != null) {
                                dataValues[7] = new String[]{this.descriptionField};
                            }
                            if (this.contentsFile == null) {
                                ci = new NullCharacterInput();
                                try {
                                    dataValues[6] = new Object[]{ci};
                                    activities.addDocumentReference(newIdentifier, documentIdentifier, null, dataNames, dataValues, origDate);
                                    continue;
                                }
                                finally {
                                    ci.discard();
                                    continue;
                                }
                            }
                            ci = new TempFileCharacterInput(this.contentsFile);
                            try {
                                this.contentsFile = null;
                                dataValues[6] = new Object[]{ci};
                                activities.addDocumentReference(newIdentifier, documentIdentifier, null, dataNames, dataValues, origDate);
                                continue;
                            }
                            finally {
                                ci.discard();
                                continue;
                            }
                        }
                        if (!Logging.connectors.isDebugEnabled()) continue;
                        Logging.connectors.debug((Object)("RSS: Identifier '" + newIdentifier + "' is excluded"));
                        continue;
                    }
                    if (!Logging.connectors.isDebugEnabled()) continue;
                    Logging.connectors.debug((Object)("RSS: In RSS document '" + documentIdentifier + "', found an unincluded URL '" + rawURL + "'"));
                }
            }
        }
    }

    protected class RSSChannelContextClass
    extends XMLParsingContext {
        protected String documentIdentifier;
        protected IProcessActivity activities;
        protected Filter filter;
        protected String ttlValue;

        public RSSChannelContextClass(XMLFuzzyHierarchicalParseState theStream, String namespace, String localName, String qName, Map<String, String> atts, String documentIdentifier, IProcessActivity activities, Filter filter) {
            super(theStream, namespace, localName, qName, atts);
            this.ttlValue = null;
            this.documentIdentifier = documentIdentifier;
            this.activities = activities;
            this.filter = filter;
        }

        protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
            if (localName.equals("ttl")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            if (localName.equals("item")) {
                return new RSSItemContextClass(this.theStream, namespace, localName, qName, atts, this.filter.getDechromedContentMode());
            }
            return super.beginTag(namespace, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException {
            XMLParsingContext theContext = this.theStream.getContext();
            String theTag = theContext.getLocalname();
            if (theTag.equals("ttl")) {
                this.ttlValue = ((XMLStringParsingContext)theContext).getValue();
            } else if (theTag.equals("item")) {
                RSSItemContextClass itemContext = (RSSItemContextClass)theContext;
                itemContext.process(this.documentIdentifier, this.activities, this.filter);
            } else {
                super.endTag();
            }
        }

        protected boolean process() throws ManifoldCFException {
            Long minimumTime;
            long currentTime = System.currentTimeMillis();
            Long rescanTime = this.filter.getDefaultRescanTime(currentTime);
            if (this.ttlValue != null) {
                try {
                    int minutes = Integer.parseInt(this.ttlValue);
                    long nextTime = currentTime + (long)minutes * 60000L;
                    rescanTime = new Long(nextTime);
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("RSS: In RSS document '" + this.documentIdentifier + "', found a ttl value of " + this.ttlValue + "; setting refetch time accordingly"));
                    }
                }
                catch (NumberFormatException e) {
                    Logging.connectors.warn((Object)("RSS: RSS document '" + this.documentIdentifier + "' has illegal ttl value '" + this.ttlValue + "'"));
                }
            }
            if (rescanTime != null && (minimumTime = this.filter.getMinimumRescanTime(currentTime)) != null && rescanTime < minimumTime) {
                rescanTime = minimumTime;
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("RSS: In RSS document '" + this.documentIdentifier + "' setting rescan time to " + (rescanTime == null ? "null" : rescanTime.toString())));
            }
            this.activities.setDocumentScheduleBounds(this.documentIdentifier, rescanTime, rescanTime, null, null);
            return true;
        }
    }

    protected class RSSContextClass
    extends XMLParsingContext {
        protected String documentIdentifier;
        protected IProcessActivity activities;
        protected Filter filter;
        protected boolean rescanTimeSet;

        public RSSContextClass(XMLFuzzyHierarchicalParseState theStream, String namespace, String localName, String qName, Map<String, String> atts, String documentIdentifier, IProcessActivity activities, Filter filter) {
            super(theStream, namespace, localName, qName, atts);
            this.rescanTimeSet = false;
            this.documentIdentifier = documentIdentifier;
            this.activities = activities;
            this.filter = filter;
        }

        protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
            if (localName.equals("channel")) {
                return new RSSChannelContextClass(this.theStream, namespace, localName, qName, atts, this.documentIdentifier, this.activities, this.filter);
            }
            return super.beginTag(namespace, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException {
            XMLParsingContext context = this.theStream.getContext();
            String tagName = context.getLocalname();
            if (tagName.equals("channel")) {
                this.rescanTimeSet = ((RSSChannelContextClass)context).process();
            } else {
                super.endTag();
            }
        }

        protected boolean process() throws ManifoldCFException {
            return this.rescanTimeSet;
        }
    }

    protected class OuterContextClass
    extends XMLParsingContext {
        protected int outerTagCount;
        protected String documentIdentifier;
        protected IProcessActivity activities;
        protected Filter filter;
        protected boolean rescanTimeSet;

        public OuterContextClass(XMLFuzzyHierarchicalParseState theStream, String documentIdentifier, IProcessActivity activities, Filter filter) {
            super(theStream);
            this.outerTagCount = 0;
            this.rescanTimeSet = false;
            this.documentIdentifier = documentIdentifier;
            this.activities = activities;
            this.filter = filter;
        }

        public void checkIfValidFeed() {
            if (this.outerTagCount == 0 && Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("RSS: RSS document '" + this.documentIdentifier + "' does not have rss, feed, or rdf:RDF tag - not valid feed"));
            }
        }

        public void setDefaultRescanTimeIfNeeded() throws ManifoldCFException {
            if (!this.rescanTimeSet) {
                long currentTime = System.currentTimeMillis();
                Long rescanTime = this.filter.getBadFeedRescanTime(currentTime);
                if (rescanTime == null) {
                    rescanTime = this.filter.getDefaultRescanTime(currentTime);
                }
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("RSS: In RSS document '" + this.documentIdentifier + "' setting default rescan time to " + (rescanTime == null ? "null" : rescanTime.toString())));
                }
                this.activities.setDocumentScheduleBounds(this.documentIdentifier, rescanTime, rescanTime, null, null);
                this.rescanTimeSet = true;
            }
        }

        protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
            if (localName.equals("rss")) {
                ++this.outerTagCount;
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("RSS: Parsed bottom-level XML for RSS document '" + this.documentIdentifier + "'"));
                }
                return new RSSContextClass(this.theStream, namespace, localName, qName, atts, this.documentIdentifier, this.activities, this.filter);
            }
            if (localName.toLowerCase(Locale.ROOT).equals("rdf")) {
                ++this.outerTagCount;
                return new RDFContextClass(this.theStream, namespace, localName, qName, atts, this.documentIdentifier, this.activities, this.filter);
            }
            if (localName.equals("feed")) {
                ++this.outerTagCount;
                return new FeedContextClass(this.theStream, namespace, localName, qName, atts, this.documentIdentifier, this.activities, this.filter);
            }
            if (localName.equals("urlset") || localName.equals("sitemapindex")) {
                ++this.outerTagCount;
                return new UrlsetContextClass(this.theStream, namespace, localName, qName, atts, this.documentIdentifier, this.activities, this.filter);
            }
            return super.beginTag(namespace, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException {
            XMLParsingContext context = this.theStream.getContext();
            String tagName = context.getLocalname();
            if (tagName.equals("rss")) {
                this.rescanTimeSet = ((RSSContextClass)context).process();
            } else if (tagName.toLowerCase(Locale.ROOT).equals("rdf")) {
                this.rescanTimeSet = ((RDFContextClass)context).process();
            } else if (tagName.equals("feed")) {
                this.rescanTimeSet = ((FeedContextClass)context).process();
            } else if (tagName.equals("urlset") || tagName.equals("sitemapindex")) {
                this.rescanTimeSet = ((UrlsetContextClass)context).process();
            } else {
                super.endTag();
            }
        }
    }
}

