/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.partition;

import java.io.IOException;
import org.slf4j.Logger;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.DateExtractor;
import thredds.inventory.MFile;
import thredds.inventory.MFileIterator;
import thredds.inventory.partition.DirectoryBuilder;
import thredds.inventory.partition.IndexReader;
import ucar.nc2.util.CloseableIterator;

class DirectoryCollectionFromIndex
extends CollectionAbstract {
    final DirectoryBuilder builder;
    final IndexReader indexReader;

    DirectoryCollectionFromIndex(DirectoryBuilder builder, DateExtractor dateExtractor, IndexReader indexReader, Logger logger) {
        super(builder.getPartitionName(), logger);
        this.setDateExtractor(dateExtractor);
        this.setRoot(builder.getDir().toString());
        this.builder = builder;
        this.indexReader = indexReader;
    }

    @Override
    public CloseableIterator<MFile> getFileIterator() throws IOException {
        return new MFileIterator(this.getFilesSorted().iterator(), this.filter);
    }

    @Override
    public String getRoot() {
        return this.builder.getDir().toString();
    }

    @Override
    public void close() {
    }

    @Override
    public Iterable<MFile> getFilesSorted() throws IOException {
        return this.builder.readFilesFromIndex(this.indexReader);
    }
}

