/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import net.jpountz.xxhash.XXHash32;
import net.jpountz.xxhash.XXHashFactory;
import org.apache.kafka.common.message.KafkaLZ4BlockOutputStream;
import org.apache.kafka.common.utils.Utils;

public final class KafkaLZ4BlockInputStream
extends FilterInputStream {
    public static final String PREMATURE_EOS = "Stream ended prematurely";
    public static final String NOT_SUPPORTED = "Stream unsupported";
    public static final String BLOCK_HASH_MISMATCH = "Block checksum mismatch";
    public static final String DESCRIPTOR_HASH_MISMATCH = "Stream frame descriptor corrupted";
    private final LZ4SafeDecompressor decompressor = LZ4Factory.fastestInstance().safeDecompressor();
    private final XXHash32 checksum = XXHashFactory.fastestInstance().hash32();
    private final byte[] buffer;
    private final byte[] compressedBuffer;
    private final int maxBlockSize;
    private KafkaLZ4BlockOutputStream.FLG flg;
    private KafkaLZ4BlockOutputStream.BD bd;
    private int bufferOffset;
    private int bufferSize;
    private boolean finished;

    public KafkaLZ4BlockInputStream(InputStream in) throws IOException {
        super(in);
        this.readHeader();
        this.maxBlockSize = this.bd.getBlockMaximumSize();
        this.buffer = new byte[this.maxBlockSize];
        this.compressedBuffer = new byte[this.maxBlockSize];
        this.bufferOffset = 0;
        this.bufferSize = 0;
        this.finished = false;
    }

    private void readHeader() throws IOException {
        byte[] header = new byte[19];
        this.bufferOffset = 6;
        if (this.in.read(header, 0, this.bufferOffset) != this.bufferOffset) {
            throw new IOException(PREMATURE_EOS);
        }
        if (407708164 != Utils.readUnsignedIntLE(header, this.bufferOffset - 6)) {
            throw new IOException(NOT_SUPPORTED);
        }
        this.flg = KafkaLZ4BlockOutputStream.FLG.fromByte(header[this.bufferOffset - 2]);
        this.bd = KafkaLZ4BlockOutputStream.BD.fromByte(header[this.bufferOffset - 1]);
        byte hash = (byte)(this.checksum.hash(header, 0, this.bufferOffset, 0) >> 8 & 0xFF);
        header[this.bufferOffset++] = (byte)this.in.read();
        if (hash != header[this.bufferOffset - 1]) {
            throw new IOException(DESCRIPTOR_HASH_MISMATCH);
        }
    }

    private void readBlock() throws IOException {
        byte[] bufferToRead;
        boolean compressed;
        int blockSize = Utils.readUnsignedIntLE(this.in);
        if (blockSize == 0) {
            this.finished = true;
            return;
        }
        if (blockSize > this.maxBlockSize) {
            throw new IOException(String.format("Block size %s exceeded max: %s", blockSize, this.maxBlockSize));
        }
        boolean bl = compressed = (blockSize & Integer.MIN_VALUE) == 0;
        if (compressed) {
            bufferToRead = this.compressedBuffer;
        } else {
            bufferToRead = this.buffer;
            this.bufferSize = blockSize &= Integer.MAX_VALUE;
        }
        if (this.in.read(bufferToRead, 0, blockSize) != blockSize) {
            throw new IOException(PREMATURE_EOS);
        }
        if (this.flg.isBlockChecksumSet() && Utils.readUnsignedIntLE(this.in) != this.checksum.hash(bufferToRead, 0, blockSize, 0)) {
            throw new IOException(BLOCK_HASH_MISMATCH);
        }
        if (compressed) {
            try {
                this.bufferSize = this.decompressor.decompress(this.compressedBuffer, 0, blockSize, this.buffer, 0, this.maxBlockSize);
            }
            catch (LZ4Exception e) {
                throw new IOException(e);
            }
        }
        this.bufferOffset = 0;
    }

    @Override
    public int read() throws IOException {
        if (this.finished) {
            return -1;
        }
        if (this.available() == 0) {
            this.readBlock();
        }
        if (this.finished) {
            return -1;
        }
        int value = this.buffer[this.bufferOffset++] & 0xFF;
        return value;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        net.jpountz.util.Utils.checkRange((byte[])b, (int)off, (int)len);
        if (this.finished) {
            return -1;
        }
        if (this.available() == 0) {
            this.readBlock();
        }
        if (this.finished) {
            return -1;
        }
        len = Math.min(len, this.available());
        System.arraycopy(this.buffer, this.bufferOffset, b, off, len);
        this.bufferOffset += len;
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.finished) {
            return 0L;
        }
        if (this.available() == 0) {
            this.readBlock();
        }
        if (this.finished) {
            return 0L;
        }
        n = Math.min(n, (long)this.available());
        this.bufferOffset = (int)((long)this.bufferOffset + n);
        return n;
    }

    @Override
    public int available() throws IOException {
        return this.bufferSize - this.bufferOffset;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new RuntimeException("mark not supported");
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new RuntimeException("reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

