/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import org.apache.kafka.common.TopicPartition;

public final class ConsumerRecord<K, V> {
    private final TopicPartition partition;
    private final K key;
    private final V value;
    private final long offset;
    private volatile Exception error;

    public ConsumerRecord(String topic, int partitionId, K key, V value, long offset) {
        this(topic, partitionId, key, value, offset, null);
    }

    public ConsumerRecord(String topic, int partitionId, V value, long offset) {
        this(topic, partitionId, null, value, offset);
    }

    public ConsumerRecord(String topic, int partitionId, Exception error) {
        this(topic, partitionId, null, null, -1L, error);
    }

    private ConsumerRecord(String topic, int partitionId, K key, V value, long offset, Exception error) {
        if (topic == null) {
            throw new IllegalArgumentException("Topic cannot be null");
        }
        this.partition = new TopicPartition(topic, partitionId);
        this.key = key;
        this.value = value;
        this.offset = offset;
        this.error = error;
    }

    public String topic() {
        return this.partition.topic();
    }

    public int partition() {
        return this.partition.partition();
    }

    public TopicPartition topicAndPartition() {
        return this.partition;
    }

    public K key() throws Exception {
        if (this.error != null) {
            throw this.error;
        }
        return this.key;
    }

    public V value() throws Exception {
        if (this.error != null) {
            throw this.error;
        }
        return this.value;
    }

    public long offset() throws Exception {
        if (this.error != null) {
            throw this.error;
        }
        return this.offset;
    }

    public Exception error() {
        return this.error;
    }
}

