/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.tools;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.impl.tools.planexporter.AccessDatabase;
import org.apache.derby.impl.tools.planexporter.CreateHTMLFile;
import org.apache.derby.impl.tools.planexporter.CreateXMLFile;

public class PlanExporter {
    private static String dbURL = null;
    private static String xslStyleSheetName = "resources/vanilla_html.xsl";
    private static final int XML = 1;
    private static final int HTML = 2;
    private static final int XSL = 3;

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length > 4 && stringArray.length < 10) {
                dbURL = stringArray[0];
                AccessDatabase accessDatabase = new AccessDatabase(dbURL, stringArray[1], stringArray[2]);
                if (accessDatabase.verifySchemaExistance()) {
                    if (accessDatabase.initializeDataArray()) {
                        accessDatabase.createXMLFragment();
                        accessDatabase.markTheDepth();
                        String string = accessDatabase.statement();
                        String string2 = accessDatabase.time();
                        accessDatabase.closeConnection();
                        if (stringArray.length == 8 && stringArray[3].equalsIgnoreCase("-adv")) {
                            int n = PlanExporter.selectArg(stringArray[4]);
                            int n2 = PlanExporter.selectArg(stringArray[6]);
                            if (n == 1 && n2 == 3) {
                                if (stringArray[7].toUpperCase().endsWith(".XSL")) {
                                    PlanExporter.generateXML(accessDatabase, stringArray[5], string, string2, stringArray[7]);
                                } else {
                                    PlanExporter.generateXML(accessDatabase, stringArray[5], string, string2, stringArray[7] + ".xsl");
                                }
                            } else if (n == 3 && n2 == 1) {
                                if (stringArray[5].toUpperCase().endsWith(".XSL")) {
                                    PlanExporter.generateXML(accessDatabase, stringArray[7], string, string2, stringArray[5]);
                                } else {
                                    PlanExporter.generateXML(accessDatabase, stringArray[7], string, string2, stringArray[5] + ".xsl");
                                }
                            } else {
                                PlanExporter.printHelp();
                            }
                        } else if (stringArray.length == 5) {
                            int n = PlanExporter.selectArg(stringArray[3]);
                            if (n == 0 || n == 3) {
                                PlanExporter.printHelp();
                            } else if (n == 1) {
                                PlanExporter.generateXML(accessDatabase, stringArray[4], string, string2, null);
                            } else {
                                PlanExporter.generateXML(accessDatabase, "temp.xml", string, string2, null);
                                PlanExporter.generateHTML("temp.xml", stringArray[4], xslStyleSheetName, true);
                                PlanExporter.deleteFile("temp.xml");
                            }
                        } else if (stringArray.length == 7) {
                            int n = PlanExporter.selectArg(stringArray[3]);
                            int n3 = PlanExporter.selectArg(stringArray[5]);
                            if (n == 0 || n3 == 0) {
                                PlanExporter.printHelp();
                            } else if (n == 1 && n3 == 2) {
                                PlanExporter.generateXML(accessDatabase, stringArray[4], string, string2, null);
                                PlanExporter.generateHTML(stringArray[4], stringArray[6], xslStyleSheetName, true);
                            } else if (n == 2 && n3 == 1) {
                                PlanExporter.generateXML(accessDatabase, stringArray[6], string, string2, null);
                                PlanExporter.generateHTML(stringArray[6], stringArray[4], xslStyleSheetName, true);
                            } else if (n == 2 && n3 == 3) {
                                PlanExporter.generateXML(accessDatabase, "temp.xml", string, string2, null);
                                PlanExporter.generateHTML("temp.xml", stringArray[4], stringArray[6], false);
                                PlanExporter.deleteFile("temp.xml");
                            } else if (n == 3 && n3 == 2) {
                                PlanExporter.generateXML(accessDatabase, "temp.xml", string, string2, null);
                                PlanExporter.generateHTML("temp.xml", stringArray[6], stringArray[4], false);
                                PlanExporter.deleteFile("temp.xml");
                            } else {
                                PlanExporter.printHelp();
                            }
                        } else if (stringArray.length == 9) {
                            int n = PlanExporter.selectArg(stringArray[3]);
                            int n4 = PlanExporter.selectArg(stringArray[5]);
                            int n5 = PlanExporter.selectArg(stringArray[7]);
                            if (n == 0 || n4 == 0 || n5 == 0) {
                                PlanExporter.printHelp();
                            } else if (n == 1 && n4 == 2 && n5 == 3) {
                                PlanExporter.generateXML(accessDatabase, stringArray[4], string, string2, null);
                                PlanExporter.generateHTML(stringArray[4], stringArray[6], stringArray[8], false);
                            } else if (n == 2 && n4 == 3 && n5 == 1) {
                                PlanExporter.generateXML(accessDatabase, stringArray[8], string, string2, null);
                                PlanExporter.generateHTML(stringArray[8], stringArray[4], stringArray[6], false);
                            } else if (n == 3 && n4 == 1 && n5 == 2) {
                                PlanExporter.generateXML(accessDatabase, stringArray[6], string, string2, null);
                                PlanExporter.generateHTML(stringArray[6], stringArray[8], stringArray[4], false);
                            } else if (n == 1 && n4 == 3 && n5 == 2) {
                                PlanExporter.generateXML(accessDatabase, stringArray[4], string, string2, null);
                                PlanExporter.generateHTML(stringArray[4], stringArray[8], stringArray[6], false);
                            } else if (n == 2 && n4 == 1 && n5 == 3) {
                                PlanExporter.generateXML(accessDatabase, stringArray[6], string, string2, null);
                                PlanExporter.generateHTML(stringArray[6], stringArray[4], stringArray[8], false);
                            } else if (n == 3 && n4 == 2 && n5 == 1) {
                                PlanExporter.generateXML(accessDatabase, stringArray[8], string, string2, null);
                                PlanExporter.generateHTML(stringArray[8], stringArray[6], stringArray[4], false);
                            } else {
                                PlanExporter.printHelp();
                            }
                        } else {
                            PlanExporter.printHelp();
                        }
                    } else {
                        System.out.println("====================================================\n--- An Error Occured: No Statistics has Captured ---\n-- Possible reasons:                              --\n-- 1) The statement executed is a DDL statement.  --\n-- Statistics will not capture for DDL statements --\n-- by the Derby.                                  --\n-- 2) The statement ID entered is incorrect.      --\n-- 3) Schema specified does not exist.            --\n====================================================\n");
                    }
                } else {
                    System.out.println("====================================================\n---              An Error Occured:               ---\n-------   Specified Schema does not exist.   -------\n======================================================");
                }
            } else {
                PlanExporter.printHelp();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static int selectArg(String string) {
        if (string.equalsIgnoreCase("-xml")) {
            return 1;
        }
        if (string.equalsIgnoreCase("-html")) {
            return 2;
        }
        if (string.equalsIgnoreCase("-xsl")) {
            return 3;
        }
        return 0;
    }

    private static void generateXML(AccessDatabase accessDatabase, String string, String string2, String string3, String string4) throws Exception {
        CreateXMLFile createXMLFile = new CreateXMLFile(accessDatabase);
        if (string.toUpperCase().endsWith(".XML")) {
            createXMLFile.writeTheXMLFile(string2, string3, accessDatabase.getData(), string, string4);
        } else {
            createXMLFile.writeTheXMLFile(string2, string3, accessDatabase.getData(), string.concat(".xml"), string4);
        }
    }

    private static void generateHTML(String string, String string2, String string3, boolean bl) throws Exception {
        CreateHTMLFile createHTMLFile = new CreateHTMLFile();
        if (string.toUpperCase().endsWith(".XML")) {
            createHTMLFile.getHTML(string, string3, string2, bl);
        } else {
            createHTMLFile.getHTML(string.concat(".xml"), string3, string2, bl);
        }
    }

    private static void printHelp() {
        System.out.println("================================================\n-------------- PlanExporter Tool ---------------\n--   You can pass 5 arguments (minimum), or   --\n--       7 arguments or 8 arguments or        --\n-----------  9 arguments (maximum)  ------------\n--         separated by a space.              --\n---------------Mandatory Arguments--------------\n1) database URL --------------------------------\n2) database schema -----------------------------\n3) statement ID (36 characters) ----------------\n---------------Optional Arguments---------------\n-----------Choose at least one option-----------\na) -xml {pathToXML} or -html {pathToHTML} ------\nb) -xml {pathToXML} -html {pathToHTML} ---------\nc) -xsl {pathToXSL} -html {pathToHTML} ---------\nd) -xml {pathToXML} -xsl {pathToXSL} -----------\n      -html {pathToHTML} -----------------------\ne) -adv -xml {pathToXML} -xsl {pathToXSL} ------\n================================================\n");
    }

    private static void deleteFile(final String string) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File file = new File(string);
                if (!file.exists()) {
                    return null;
                }
                file.delete();
                return null;
            }
        });
    }
}

