/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.debug;

import java.lang.reflect.Method;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import org.apache.juneau.Enablement;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestOpContext;
import org.apache.juneau.rest.debug.DebugEnablement;
import org.apache.juneau.utils.ReflectionMap;

public class BasicDebugEnablement
implements DebugEnablement {
    private final Enablement defaultEnablement;
    private final ReflectionMap<Enablement> enablementMap;
    private final Predicate<HttpServletRequest> conditionalPredicate;

    public BasicDebugEnablement(DebugEnablement.Builder builder) {
        this.defaultEnablement = (Enablement)ObjectUtils.firstNonNull((Object[])new Enablement[]{builder.defaultEnablement, Enablement.NEVER});
        this.enablementMap = builder.mapBuilder.build();
        this.conditionalPredicate = (Predicate)ObjectUtils.firstNonNull((Object[])new Predicate[]{builder.conditional, x -> "true".equalsIgnoreCase(x.getHeader("Debug"))});
    }

    @Override
    public boolean isDebug(RestOpContext context, HttpServletRequest req) {
        Method m = context.getJavaMethod();
        Enablement e = this.enablementMap.find(m).orElse(this.enablementMap.find(m.getDeclaringClass()).orElse(this.defaultEnablement));
        return e == Enablement.ALWAYS || e == Enablement.CONDITIONAL && this.isConditionallyEnabled(req);
    }

    @Override
    public boolean isDebug(RestContext context, HttpServletRequest req) {
        Class<?> c = context.getResourceClass();
        Enablement e = this.enablementMap.find(c).orElse(this.defaultEnablement);
        return e == Enablement.ALWAYS || e == Enablement.CONDITIONAL && this.isConditionallyEnabled(req);
    }

    protected boolean isConditionallyEnabled(HttpServletRequest req) {
        return this.conditionalPredicate.test(req);
    }

    public String toString() {
        return JsonMap.filteredMap().append("defaultEnablement", (Object)this.defaultEnablement).append("enablementMap", this.enablementMap).append("conditionalPredicate", this.conditionalPredicate).asString();
    }
}

