/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.ParameterInfo;
import org.apache.juneau.dto.swagger.ResponseInfo;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.http.header.MediaType;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.internal.StringUtils;

@Bean(properties="operationId,summary,description,tags,externalDocs,consumes,produces,parameters,responses,schemes,deprecated,security,*")
@FluentSetters
public class Operation
extends SwaggerElement {
    private String summary;
    private String description;
    private String operationId;
    private Boolean deprecated;
    private ExternalDocumentation externalDocs;
    private Set<String> tags;
    private Set<String> schemes;
    private Set<MediaType> consumes;
    private Set<MediaType> produces;
    private List<ParameterInfo> parameters;
    private List<Map<String, List<String>>> security;
    private Map<String, ResponseInfo> responses;

    public Operation() {
    }

    public Operation(Operation copyFrom) {
        super(copyFrom);
        this.consumes = CollectionUtils.copyOf(copyFrom.consumes);
        this.deprecated = copyFrom.deprecated;
        this.description = copyFrom.description;
        this.externalDocs = copyFrom.externalDocs == null ? null : copyFrom.externalDocs.copy();
        this.operationId = copyFrom.operationId;
        this.produces = CollectionUtils.copyOf(copyFrom.produces);
        this.schemes = CollectionUtils.copyOf(copyFrom.schemes);
        this.summary = copyFrom.summary;
        this.tags = CollectionUtils.copyOf(copyFrom.tags);
        if (copyFrom.parameters == null) {
            this.parameters = null;
        } else {
            this.parameters = CollectionUtils.list((Object[])new ParameterInfo[0]);
            copyFrom.parameters.forEach(x -> this.parameters.add(x.copy()));
        }
        if (copyFrom.responses == null) {
            this.responses = null;
        } else {
            this.responses = CollectionUtils.map();
            copyFrom.responses.forEach((k, v) -> this.responses.put((String)k, v.copy()));
        }
        if (copyFrom.security == null) {
            this.security = null;
        } else {
            this.security = CollectionUtils.list((Object[])new Map[0]);
            copyFrom.security.forEach(x -> {
                LinkedHashMap m2 = CollectionUtils.map();
                x.forEach((k, v) -> {
                    List cfr_ignored_0 = m2.put(k, CollectionUtils.copyOf((List)v));
                });
                this.security.add(m2);
            });
        }
    }

    public Operation copy() {
        return new Operation(this);
    }

    public Set<MediaType> getConsumes() {
        return this.consumes;
    }

    public Operation setConsumes(Collection<MediaType> value) {
        this.consumes = CollectionUtils.setFrom(value);
        return this;
    }

    public Operation setConsumes(MediaType ... value) {
        return this.setConsumes(Arrays.asList(value));
    }

    public Operation addConsumes(MediaType ... value) {
        this.setConsumes(CollectionUtils.setBuilder(MediaType.class, (Type[])new Type[0]).sparse().add((Object[])value).build());
        return this;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public boolean isDeprecated() {
        return this.deprecated != null && this.deprecated == true;
    }

    public Operation setDeprecated(Boolean value) {
        this.deprecated = value;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Operation setDescription(String value) {
        this.description = value;
        return this;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public Operation setExternalDocs(ExternalDocumentation value) {
        this.externalDocs = value;
        return this;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public Operation setOperationId(String value) {
        this.operationId = value;
        return this;
    }

    public List<ParameterInfo> getParameters() {
        return this.parameters;
    }

    public ParameterInfo getParameter(String in, String name) {
        if (this.parameters != null) {
            for (ParameterInfo pi : this.parameters) {
                if (!StringUtils.eq((String)pi.getIn(), (String)in) || !StringUtils.eq((String)pi.getName(), (String)name) && !"body".equals(pi.getIn())) continue;
                return pi;
            }
        }
        return null;
    }

    public Operation setParameters(Collection<ParameterInfo> value) {
        this.parameters = CollectionUtils.listFrom(value);
        return this;
    }

    public Operation setParameters(ParameterInfo ... value) {
        return this.setParameters(Arrays.asList(value));
    }

    public Operation addParameters(ParameterInfo ... value) {
        this.setParameters(CollectionUtils.listBuilder(ParameterInfo.class, (Type[])new Type[0]).sparse().add((Object[])value).build());
        return this;
    }

    public Set<MediaType> getProduces() {
        return this.produces;
    }

    public Operation setProduces(Collection<MediaType> value) {
        this.produces = CollectionUtils.setFrom(value);
        return this;
    }

    public Operation setProduces(MediaType ... value) {
        return this.setProduces(Arrays.asList(value));
    }

    public Operation addProduces(MediaType ... value) {
        this.setProduces(CollectionUtils.setBuilder(MediaType.class, (Type[])new Type[0]).sparse().add((Object[])value).build());
        return this;
    }

    public Map<String, ResponseInfo> getResponses() {
        return this.responses;
    }

    public ResponseInfo getResponse(String status) {
        if (this.responses != null) {
            return this.responses.get(status);
        }
        return null;
    }

    public ResponseInfo getResponse(int status) {
        return this.getResponse(String.valueOf(status));
    }

    public Operation setResponses(Map<String, ResponseInfo> value) {
        this.responses = CollectionUtils.copyOf(value);
        return this;
    }

    public Operation addResponse(String statusCode, ResponseInfo response) {
        this.responses = CollectionUtils.mapBuilder(this.responses).add((Object)statusCode, (Object)response).build();
        return this;
    }

    public Set<String> getSchemes() {
        return this.schemes;
    }

    public Operation setSchemes(Collection<String> value) {
        this.schemes = CollectionUtils.setFrom(value);
        return this;
    }

    public Operation addSchemes(String ... value) {
        this.setSchemes(CollectionUtils.setBuilder(String.class, (Type[])new Type[0]).sparse().addJson(value).build());
        return this;
    }

    public List<Map<String, List<String>>> getSecurity() {
        return this.security;
    }

    public Operation setSecurity(Collection<Map<String, List<String>>> value) {
        this.security = CollectionUtils.listFrom(value);
        return this;
    }

    public Operation addSecurity(String scheme, String ... alternatives) {
        LinkedHashMap m = CollectionUtils.map();
        m.put(scheme, CollectionUtils.alist((Object[])alternatives));
        this.security = CollectionUtils.listBuilder(this.security).add((Object)m).build();
        return this;
    }

    public String getSummary() {
        return this.summary;
    }

    public Operation setSummary(String value) {
        this.summary = value;
        return this;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public Operation setTags(Collection<String> value) {
        this.tags = CollectionUtils.setFrom(value);
        return this;
    }

    public Operation setTags(String ... value) {
        this.setTags(CollectionUtils.setBuilder(String.class, (Type[])new Type[0]).sparse().add((Object[])value).build());
        return this;
    }

    public Operation addTags(String ... value) {
        this.setTags(CollectionUtils.setBuilder(this.tags).sparse().add((Object[])value).build());
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "consumes": {
                return (T)ConverterUtils.toType(this.getConsumes(), type);
            }
            case "deprecated": {
                return (T)ConverterUtils.toType((Object)this.getDeprecated(), type);
            }
            case "description": {
                return (T)ConverterUtils.toType((Object)this.getDescription(), type);
            }
            case "externalDocs": {
                return (T)ConverterUtils.toType((Object)this.getExternalDocs(), type);
            }
            case "operationId": {
                return (T)ConverterUtils.toType((Object)this.getOperationId(), type);
            }
            case "parameters": {
                return (T)ConverterUtils.toType(this.getParameters(), type);
            }
            case "produces": {
                return (T)ConverterUtils.toType(this.getProduces(), type);
            }
            case "responses": {
                return (T)ConverterUtils.toType(this.getResponses(), type);
            }
            case "schemes": {
                return (T)ConverterUtils.toType(this.getSchemes(), type);
            }
            case "security": {
                return (T)ConverterUtils.toType(this.getSecurity(), type);
            }
            case "summary": {
                return (T)ConverterUtils.toType((Object)this.getSummary(), type);
            }
            case "tags": {
                return (T)ConverterUtils.toType(this.getTags(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public Operation set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "consumes": {
                return this.setConsumes(CollectionUtils.listBuilder(MediaType.class, (Type[])new Type[0]).sparse().addAny(new Object[]{value}).build());
            }
            case "deprecated": {
                return this.setDeprecated(ConverterUtils.toBoolean((Object)value));
            }
            case "description": {
                return this.setDescription(StringUtils.stringify((Object)value));
            }
            case "externalDocs": {
                return this.setExternalDocs((ExternalDocumentation)ConverterUtils.toType((Object)value, ExternalDocumentation.class));
            }
            case "operationId": {
                return this.setOperationId(StringUtils.stringify((Object)value));
            }
            case "parameters": {
                return this.setParameters(CollectionUtils.listBuilder(ParameterInfo.class, (Type[])new Type[0]).sparse().addAny(new Object[]{value}).build());
            }
            case "produces": {
                return this.setProduces(CollectionUtils.listBuilder(MediaType.class, (Type[])new Type[0]).sparse().addAny(new Object[]{value}).build());
            }
            case "responses": {
                return this.setResponses(CollectionUtils.mapBuilder(String.class, ResponseInfo.class, (Type[])new Type[0]).sparse().addAny(new Object[]{value}).build());
            }
            case "schemes": {
                return this.setSchemes(CollectionUtils.listBuilder(String.class, (Type[])new Type[0]).sparse().addAny(new Object[]{value}).build());
            }
            case "security": {
                return this.setSecurity(CollectionUtils.listBuilder(Map.class, (Type[])new Type[]{String.class, List.class, String.class}).sparse().addAny(new Object[]{value}).build());
            }
            case "summary": {
                return this.setSummary(StringUtils.stringify((Object)value));
            }
            case "tags": {
                return this.setTags(CollectionUtils.listBuilder(String.class, (Type[])new Type[0]).sparse().addAny(new Object[]{value}).build());
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setBuilder(String.class, (Type[])new Type[0]).addIf(this.consumes != null, (Object)"consumes").addIf(this.deprecated != null, (Object)"deprecated").addIf(this.description != null, (Object)"description").addIf(this.externalDocs != null, (Object)"externalDocs").addIf(this.operationId != null, (Object)"operationId").addIf(this.parameters != null, (Object)"parameters").addIf(this.produces != null, (Object)"produces").addIf(this.responses != null, (Object)"responses").addIf(this.schemes != null, (Object)"schemes").addIf(this.security != null, (Object)"security").addIf(this.summary != null, (Object)"summary").addIf(this.tags != null, (Object)"tags").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }
}

