/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.swaps;

import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.swap.StringSwap;

public abstract class ByteArraySwap
extends StringSwap<byte[]> {

    public static class SpacedHex
    extends ByteArraySwap {
        @Override
        public String swap(BeanSession session, byte[] b) throws Exception {
            return StringUtils.toSpacedHex(b);
        }

        @Override
        public byte[] unswap(BeanSession session, String s, ClassMeta<?> hint) throws Exception {
            return StringUtils.fromSpacedHex(s);
        }
    }

    public static class Hex
    extends ByteArraySwap {
        @Override
        public String swap(BeanSession session, byte[] b) throws Exception {
            return StringUtils.toHex(b);
        }

        @Override
        public byte[] unswap(BeanSession session, String s, ClassMeta<?> hint) throws Exception {
            return StringUtils.fromHex(s);
        }
    }

    public static class Base64
    extends ByteArraySwap {
        @Override
        public String swap(BeanSession session, byte[] b) throws Exception {
            return StringUtils.base64Encode(b);
        }

        @Override
        public byte[] unswap(BeanSession session, String s, ClassMeta<?> hint) throws Exception {
            return StringUtils.base64Decode(s);
        }
    }
}

