/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.DateUtils;
import org.apache.juneau.rest.util.FinishableServletOutputStream;

public class MockServletResponse
implements HttpServletResponse {
    private String characterEncoding = "UTF-8";
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private int bufferSize = 0;
    private Locale locale;
    private int sc;
    private String msg;
    private Map<String, String[]> headerMap = CollectionUtils.map();

    public static MockServletResponse create() {
        return new MockServletResponse();
    }

    public String getMessage() {
        return this.msg;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new FinishableServletOutputStream(this.baos);
    }

    public PrintWriter getWriter() throws IOException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), this.characterEncoding));
    }

    public void setCharacterEncoding(String charset) {
        this.characterEncoding = charset;
        this.updateContentTypeHeader();
    }

    private void updateContentTypeHeader() {
        String contentType = this.getContentType();
        String charset = this.characterEncoding;
        if (contentType != null && charset != null) {
            if (contentType.indexOf("charset=") != -1) {
                contentType = contentType.replaceAll("\\;\\s*charset=.*", "");
            }
            if (!"UTF-8".equalsIgnoreCase(charset)) {
                contentType = contentType + ";charset=" + charset;
            }
            this.header("Content-Type", contentType);
        }
    }

    public void setContentLength(int len) {
        this.header("Content-Length", String.valueOf(len));
    }

    public void setContentLengthLong(long len) {
        this.header("Content-Length", String.valueOf(len));
    }

    public void setContentType(String type) {
        this.setHeader("Content-Type", type);
        this.updateContentTypeHeader();
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void flushBuffer() throws IOException {
    }

    public void resetBuffer() {
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void addCookie(Cookie cookie) {
    }

    public boolean containsHeader(String name) {
        return this.getHeader(name) != null;
    }

    public String encodeURL(String url) {
        return null;
    }

    public String encodeRedirectURL(String url) {
        return null;
    }

    public String encodeUrl(String url) {
        return null;
    }

    public String encodeRedirectUrl(String url) {
        return null;
    }

    public void sendError(int sc, String msg) throws IOException {
        this.sc = sc;
        this.msg = msg;
    }

    public void sendError(int sc) throws IOException {
        this.sc = sc;
    }

    public void sendRedirect(String location) throws IOException {
        this.sc = 302;
        this.headerMap.put("Location", new String[]{location});
    }

    public void setDateHeader(String name, long date) {
        this.headerMap.put(name, new String[]{DateUtils.formatDate(new Date(date), "EEE, dd MMM yyyy HH:mm:ss zzz")});
    }

    public void addDateHeader(String name, long date) {
        this.headerMap.put(name, new String[]{DateUtils.formatDate(new Date(date), "EEE, dd MMM yyyy HH:mm:ss zzz")});
    }

    public void setHeader(String name, String value) {
        this.headerMap.put(name, new String[]{value});
    }

    public void addHeader(String name, String value) {
        this.headerMap.put(name, new String[]{value});
    }

    public MockServletResponse header(String name, String value) {
        this.setHeader(name, value);
        return this;
    }

    public void setIntHeader(String name, int value) {
        this.headerMap.put(name, new String[]{String.valueOf(value)});
    }

    public void addIntHeader(String name, int value) {
        this.headerMap.put(name, new String[]{String.valueOf(value)});
    }

    public void setStatus(int sc) {
        this.sc = sc;
    }

    public MockServletResponse status(int value) {
        this.setStatus(value);
        return this;
    }

    public void setStatus(int sc, String sm) {
        this.sc = sc;
        this.msg = sm;
    }

    public int getStatus() {
        return this.sc;
    }

    public String getHeader(String name) {
        String[] s = this.headerMap.get(name);
        return s == null || s.length == 0 ? null : s[0];
    }

    public Collection<String> getHeaders(String name) {
        String[] s = this.headerMap.get(name);
        return s == null ? CollectionUtils.emptyList() : CollectionUtils.ulist(s);
    }

    public Collection<String> getHeaderNames() {
        return this.headerMap.keySet();
    }

    byte[] getContent() throws IOException {
        this.baos.flush();
        return this.baos.toByteArray();
    }

    Map<String, String[]> getHeaders() {
        return this.headerMap;
    }
}

